/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.singleline;

import com.mapinfo.mapmarker.SWE.parser.SWE_ThoroughfareTypes;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class SWELessCommonStreetTypeInPostAddress
implements Comparator<IAddressParsing> {
    static Set<String> streetTypes = SWE_ThoroughfareTypes.getAllStreetTypes();
    static Set<String> commonTypes = new HashSet<String>();

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean endsWithType2;
        String matchedType1 = this.getStreetTypeEndingFromPostAddress(o1);
        String matchedType2 = this.getStreetTypeEndingFromPostAddress(o2);
        boolean endsWithType1 = matchedType1 != null;
        boolean bl = endsWithType2 = matchedType2 != null;
        if (endsWithType1 && endsWithType2) {
            return this.pickLessCommonType(matchedType1, matchedType2);
        }
        return 0;
    }

    private String getStreetTypeEndingFromPostAddress(IAddressParsing parsing) {
        String postaddress = parsing.getSplit().getAddress().getPostAddress();
        if (postaddress == null) {
            return null;
        }
        return this.getStreetTypeEndingFromPostAddress(postaddress.toUpperCase());
    }

    private String getStreetTypeEndingFromPostAddress(String street) {
        String[] splits = street.split(" ");
        for (String streetType : streetTypes) {
            if (street.endsWith(streetType)) {
                return streetType;
            }
            for (int i = 0; i < splits.length - 1; ++i) {
                if (!splits[i].equals(streetType) && !splits[i].endsWith(streetType)) continue;
                return streetType;
            }
        }
        return null;
    }

    private int pickLessCommonType(String type1, String type2) {
        if (StringUtilities.equalStrings((String)type1, (String)type2)) {
            return 0;
        }
        if (commonTypes.contains(type1) && !commonTypes.contains(type2)) {
            return 1;
        }
        if (!commonTypes.contains(type1) && commonTypes.contains(type2)) {
            return -1;
        }
        return 0;
    }

    static {
        commonTypes.add("GATAN");
        commonTypes.add("VAGEN");
        commonTypes.add("V\u00c4GEN");
    }
}

