/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.XWG.XWG_Handler;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_DataManager;
import com.mapinfo.mapmarker.XWG.singleline.XWG_SingleLineParser;
import com.mapinfo.mapmarker.XWG.singleline.eval.XWG_SingleLineEval;
import com.mapinfo.mapmarker.XWG.utils.XWG_CountryHelper;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.CoreGeocoder;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.ISingleLineResultEval;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;

public class XWGGeocodableAddressFactory
extends GeocodableAddressFactory {
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        XWGGeocodingFactory factory = new XWGGeocodingFactory();
        this.evaluateAddress(address);
        return SingleLineGeocoder.getGeocoder((IGeocoderFactory)factory, (ISingleLineParser)new XWG_SingleLineParser(), (Address)address, (IGeocodeConstraints)constraints, (ISingleLineResultEval)new XWG_SingleLineEval());
    }

    protected void resetSpecificDataManager() throws MMInternalFatalException {
        try {
            XWG_DataManager data = new XWG_DataManager();
            data.reset();
        }
        catch (MMJEDataManagerInitializationException MMJEDMIEx) {
            throw new FatalDataAccessException(2306, (Throwable)MMJEDMIEx);
        }
    }

    protected void evaluateAddress(Address input) {
        if (!XWG_CountryHelper.hasValidCountry(input)) {
            XWG_CountryHelper.makeSingleLine(input);
        }
    }

    private static class XWGGeocodingFactory
    implements IGeocoderFactory {
        private XWGGeocodingFactory() {
        }

        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            return new CoreGeocoder(XWG_Handler.buildHandler(address));
        }
    }
}

