/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.XWG.XWG_AccentHelper;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_SoundexKey;
import com.mapinfo.mapmarker.XWG.parser.XWG_Standardizer;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XWGSoundex
extends Soundex {
    private static final int MAX_SOUNDEX_KEY_LENGTH = 9;
    private static final String DIGITS = "0123456789";
    private static final String CODE_1_BASE_CHARACTERS = "BFPV";
    private static final String CODE_2_BASE_CHARACTERS = "CGJKQSXZ";
    private static final String CODE_3_BASE_CHARACTERS = "DT";
    private static final String CODE_4_BASE_CHARACTERS = "L";
    private static final String CODE_5_BASE_CHARACTERS = "MN";
    private static final String CODE_6_BASE_CHARACTERS = "R";
    private static final String VALID_CODES = "123456";
    private static final int SPECIAL_CASE_INITIALDIGIT = 1;
    private static final int SPECIAL_CASE_NON_LATIN = 2;
    private static final int SPECIAL_CASE_NON_LETTER = 3;
    private static final char NON_LATIN_FIRST_LETTER = '#';
    private static final Map<Character, Integer> m_soundHash;

    private static String findAllAccents(String init) {
        StringBuilder sb = new StringBuilder(init);
        for (char c : init.toCharArray()) {
            String tmp = XWG_AccentHelper.getUppercaseAccentedVersions(c);
            if (tmp == null) continue;
            sb.append(tmp);
        }
        return sb.toString();
    }

    public ISoundexKey getSoundex(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return null;
        }
        String upperCase = XWGSoundex.removeUnwantedCharsAndSpaces(str.toUpperCase());
        if (upperCase == null || upperCase.length() == 0) {
            return null;
        }
        int spCaseType = this.isSpecialCase(upperCase);
        if (spCaseType != 0) {
            return this.handleSpecialCases(spCaseType, upperCase);
        }
        char[] inputStringArray = upperCase.toCharArray();
        int returnCode = 0;
        int base = 1;
        int lastcode = 0;
        int soundexKeysAdded = 0;
        for (int i = 1; i < inputStringArray.length && soundexKeysAdded < 9; ++i) {
            boolean bStartedWithVowel;
            int sdx = XWGSoundex.getSound(inputStringArray[i]);
            boolean bl = bStartedWithVowel = sdx == 0;
            if (bStartedWithVowel) {
                char c;
                while (i < inputStringArray.length - 1 && (Character.isDigit(c = inputStringArray[++i]) || (sdx = XWGSoundex.getSound(c)) == 0)) {
                }
            }
            if (sdx == lastcode && !bStartedWithVowel) continue;
            returnCode += base * sdx;
            base *= 10;
            lastcode = sdx;
            ++soundexKeysAdded;
        }
        return this.buildKey(inputStringArray[0], returnCode);
    }

    public int isSpecialCase(String str) {
        block5: for (int i = 0; i < str.length(); ++i) {
            int type = Character.getType(str.charAt(i));
            switch (type) {
                case 4: 
                case 5: {
                    if (str.charAt(i) == '\u02bb') continue block5;
                    return 2;
                }
                case 9: {
                    if (i == 0) {
                        return 1;
                    }
                }
                case 1: 
                case 2: 
                case 3: 
                case 12: {
                    if (str.charAt(i) <= '\u021b') continue block5;
                    return 2;
                }
                default: {
                    if (i != 0) continue block5;
                    return 3;
                }
            }
        }
        return 0;
    }

    protected ISoundexKey handleSpecialCases(int type, String str) {
        switch (type) {
            case 1: {
                return this.buildKey('0', this.getNumericValue(str));
            }
            case 2: 
            case 3: {
                return this.buildKey('#', this.getAltSoundex(str));
            }
        }
        return null;
    }

    protected int getNumericValue(String str) {
        int code;
        try {
            code = Integer.parseInt(StringUtilities.trimToChars((String)str, (String)DIGITS));
        }
        catch (NumberFormatException e) {
            code = 0;
        }
        return code;
    }

    protected static String removeUnwantedCharsAndSpaces(String str) {
        char[] tempArray = str.toCharArray();
        StringBuilder returnBuffer = new StringBuilder(str.length());
        for (char c : tempArray) {
            if (!Character.isLetterOrDigit(c)) continue;
            returnBuffer.append(c);
        }
        return returnBuffer.toString();
    }

    public List calculateAlternateSoundexKeys(String origString, ISoundexKey origKey, int possibleErrors, List keys) {
        if (possibleErrors == 0) {
            return keys;
        }
        if (keys == null) {
            return Collections.EMPTY_LIST;
        }
        if (origString == null || origString.length() == 0 || origKey == null) {
            return keys;
        }
        int type = this.isSpecialCase(origString);
        if (type == 1) {
            return keys;
        }
        if (type == 2) {
            return keys;
        }
        HashSet<ISoundexKey> newKeys = new HashSet<ISoundexKey>();
        newKeys.add(origKey);
        newKeys.addAll(keys);
        origString = XWGSoundex.removeUnwantedCharsAndSpaces(origString);
        char firstChar = ((MiSoundexKey)origKey).getFirstChar();
        int origNumericVal = ((MiSoundexKey)origKey).getNumericValue();
        String origNumericAsString = String.valueOf(origNumericVal);
        boolean bChangedKeys = false;
        if ((possibleErrors & 0x40) > 0) {
            bChangedKeys = this.addRemoveSingleSoundKeys(origString, (XWG_SoundexKey)origKey, newKeys);
        }
        if ((possibleErrors & 4) > 0) {
            bChangedKeys |= this.addSingleCharWrongKeys(firstChar, origNumericAsString, newKeys);
        }
        if ((possibleErrors & 8) > 0) {
            bChangedKeys |= this.addInsertSingleCharKeys(firstChar, origNumericAsString, newKeys);
        }
        if ((possibleErrors & 0x10) > 0) {
            bChangedKeys |= this.addTransposeAdjacentCharsKeys(firstChar, origNumericAsString, newKeys);
        }
        if (!bChangedKeys) {
            return keys;
        }
        newKeys.remove(origKey);
        newKeys.remove(null);
        keys.addAll(newKeys);
        return keys;
    }

    public static ISoundexKey getStringKey(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        String standardized = XWG_Standardizer.standardizeAreaName(XWGSoundex.removeUnwantedCharsAndSpaces(str));
        if (standardized == null || standardized.length() == 0) {
            return null;
        }
        char ch = standardized.charAt(0);
        int key = 1;
        for (int i = 1; i < standardized.length(); ++i) {
            int increment = i << standardized.charAt(i);
            if (increment < 0) {
                increment *= -1;
            }
            if ((key |= increment) >= 0) continue;
            key *= -1;
        }
        XWG_SoundexKey stringKey = new XWG_SoundexKey(1);
        stringKey.setFirstChar(ch);
        stringKey.setNumericValue(key);
        return stringKey;
    }

    protected final int getAltSoundex(String word) {
        if (StringUtilities.isEmpty((String)word)) {
            return 0;
        }
        if (XWGSoundex.isNumber(word.toCharArray())) {
            long n = Long.parseLong(word);
            if (n < 0L) {
                n *= -1L;
            }
            return (int)XWGSoundex.trimDigits(n, 3);
        }
        char[] chars = this.normalizeChars(word);
        int len = chars.length;
        int soundex = chars[0];
        soundex *= 10;
        soundex += len % 3;
        int checkChars = Math.min(4, len);
        for (int i = 1; i < checkChars; ++i) {
            char s = chars[i];
            soundex *= 10;
            soundex += s % 5;
        }
        return soundex;
    }

    public static final boolean isNumber(char[] chars) {
        int n;
        int n2 = n = chars == null ? 0 : chars.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                char ch = chars[i];
                if (Character.isDigit((int)ch) || i == 0 && n > 1 && ch == '-') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final long trimDigits(long number, int digits) {
        int d = XWGSoundex.getDigitCount(number);
        if (digits > 0 && d > digits) {
            long n = d - digits;
            n = (long)Math.pow(10.0, n);
            return number / n;
        }
        return number;
    }

    public static final int getDigitCount(long number) {
        number = Math.abs(number);
        int n = 0;
        do {
            ++n;
        } while ((number /= 10L) > 0L);
        return n;
    }

    public char[] normalizeChars(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return null;
        }
        return str.toCharArray();
    }

    protected boolean addRemoveSingleSoundKeys(String origString, XWG_SoundexKey origKey, Set<ISoundexKey> newKeys) {
        char firstChar = origKey.getFirstChar();
        String code = String.valueOf(origKey.getNumericValue());
        if (code.length() == 9 && origString.length() > 10) {
            return this.addRemoveSingleSoundKeys_longWord(origString, origKey, newKeys);
        }
        boolean bAddedKeys = false;
        int len = code.length();
        StringBuilder sb = new StringBuilder(len);
        try {
            for (int i = 0; i < len; ++i) {
                sb.delete(0, len);
                sb.append(code);
                sb.deleteCharAt(i);
                bAddedKeys |= newKeys.add((ISoundexKey)this.buildKey(firstChar, sb.toString()));
            }
            return bAddedKeys;
        }
        catch (NumberFormatException nfEx) {
            return false;
        }
    }

    protected boolean addRemoveSingleSoundKeys_longWord(String origString, XWG_SoundexKey origKey, Set<ISoundexKey> newKeys) {
        boolean bAddedKeys = false;
        int len = origString.length();
        StringBuilder nameBuf = new StringBuilder(origString);
        newKeys.add((ISoundexKey)origKey);
        char insertedSound = '\u0000';
        try {
            for (int i = 1; i < len; ++i) {
                if (!m_soundHash.containsKey(Character.valueOf(nameBuf.charAt(i)))) continue;
                nameBuf.setCharAt(i, 'A');
                MiSoundexKey key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                String check = String.valueOf(key.getNumericValue());
                insertedSound = check.charAt(0);
                break;
            }
            StringBuilder masterKeyString = new StringBuilder(11);
            if (insertedSound != '\u0000') {
                masterKeyString.append(insertedSound);
            }
            masterKeyString.append(origKey.getNumericValue());
            for (int i = 0; i < masterKeyString.length(); ++i) {
                char tmp = masterKeyString.charAt(i);
                masterKeyString.deleteCharAt(i);
                bAddedKeys |= newKeys.add((ISoundexKey)this.buildKey(origKey.getFirstChar(), masterKeyString.toString()));
                masterKeyString.insert(i, tmp);
            }
            newKeys.remove((Object)origKey);
            return bAddedKeys;
        }
        catch (NumberFormatException nfEx) {
            return false;
        }
    }

    protected boolean addSingleCharWrongKeys(char firstChar, String code, Set<ISoundexKey> newKeys) {
        if (newKeys == null) {
            return false;
        }
        if (StringUtilities.isEmpty((String)code)) {
            return false;
        }
        boolean bAddedKeys = false;
        int len = code.length();
        int end = VALID_CODES.length();
        StringBuilder sb = new StringBuilder(len);
        try {
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < end; ++j) {
                    if (code.charAt(i) == VALID_CODES.charAt(j)) continue;
                    sb.delete(0, len);
                    sb.append(code);
                    sb.replace(i, i + 1, String.valueOf(VALID_CODES.charAt(j)));
                    bAddedKeys |= newKeys.add((ISoundexKey)this.buildKey(firstChar, sb.toString()));
                }
            }
            return bAddedKeys;
        }
        catch (NumberFormatException nfEx) {
            return false;
        }
    }

    protected boolean addInsertSingleCharKeys(char firstChar, String code, Set<ISoundexKey> newKeys) {
        if (newKeys == null) {
            return false;
        }
        if (StringUtilities.isEmpty((String)code)) {
            return false;
        }
        boolean bAddedKeys = false;
        int len = code.length();
        if (len == 9) {
            code = code.substring(1);
            --len;
        }
        int end = VALID_CODES.length();
        StringBuilder sb = new StringBuilder(len + 1);
        try {
            for (int i = 0; i < len + 1; ++i) {
                for (int j = 0; j < end; ++j) {
                    sb.delete(0, len + 1);
                    sb.append(code);
                    sb.insert(i, VALID_CODES.charAt(j));
                    bAddedKeys |= newKeys.add((ISoundexKey)this.buildKey(firstChar, sb.toString()));
                }
            }
            return bAddedKeys;
        }
        catch (NumberFormatException nfEx) {
            return false;
        }
    }

    protected boolean addTransposeAdjacentCharsKeys(char firstChar, String code, Set<ISoundexKey> newKeys) {
        boolean bAddedKeys = false;
        if (newKeys == null) {
            return false;
        }
        if (StringUtilities.isEmpty((String)code)) {
            return false;
        }
        int len = code.length() - 1;
        StringBuilder sb = new StringBuilder(len + 1);
        sb.append(code);
        try {
            for (int i = 0; i < len; ++i) {
                char c1 = sb.charAt(i);
                char c2 = sb.charAt(i + 1);
                sb.setCharAt(i, c2);
                sb.setCharAt(i + 1, c1);
                bAddedKeys |= newKeys.add((ISoundexKey)this.buildKey(firstChar, sb.toString()));
                sb.setCharAt(i, c1);
                sb.setCharAt(i + 1, c2);
            }
            return bAddedKeys;
        }
        catch (NumberFormatException nfEx) {
            return false;
        }
    }

    static int getSound(char letter) {
        Integer value = m_soundHash.get(Character.valueOf(letter));
        if (value == null) {
            return 0;
        }
        return value;
    }

    protected XWG_SoundexKey buildKey(char firstChar, int value) {
        XWG_SoundexKey key = new XWG_SoundexKey();
        key.setFirstChar(XWG_AccentHelper.getUnaccentedChar(firstChar));
        key.setNumericValue(value);
        return key;
    }

    protected XWG_SoundexKey buildKey(char firstChar, String value) throws NumberFormatException {
        XWG_SoundexKey key = new XWG_SoundexKey();
        key.setFirstChar(firstChar);
        key.setNumericValue(Integer.parseInt(value));
        return key;
    }

    static {
        HashMap<Character, Integer> temp = new HashMap<Character, Integer>();
        for (char c : XWGSoundex.findAllAccents(CODE_1_BASE_CHARACTERS).toCharArray()) {
            temp.put(Character.valueOf(c), 1);
        }
        for (char c : XWGSoundex.findAllAccents(CODE_2_BASE_CHARACTERS).toCharArray()) {
            temp.put(Character.valueOf(c), 2);
        }
        for (char c : XWGSoundex.findAllAccents(CODE_3_BASE_CHARACTERS).toCharArray()) {
            temp.put(Character.valueOf(c), 3);
        }
        for (char c : XWGSoundex.findAllAccents(CODE_4_BASE_CHARACTERS).toCharArray()) {
            temp.put(Character.valueOf(c), 4);
        }
        for (char c : XWGSoundex.findAllAccents(CODE_5_BASE_CHARACTERS).toCharArray()) {
            temp.put(Character.valueOf(c), 5);
        }
        for (char c : XWGSoundex.findAllAccents(CODE_6_BASE_CHARACTERS).toCharArray()) {
            temp.put(Character.valueOf(c), 6);
        }
        m_soundHash = Collections.unmodifiableMap(temp);
    }
}

