/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.XWG.XWG_FallbackGeocoder;
import com.mapinfo.mapmarker.XWG.XWG_GeographicGeocoder;
import com.mapinfo.mapmarker.XWG.XWG_LocalConstraintsHelper;
import com.mapinfo.mapmarker.XWG.XWG_MatcherConstants;
import com.mapinfo.mapmarker.XWG.XWG_PostalGeocoder;
import com.mapinfo.mapmarker.XWG.XWG_ScoringHelper;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_DataManager;
import com.mapinfo.mapmarker.XWG.filters.AlmostPerfectAreaNameFilterRule;
import com.mapinfo.mapmarker.XWG.filters.LowerPrecisionBetterMatchFilterRule;
import com.mapinfo.mapmarker.XWG.filters.PerfectAreaNameFilterRule;
import com.mapinfo.mapmarker.XWG.filters.PerfectCandidateFilterRule;
import com.mapinfo.mapmarker.XWG.filters.PreferBetterInputBasedPrecisionTypeFilterRule;
import com.mapinfo.mapmarker.XWG.geographic.XWG_GeographicCentroidFilter;
import com.mapinfo.mapmarker.XWG.geographic.XWG_GeographicMatcher;
import com.mapinfo.mapmarker.XWG.parser.XWG_ParseRuleHandler;
import com.mapinfo.mapmarker.XWG.postal.XWG_PostalMatcher;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.FatalHandlerException;
import com.mapinfo.mapmarker.core.HandlerValidator;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.CoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetGeocoder;
import com.mapinfo.mapmarker.core.geographic.ICoreGeographicCentroidFilter;
import com.mapinfo.mapmarker.core.geographic.ICoreGeographicGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicCentroidFilter;
import com.mapinfo.mapmarker.core.geographic.IGeographicMatcher;
import com.mapinfo.mapmarker.core.parser.ICoreParser;
import com.mapinfo.mapmarker.core.parser.IParseRuleHandler;
import com.mapinfo.mapmarker.core.postal.ICorePostalGeocoder;
import com.mapinfo.mapmarker.core.postal.IPostalMatcher;
import com.mapinfo.mapmarker.utils.MMJLog;

public class XWG_Handler
extends CoreHandler {
    private XWG_Handler() {
    }

    private static void testit() throws GeocodableAddressCreationException {
        AddressImpl addr = new AddressImpl();
        addr.setCountry("XWG");
        IHandler handler = XWG_Handler.buildHandler((Address)addr);
        try {
            HandlerValidator.validateHandler((IHandler)handler, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (FatalHandlerException ex) {
            throw new GeocodableAddressCreationException(2500, (Throwable)ex);
        }
    }

    public static IHandler buildHandler(Address address) throws GeocodableAddressCreationException {
        XWG_Handler handler;
        try {
            handler = new XWG_Handler();
            handler.setInputAddress(address);
            handler.setDataManager((IDataManager)new XWG_DataManager());
            handler.setMatcherConstants(new XWG_MatcherConstants());
            handler.setLocalConstraintsHelper(new XWG_LocalConstraintsHelper());
            ((ICoreGeographicGeocoder)handler).setGeographicMatcher((IGeographicMatcher)new XWG_GeographicMatcher());
            ICloseMatchFilterRule[] geoFilterRules = new ICloseMatchFilterRule[]{new PreferBetterInputBasedPrecisionTypeFilterRule(), new PerfectCandidateFilterRule(), new PerfectAreaNameFilterRule(), new AlmostPerfectAreaNameFilterRule(), new LowerPrecisionBetterMatchFilterRule()};
            ((ICoreGeographicGeocoder)handler).setGeographicCentroidFilter((IGeographicCentroidFilter)new XWG_GeographicCentroidFilter());
            ((ICoreGeographicCentroidFilter)handler).setGeographicCentroidFilterRules(geoFilterRules);
            ((ICoreStreetGeocoder)handler).setScoringHelper((IScoringHelper)new XWG_ScoringHelper());
            ((ICoreAddressGeocoder)handler).setStreetGeocoder((IStreetGeocoder)new CoreStreetGeocoder((IHandler)handler));
            handler.setAddressGeocoder(new XWG_FallbackGeocoder());
            XWG_ParseRuleHandler parse = new XWG_ParseRuleHandler();
            ((ICoreParser)handler).setRuleHandler((IParseRuleHandler)parse);
            parse.addParsingRules((IHandler)handler);
            handler.setGeographicGeocoder(new XWG_GeographicGeocoder((IHandler)handler));
            ((ICorePostalGeocoder)handler).setPostalMatcher((IPostalMatcher)new XWG_PostalMatcher());
            handler.setPostalGeocoder(new XWG_PostalGeocoder());
            handler.setGeocodePostalSupported(true);
            handler.setGeocodeGeographicSupported(true);
            handler.setGeocodeSupported(true);
            handler.setBrowseSupported(false);
            handler.setStandardizeSupported(false);
        }
        catch (MMJEDataManagerInitializationException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException && t.getCause() instanceof FatalDataAccessException) {
                FatalDataAccessException dex = (FatalDataAccessException)t.getCause();
                throw new GeocodableAddressCreationException(dex.getErrorCode(), (Throwable)dex);
            }
            throw new GeocodableAddressCreationException(2306, (Throwable)e);
        }
        return handler;
    }

    static {
        try {
            XWG_Handler.testit();
        }
        catch (GeocodableAddressCreationException ex) {
            MMJLog.getLog().error("Unable to create XWG_Handler", (Throwable)ex);
        }
    }
}

