/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.XWG.XWGUtils;
import com.mapinfo.mapmarker.XWG.XWG_ScoringHelper;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Map;

public class XWG_InternalGeographicCandidate
extends InternalGeographicCandidate {
    static final double m_blankCandFieldScoreAN2 = 0.7;
    static final double m_blankCandFieldScoreAN3 = 0.7;
    static final double m_blankCandFieldScoreAN4 = 0.7;
    private static final double m_minScoreToAllowSwap = 0.85;
    private static final double THRESHOLD_ORIGINAL_VS_ALT = 0.95;
    private static final double GOOD_MATCH_SCORE = 0.97;
    private static final double COUNTRY_THRESHOLD = 0.1;
    private static final char[] IGNORED_PUNCTUATION = "-.()".toCharArray();
    private static final String IGNORED_PUNCTUATION_STRING = "-.()";
    private static final int NO_ALTERNATE_INDEX = -1;
    protected int m_matchedAltAn1Index = -1;
    protected int m_matchedAltAn2Index = -1;
    protected int m_matchedAltAn3Index = -1;
    protected int m_matchedAltAn4Index = -1;
    private double m_postCodeScore = 0.0;
    private boolean m_bAN3asAN4;
    private boolean m_bInitialCloseMatch = false;
    protected boolean bMustMatchCountry;
    protected boolean bMustMatchAreaName1;
    protected boolean bMustMatchAreaName2;
    protected boolean bMustMatchAreaName3;
    protected boolean bMustMatchAreaName4;
    protected String m_inputGenericField3;
    protected String m_inputGenericField4;
    private boolean m_bUnAdjustedAreaName3;
    private String m_inputAreaName1;
    protected double citySizeBonus = 0.0;
    private Map<String, Double> m_scoringCache;

    public XWG_InternalGeographicCandidate() {
        this.setStringScorer(XWG_ScoringHelper.getStringScorer());
    }

    public void setMustMatchFlags(boolean bCountry, boolean bAreaName1, boolean bAreaName2, boolean bAreaName3, boolean bAreaName4) {
        this.bMustMatchCountry = bCountry;
        this.bMustMatchAreaName1 = bAreaName1;
        this.bMustMatchAreaName2 = bAreaName2;
        this.bMustMatchAreaName3 = bAreaName3;
        this.bMustMatchAreaName4 = bAreaName4;
    }

    public void setScoringCache(Map<String, Double> cache) {
        this.m_scoringCache = cache;
    }

    public boolean getAN3asAN4() {
        return this.m_bAN3asAN4;
    }

    public void setUseAN3asAN4(boolean flag) {
        this.m_bAN3asAN4 = flag;
    }

    public boolean isInitialCloseMatch() {
        return this.m_bInitialCloseMatch;
    }

    public void setIsInitialCloseMatch(boolean flag) {
        this.m_bInitialCloseMatch = flag;
    }

    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) {
        short rank;
        CandidateAddress candidate = new CandidateAddress();
        XWG_GeoInfoRecord geoinfo = (XWG_GeoInfoRecord)this.getGeoInfoRecord();
        candidate.setAreaName1(geoinfo.getAreaName1());
        candidate.setAreaName2(geoinfo.getAreaName2());
        candidate.setAreaName3(geoinfo.getAreaName3());
        candidate.setAreaName4(geoinfo.getAreaName4());
        candidate.setPostCode1(geoinfo.getPostCode());
        candidate.setCountry(geoinfo.getCountry());
        if (this.m_matchedAltAn1Index != -1) {
            candidate.setAreaName1(this.getAN1AltMatch());
        }
        if (this.m_matchedAltAn2Index != -1) {
            candidate.setAreaName2(this.getAN2AltMatch());
        }
        if (this.m_matchedAltAn3Index != -1) {
            candidate.setAreaName3(this.getAN3AltMatch());
        }
        if (this.m_matchedAltAn4Index != -1) {
            candidate.setAreaName4(this.getAN4AltMatch());
        }
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.getAreaName1Score() == 1.0 && inputAddress.getAreaName1() != null) {
            candidate.setAreaName1Matched();
        }
        if (this.getAreaName2Score() == 1.0 && inputAddress.getAreaName2() != null) {
            candidate.setAreaName2Matched();
        }
        if (this.getAreaName3Score() >= 0.97 && inputAddress.getAreaName3() != null) {
            candidate.setAreaName3Matched();
        }
        if (this.getAreaName4Score() == 1.0 && inputAddress.getAreaName4() != null) {
            candidate.setAreaName4Matched();
        }
        if (this.getCentroid() != null) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystemObject();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)clientCoordSys, (DirectPosition)this.getCentroid()));
            candidate.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)clientCoordSys));
        } else {
            candidate.setLocation(new DirectPosition());
        }
        candidate.setLocationPrecision(this.getPrecision());
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        if ("G3".equals(geores) && (rank = this.getCityRank()) > 0) {
            candidate.addKeyValueToAdditionalFields("CITYRANK", String.valueOf(rank));
        }
        candidate.addKeyValueToAdditionalFields("FROM_WORLD_FALLBACK", "true");
        XWGUtils.setFormattedLocationAdddress(candidate);
        return candidate;
    }

    public short getCityRank() {
        XWG_GeoInfoRecord record = (XWG_GeoInfoRecord)this.getGeoInfoRecord();
        return record.getCityRank();
    }

    public String toString() {
        return "\nXWG_InternalGeographicCandidate:" + super.toString();
    }

    public void scoreCandidate(Address inputAddress, String charsToIgnore) {
        super.scoreCandidate(inputAddress, charsToIgnore);
        this.swapFieldsForScoring(inputAddress);
        boolean inputAN2isEmpty = StringUtilities.isEmpty((String)inputAddress.getAreaName2());
        boolean inputAN3isEmpty = StringUtilities.isEmpty((String)inputAddress.getAreaName3());
        boolean inputAN4isEmpty = StringUtilities.isEmpty((String)inputAddress.getAreaName4());
        this.m_inputGenericField3 = inputAddress.getGenericField3();
        this.m_inputGenericField4 = inputAddress.getGenericField4();
        this.m_bUnAdjustedAreaName3 = StringUtilities.equalStrings((String)inputAddress.getGenericField3(), (String)inputAddress.getAreaName3());
        this.m_inputAreaName1 = inputAddress.getAreaName1();
        if (!inputAN2isEmpty && StringUtilities.isEmpty((String)this.getAreaName2())) {
            this.setAreaName2Score(0.7);
        }
        if (!inputAN3isEmpty && StringUtilities.isEmpty((String)this.getAreaName3())) {
            this.setAreaName3Score(0.7);
        }
        if (!inputAN4isEmpty && StringUtilities.isEmpty((String)this.getAreaName4())) {
            this.setAreaName4Score(0.7);
        }
        this.scorePostCode1(inputAddress);
    }

    private void swapFieldsForScoring(Address inputAddress) {
        boolean bSwappedAreaName1 = false;
        boolean bSwappedAreaName2 = false;
        boolean bSwappedAreaName3 = false;
        boolean bSwappedAreaName4 = false;
        XWG_GeoInfoRecord record = (XWG_GeoInfoRecord)this.getGeoInfoRecord();
        if (!bSwappedAreaName3 && !bSwappedAreaName4 && (this.getAreaName3Score() < 1.0 || this.getAreaName4Score() < 1.0)) {
            ScoreResult inputAreaName3AsAreaName4 = this.scoreAreaName(inputAddress.getAreaName3(), inputAddress.getGenericField3(), this.getAreaName4(), record.getAltAreaName4Array());
            ScoreResult inputAreaName4AsAreaName3 = this.scoreAreaName(inputAddress.getAreaName4(), inputAddress.getGenericField4(), this.getAreaName3(), record.getAltAreaName3Array());
            if (inputAreaName3AsAreaName4.getScore() > 0.85 && inputAreaName3AsAreaName4.getScore() >= this.getAreaName3Score() && inputAreaName4AsAreaName3.getScore() > 0.85 && inputAreaName4AsAreaName3.getScore() >= this.getAreaName4Score()) {
                this.setAreaName3Score(inputAreaName3AsAreaName4.getScore());
                this.setAreaName4Score(inputAreaName4AsAreaName3.getScore());
                this.m_matchedAltAn3Index = inputAreaName4AsAreaName3.getAltIndex();
                this.m_matchedAltAn4Index = inputAreaName3AsAreaName4.getAltIndex();
                this.setUseAN3asAN4(true);
                bSwappedAreaName3 = true;
                bSwappedAreaName4 = true;
            }
        }
        if (!bSwappedAreaName3 && !bSwappedAreaName2 && (this.getAreaName3Score() < 1.0 || this.getAreaName2Score() < 1.0)) {
            ScoreResult inputAreaName3AsAreaName2 = this.scoreAreaName(inputAddress.getAreaName3(), inputAddress.getGenericField3(), this.getAreaName2(), record.getAltAreaName2Array());
            ScoreResult inputAreaName2AsAreaName3 = this.scoreAreaName(inputAddress.getAreaName2(), inputAddress.getGenericField2(), this.getAreaName3(), record.getAltAreaName3Array());
            if (inputAreaName3AsAreaName2.getScore() > 0.85 && inputAreaName3AsAreaName2.getScore() >= this.getAreaName3Score() && inputAreaName2AsAreaName3.getScore() > 0.85 && inputAreaName2AsAreaName3.getScore() >= this.getAreaName2Score()) {
                this.setAreaName3Score(inputAreaName3AsAreaName2.getScore());
                this.setAreaName2Score(inputAreaName2AsAreaName3.getScore());
                this.m_matchedAltAn3Index = inputAreaName2AsAreaName3.getAltIndex();
                this.m_matchedAltAn2Index = inputAreaName3AsAreaName2.getAltIndex();
                bSwappedAreaName3 = true;
                bSwappedAreaName2 = true;
            }
        }
        if (!bSwappedAreaName1 && !bSwappedAreaName2 && (this.getAreaName1Score() < 1.0 || this.getAreaName2Score() < 1.0)) {
            ScoreResult inputAreaName1AsAreaName2 = this.scoreAreaName(inputAddress.getAreaName1(), inputAddress.getGenericField1(), this.getAreaName2(), record.getAltAreaName2Array());
            ScoreResult inputAreaName2AsAreaName1 = this.scoreAreaName(inputAddress.getAreaName2(), inputAddress.getGenericField2(), this.getAreaName1(), record.getAltAreaName1Array());
            if (inputAreaName1AsAreaName2.getScore() > 0.85 && inputAreaName1AsAreaName2.getScore() >= this.getAreaName1Score() && inputAreaName2AsAreaName1.getScore() > 0.85 && inputAreaName2AsAreaName1.getScore() >= this.getAreaName2Score()) {
                this.setAreaName1Score(inputAreaName1AsAreaName2.getScore());
                this.setAreaName2Score(inputAreaName2AsAreaName1.getScore());
                this.m_matchedAltAn1Index = inputAreaName2AsAreaName1.getAltIndex();
                this.m_matchedAltAn2Index = inputAreaName1AsAreaName2.getAltIndex();
                bSwappedAreaName1 = true;
                bSwappedAreaName2 = true;
            }
        }
    }

    public void scoreCountry(Address inputAddress) {
        XWG_GeoInfoRecord record;
        this.setCountryScore(this.scoreStrings(this.getCountry(), inputAddress.getCountry(), true));
        if (this.getCountryScore() < 0.1) {
            this.setCountryScore(0.0);
        }
        if (this.getCountryScore() != 1.0 && (record = (XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAlternateCountryArray() != null) {
            double highScore = this.getCountryScore();
            if (highScore < 0.1) {
                highScore = 0.1;
            }
            for (String alt : record.getAlternateCountryArray()) {
                double score = this.scoreStrings(alt, inputAddress.getCountry(), true);
                if (!(score > highScore)) continue;
                this.setCountryScore(score);
                if (score == 1.0) break;
                highScore = score;
            }
        }
    }

    private ScoreResult scoreAreaName(String inputAreaName, String inputOriginalAreaName, String candidateAreaName, String[] candidateAreaNameAlternates) {
        return this.scoreAreaName(inputAreaName, inputOriginalAreaName, candidateAreaName, candidateAreaNameAlternates, false);
    }

    private ScoreResult scoreAreaName(String inputAreaName, String inputOriginalAreaName, String candidateAreaName, String[] candidateAreaNameAlternates, boolean bNoShortWordBonus) {
        if (StringUtilities.isEmpty((String)inputAreaName)) {
            return new ScoreResult(1.0, -1);
        }
        boolean bInputHadIgnoredPunctuation = this.containsIgnoredPunctuation(inputAreaName);
        boolean bInputEndsWithComma = inputAreaName.endsWith(",");
        String adjustedInputAreaName = null;
        if (bInputHadIgnoredPunctuation) {
            adjustedInputAreaName = this.replaceIgnoredPunctuationWithSpaces(inputAreaName);
        } else if (bInputEndsWithComma) {
            adjustedInputAreaName = inputAreaName.substring(0, inputAreaName.length() - 1).trim();
        }
        double highScore = this.getBestScoreForField(inputAreaName, adjustedInputAreaName, candidateAreaName, bNoShortWordBonus);
        if (highScore == 1.0 && candidateAreaName.equalsIgnoreCase(inputOriginalAreaName)) {
            return new ScoreResult(highScore, -1);
        }
        int altIndex = -1;
        if (candidateAreaNameAlternates != null) {
            for (int i = 0; i < candidateAreaNameAlternates.length; ++i) {
                double score;
                String alternate = candidateAreaNameAlternates[i];
                if (highScore < 1.0 && (score = this.getBestScoreForField(inputAreaName, adjustedInputAreaName, alternate, bNoShortWordBonus)) > highScore) {
                    highScore = score;
                    if (score > 0.95) {
                        altIndex = i;
                    }
                }
                if (highScore != 1.0 || !alternate.equalsIgnoreCase(inputOriginalAreaName)) continue;
                return new ScoreResult(highScore, i);
            }
        }
        return new ScoreResult(highScore, altIndex);
    }

    private double getBestScoreForField(String input, String adjustedInput, String field, boolean bNoShortWordBonus) {
        double score;
        double highScore = this.scoreStrings(field, input, bNoShortWordBonus);
        if (highScore == 1.0) {
            return highScore;
        }
        String adjustedField = field;
        boolean bFieldContainsIgnoredPunctuation = this.containsIgnoredPunctuation(field);
        if (bFieldContainsIgnoredPunctuation) {
            adjustedField = this.replaceIgnoredPunctuationWithSpaces(field);
        }
        if ((bFieldContainsIgnoredPunctuation || adjustedInput != null) && (score = this.scoreStrings(adjustedField, adjustedInput == null ? input : adjustedInput, bNoShortWordBonus)) > highScore) {
            highScore = score;
        }
        return highScore;
    }

    public void scoreAreaName1(Address inputAddress) {
        ScoreResult result = this.scoreAreaName(inputAddress.getAreaName1(), inputAddress.getGenericField1(), this.getAreaName1(), ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName1Array(), true);
        this.setAreaName1Score(result.getScore());
        this.m_matchedAltAn1Index = result.getAltIndex();
    }

    public void scoreAreaName2(Address inputAddress) {
        ScoreResult result = this.scoreAreaName(inputAddress.getAreaName2(), inputAddress.getGenericField2(), this.getAreaName2(), ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName2Array(), true);
        this.setAreaName2Score(result.getScore());
        this.m_matchedAltAn2Index = result.getAltIndex();
    }

    public void scoreAreaName3(Address inputAddress) {
        ScoreResult result = this.scoreAreaName(inputAddress.getAreaName3(), inputAddress.getGenericField3(), this.getAreaName3(), ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName3Array());
        this.setAreaName3Score(result.getScore());
        this.m_matchedAltAn3Index = result.getAltIndex();
    }

    public void scoreAreaName4(Address inputAddress) {
        ScoreResult result = this.scoreAreaName(inputAddress.getAreaName4(), inputAddress.getGenericField4(), this.getAreaName4(), ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName4Array());
        this.setAreaName4Score(result.getScore());
        this.m_matchedAltAn4Index = result.getAltIndex();
    }

    protected boolean containsIgnoredPunctuation(String input) {
        if (input == null) {
            return false;
        }
        for (char c : IGNORED_PUNCTUATION) {
            if (input.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    protected String replaceIgnoredPunctuationWithSpaces(String input) {
        if (input == null) {
            return input;
        }
        char[] stringChars = input.toCharArray();
        StringBuffer str = new StringBuffer(stringChars.length);
        for (char c : stringChars) {
            if (c == ' ') {
                if (str.length() <= 0 || str.charAt(str.length() - 1) == c) continue;
                str.append(c);
                continue;
            }
            if (IGNORED_PUNCTUATION_STRING.indexOf(c) == -1) {
                str.append(c);
                continue;
            }
            if (str.length() <= 0 || str.charAt(str.length() - 1) == ' ') continue;
            str.append(' ');
        }
        return str.toString();
    }

    public void scorePostCode1(Address inputAddress) {
        String inputPostCode = inputAddress.getPostCode1();
        if (inputPostCode == null) {
            return;
        }
        String myPostcode = ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getPostCode();
        if (myPostcode == null) {
            return;
        }
        if (myPostcode.equals(inputPostCode)) {
            this.m_postCodeScore = 1.0;
            return;
        }
        try {
            int p1 = Integer.parseInt(myPostcode);
            int p2 = Integer.parseInt(inputPostCode);
            this.m_postCodeScore = (p1 / 10000 == p2 / 10000 ? 0.2 : 0.0) + (p1 % 10000 / 1000 == p2 % 10000 / 1000 ? 0.2 : 0.0) + (p1 % 1000 / 100 == p2 % 1000 / 100 ? 0.2 : 0.0) + (p1 % 100 / 10 == p2 % 100 / 10 ? 0.2 : 0.0) + (p1 % 10 == p2 % 10 ? 0.2 : 0.0);
        }
        catch (NumberFormatException nex) {
            this.m_postCodeScore = 0.0;
        }
    }

    public double getPostCodeScore() {
        return this.m_postCodeScore;
    }

    public String getCountry() {
        XWG_GeoInfoRecord geoinfo = (XWG_GeoInfoRecord)this.getGeoInfoRecord();
        return geoinfo.getCountry();
    }

    public String getAN1AltMatch() {
        if (this.m_matchedAltAn1Index == -1) {
            return null;
        }
        return ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName1Array()[this.m_matchedAltAn1Index];
    }

    public String getAN2AltMatch() {
        if (this.m_matchedAltAn2Index == -1) {
            return null;
        }
        return ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName2Array()[this.m_matchedAltAn2Index];
    }

    public String getAN3AltMatch() {
        if (this.m_matchedAltAn3Index == -1) {
            return null;
        }
        return ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName3Array()[this.m_matchedAltAn3Index];
    }

    public String getAN4AltMatch() {
        if (this.m_matchedAltAn4Index == -1) {
            return null;
        }
        return ((XWG_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName4Array()[this.m_matchedAltAn4Index];
    }

    public void setCombinedScore(double score) {
        super.setCombinedScore(score);
        this.citySizeBonus = score;
        short rank = this.getCityRank();
        int precision = this.getPrecision();
        if (precision == 10 && (this.getAreaName1Score() != 1.0 || this.getAreaName2Score() != 1.0 || this.getAreaName4Score() != 1.0)) {
            if (rank < 3) {
                this.citySizeBonus = score + 0.05;
            } else if (rank > 5) {
                this.citySizeBonus = score - 0.05;
            }
        }
    }

    public int compare(Object o1, Object o2) {
        boolean cand2AliasMatch;
        XWG_InternalGeographicCandidate candidate1 = (XWG_InternalGeographicCandidate)((Object)o1);
        XWG_InternalGeographicCandidate candidate2 = (XWG_InternalGeographicCandidate)((Object)o2);
        if (candidate1.isCloseMatch() ^ candidate2.isCloseMatch()) {
            if (candidate1.isCloseMatch()) {
                return 1;
            }
            return -1;
        }
        if (candidate1.getCountryScore() == 1.0 && candidate2.getCountryScore() != 1.0) {
            return 1;
        }
        if (candidate1.getCountryScore() != 1.0 && candidate2.getCountryScore() == 1.0) {
            return -1;
        }
        if (candidate1.citySizeBonus > candidate2.citySizeBonus) {
            return 1;
        }
        if (candidate1.citySizeBonus < candidate2.citySizeBonus) {
            return -1;
        }
        if (candidate1.getCombinedScore() > candidate2.getCombinedScore()) {
            return 1;
        }
        if (candidate1.getCombinedScore() < candidate2.getCombinedScore()) {
            return -1;
        }
        if (candidate1.getAreaName1Score() > candidate2.getAreaName1Score()) {
            return 1;
        }
        if (candidate1.getAreaName1Score() < candidate2.getAreaName1Score()) {
            return -1;
        }
        if (candidate1.getAreaName2Score() > candidate2.getAreaName2Score()) {
            return 1;
        }
        if (candidate1.getAreaName2Score() < candidate2.getAreaName2Score()) {
            return -1;
        }
        if (candidate1.getAreaName3Score() > candidate2.getAreaName3Score()) {
            return 1;
        }
        if (candidate1.getAreaName3Score() < candidate2.getAreaName3Score()) {
            return -1;
        }
        if (candidate1.getAreaName4Score() > candidate2.getAreaName4Score()) {
            return 1;
        }
        if (candidate1.getAreaName4Score() < candidate2.getAreaName4Score()) {
            return -1;
        }
        if (candidate1.getCityRank() > 0 && candidate1.getCityRank() < candidate2.getCityRank()) {
            return 1;
        }
        if (candidate2.getCityRank() > 0 && candidate2.getCityRank() < candidate1.getCityRank()) {
            return -1;
        }
        if (candidate1.getCountryScore() > candidate2.getCountryScore()) {
            return 1;
        }
        if (candidate2.getCountryScore() > candidate2.getCountryScore()) {
            return -1;
        }
        boolean cand1AliasMatch = candidate1.m_matchedAltAn3Index != -1;
        boolean bl = cand2AliasMatch = candidate2.m_matchedAltAn3Index != -1;
        if (candidate1.getPrecision() == 10 && candidate2.getPrecision() == 10) {
            String secondAn3;
            String firstAn3 = cand1AliasMatch ? candidate1.getAN3AltMatch() : candidate1.getAreaName3();
            String string = secondAn3 = cand2AliasMatch ? candidate2.getAN3AltMatch() : candidate2.getAreaName3();
            if (!StringUtilities.equalStrings((String)firstAn3, (String)secondAn3)) {
                if (StringUtilities.equalStrings((String)firstAn3, (String)candidate1.m_inputGenericField3) && StringUtilities.equalStrings((String)secondAn3, (String)candidate2.m_inputGenericField3)) {
                    return 0;
                }
                if (StringUtilities.equalStrings((String)firstAn3, (String)candidate1.m_inputGenericField3)) {
                    return 1;
                }
                if (StringUtilities.equalStrings((String)secondAn3, (String)candidate2.m_inputGenericField3)) {
                    return -1;
                }
            }
        }
        if (cand1AliasMatch != cand2AliasMatch) {
            if (cand2AliasMatch && candidate2.getPrecision() == 10) {
                return 1;
            }
            if (candidate2.getPrecision() == 10) {
                return -1;
            }
        }
        if (candidate1.getPrecision() == 10 && candidate2.getPrecision() != 10) {
            return 1;
        }
        if (candidate1.getPrecision() != 10 && candidate2.getPrecision() == 10) {
            return -1;
        }
        if (candidate1.getPrecision() > candidate2.getPrecision()) {
            return 1;
        }
        if (candidate1.getPrecision() < candidate2.getPrecision()) {
            return -1;
        }
        if (candidate1.getPrecision() == 11) {
            String secondAn4;
            cand1AliasMatch = candidate1.m_matchedAltAn4Index != -1;
            cand2AliasMatch = candidate2.m_matchedAltAn4Index != -1;
            String firstAn4 = cand1AliasMatch ? candidate1.getAN4AltMatch() : candidate1.getAreaName4();
            String string = secondAn4 = cand2AliasMatch ? candidate2.getAN4AltMatch() : candidate2.getAreaName4();
            if (!StringUtilities.equalStrings((String)firstAn4, (String)secondAn4)) {
                if (StringUtilities.equalStrings((String)firstAn4, (String)candidate1.m_inputGenericField4)) {
                    return 1;
                }
                if (StringUtilities.equalStrings((String)secondAn4, (String)candidate2.m_inputGenericField4)) {
                    return -1;
                }
            }
            if (!cand1AliasMatch && cand2AliasMatch) {
                return 1;
            }
            if (cand1AliasMatch && !cand2AliasMatch) {
                return -1;
            }
        }
        if (candidate1.getPostCodeScore() > candidate2.getPostCodeScore()) {
            return 1;
        }
        if (candidate1.getPostCodeScore() < candidate2.getPostCodeScore()) {
            return -1;
        }
        if (candidate1.hadUnadjustedAreaName3() && !candidate2.hadUnadjustedAreaName3()) {
            return 1;
        }
        if (!candidate1.hadUnadjustedAreaName3() && candidate2.hadUnadjustedAreaName3()) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object o1) {
        return this.compare((Object)this, o1);
    }

    public long getRecordID() {
        XWG_GeoInfoRecord geoinfo = (XWG_GeoInfoRecord)this.getGeoInfoRecord();
        return geoinfo.getRecordID();
    }

    private double scoreStrings(String str1, String str2, boolean bNoShortWordBonus) {
        Double cacheScore = this.checkCache(str1, str2, bNoShortWordBonus);
        if (cacheScore != null) {
            return cacheScore;
        }
        double score = this.getStringScorer().scoreString(str1, str2, bNoShortWordBonus);
        this.addToCache(str1, str2, bNoShortWordBonus, score);
        return score;
    }

    private Double checkCache(String str1, String str2, boolean bNoShortWordBonus) {
        String cacheString;
        Double result = null;
        if (this.m_scoringCache != null && !this.m_scoringCache.isEmpty() && (cacheString = this.getCacheString(str1, str2, bNoShortWordBonus)) != null) {
            result = this.m_scoringCache.get(cacheString);
        }
        return result;
    }

    private void addToCache(String str1, String str2, boolean bNoShortWordBonus, double score) {
        String cacheString;
        if (this.m_scoringCache != null && (cacheString = this.getCacheString(str1, str2, bNoShortWordBonus)) != null) {
            this.m_scoringCache.put(cacheString, new Double(score));
        }
    }

    private String getCacheString(String str1, String str2, boolean bNoShortWordBonus) {
        if (StringUtilities.isEmpty((String)str1) || StringUtilities.isEmpty((String)str2)) {
            return null;
        }
        StringBuilder builder = new StringBuilder(str1);
        builder.append("%%");
        builder.append(str2);
        builder.append("%%");
        builder.append(bNoShortWordBonus ? 1 : 0);
        return builder.toString();
    }

    public boolean hadUnadjustedAreaName3() {
        return this.m_bUnAdjustedAreaName3;
    }

    public String getInputAreaName1() {
        return this.m_inputAreaName1;
    }

    private static class ScoreResult {
        private final double m_score;
        private final int m_altIndex;

        public ScoreResult(double score, int altIndex) {
            this.m_score = score;
            this.m_altIndex = altIndex;
        }

        public double getScore() {
            return this.m_score;
        }

        public int getAltIndex() {
            return this.m_altIndex;
        }
    }
}

