/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.XWGUtils;
import com.mapinfo.mapmarker.XWG.XWG_ScoringHelper;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class XWG_InternalPostalCandidate
extends InternalPostalCandidate {
    private static final double BLANK_VERSUS_NONBLANK_SCORE = 0.7;
    private StringScorer m_scorer = XWG_ScoringHelper.getStringScorer();
    private String[] m_alternateCountryArray;
    private double m_countryScore;
    private double m_areaName1score;
    private double m_areaName3score;

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress candAddress = super.toCandidateAddress(parsed, constraints);
        candAddress.setPostCode2(null);
        XWGUtils.setFormattedLocationAdddress(candAddress);
        if (StringUtilities.isEmpty((String)parsed.getCountry()) || this.getCountryScore() == 1.0) {
            candAddress.setCountryMatched();
        }
        candAddress.addKeyValueToAdditionalFields("FROM_WORLD_FALLBACK", "true");
        return candAddress;
    }

    public void scorePostCode1(Address input) {
        if (this.getPostCode1().equals(input.getPostCode1()) || this.meetsAlternateConditions(input)) {
            this.setPostCode1Score(1.0);
        }
    }

    private boolean meetsAlternateConditions(Address input) {
        if (input.hasAdditionalFields() && this.getPostCode1().equals(input.getAdditionalFields().get("PC1_NOSPACES"))) {
            return true;
        }
        if (input.hasAdditionalFields() && this.getPostCode1().equals(input.getAdditionalFields().get("ALT_GBRPC_KEY"))) {
            return true;
        }
        if (input.hasAdditionalFields() && this.getPostCode1().equals(input.getAdditionalFields().get("ALT_NUMERICPC_KEY"))) {
            return true;
        }
        return input.hasAdditionalFields() && this.getPostCode1().equals(input.getAdditionalFields().get("PC1_WITHSPACE"));
    }

    public void scoreCandidate(Address input) {
        this.scorePostCode1(input);
        this.scoreAreaName1(input);
        this.scoreAreaName3(input);
        this.scoreCountry(input);
    }

    private void scoreCountry(Address input) {
        double highScore = this.m_scorer.scoreString(this.getCountry(), input.getCountry());
        if (highScore != 1.0 && this.getAlternateCountryArray() != null) {
            for (String alt : this.getAlternateCountryArray()) {
                double score = this.m_scorer.scoreString(alt, input.getCountry());
                if (!(score > highScore)) continue;
                highScore = score;
                if (score == 1.0) break;
            }
        }
        this.setCountryScore(highScore);
    }

    public void scoreAreaName1(Address input) {
        String areaName1 = input.getAreaName1();
        this.m_areaName1score = StringUtilities.isEmpty((String)areaName1) ? (StringUtilities.isEmpty((String)this.getAreaName1()) ? 1.0 : 0.7) : (StringUtilities.isEmpty((String)this.getAreaName1()) ? 0.7 : this.m_scorer.scoreString(areaName1, this.getAreaName1()));
    }

    public void scoreAreaName3(Address input) {
        String areaName3 = input.getAreaName3();
        this.m_areaName3score = StringUtilities.isEmpty((String)areaName3) ? (StringUtilities.isEmpty((String)this.getAreaName3()) ? 1.0 : 0.7) : (StringUtilities.isEmpty((String)this.getAreaName3()) ? 0.7 : this.m_scorer.scoreString(areaName3, this.getAreaName3()));
    }

    public boolean equals(Object obj) {
        XWG_InternalPostalCandidate that = (XWG_InternalPostalCandidate)((Object)obj);
        return this.getPostCode1Score() == that.getPostCode1Score() && this.getPostCode2Score() == that.getPostCode2Score() && this.m_areaName1score == that.m_areaName1score && this.m_areaName3score == that.m_areaName3score && this.m_countryScore == that.m_countryScore;
    }

    public int compareTo(Object obj2) {
        XWG_InternalPostalCandidate candidate2 = (XWG_InternalPostalCandidate)((Object)obj2);
        if (this.isCloseMatch() && !candidate2.isCloseMatch()) {
            return 1;
        }
        if (!this.isCloseMatch() && candidate2.isCloseMatch()) {
            return -1;
        }
        if (this.getPostCode1Score() < candidate2.getPostCode1Score()) {
            return -1;
        }
        if (this.getPostCode1Score() > candidate2.getPostCode1Score()) {
            return 1;
        }
        if (this.getCountryScore() < candidate2.getCountryScore()) {
            return -1;
        }
        if (this.getCountryScore() > candidate2.getCountryScore()) {
            return 1;
        }
        if (this.m_areaName3score > candidate2.m_areaName3score) {
            return 1;
        }
        if (this.m_areaName3score < candidate2.m_areaName3score) {
            return -1;
        }
        if (this.m_areaName1score > candidate2.m_areaName1score) {
            return 1;
        }
        if (this.m_areaName1score < candidate2.m_areaName1score) {
            return -1;
        }
        return 0;
    }

    public double getAreaName1Score() {
        return this.m_areaName1score;
    }

    public double getAreaName3Score() {
        return this.m_areaName3score;
    }

    public void setAlternateCountryArray(String[] alternates) {
        this.m_alternateCountryArray = alternates;
    }

    protected String[] getAlternateCountryArray() {
        return this.m_alternateCountryArray;
    }

    void setCountryScore(double score) {
        this.m_countryScore = score;
    }

    public double getCountryScore() {
        return this.m_countryScore;
    }
}

