/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.CoreMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;

public final class XWG_MatcherHandler
extends CoreMatcherHandler {
    private double m_maximumAdditionalFieldScoreForSwappedAN1AN2 = 0.0;

    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants constants, ScoringAddress scoringAddress) throws MatcherException {
        String pc;
        super.decideCloseMatch(preferences, candidate, constants, scoringAddress);
        if (candidate.getAreaName3Score() != 1.0 && candidate.getPostCode1Score() != 1.0 && (pc = scoringAddress.getPostCode1()) != null && pc.length() > 1 && candidate.getPostCode1() != null && !candidate.getPostCode1().startsWith(pc.substring(0, 2))) {
            candidate.setCloseMatchFlag(false);
            return;
        }
    }

    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress scoringAddress, InternalMatcherConstants constants) {
        super.scoreCandidate(candidate, scoringAddress, constants);
    }

    public void computeMaximumAdditionalFieldScore(Address scoringAddress, InternalMatcherConstants constants) {
        super.computeMaximumAdditionalFieldScore(scoringAddress, constants);
        double maxScore = this.getMaximumAdditionalFieldScore();
        boolean hasAN1 = XWG_MatcherHandler.fieldExists((String)scoringAddress.getAreaName1());
        boolean hasAN2 = XWG_MatcherHandler.fieldExists((String)scoringAddress.getAreaName2());
        if (hasAN1 ^ hasAN2) {
            FieldScores matchedConstants = constants.getMatched();
            FieldScores blankConstants = constants.getBlank();
            maxScore -= (hasAN1 ? matchedConstants : blankConstants).getAreaName1();
            maxScore -= (hasAN2 ? matchedConstants : blankConstants).getAreaName2();
            maxScore += (hasAN1 ? blankConstants : matchedConstants).getAreaName1();
            maxScore += (hasAN2 ? blankConstants : matchedConstants).getAreaName2();
        }
        this.m_maximumAdditionalFieldScoreForSwappedAN1AN2 = maxScore;
    }

    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        return best.equals((Object)other);
    }
}

