/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.XWG.XWG_AccentHelper;
import com.mapinfo.mapmarker.common.StringScorer;
import java.util.Locale;

public class XWG_StringScorer
extends StringScorer {
    private static StringBuffer m_collationRulesBuffer = new StringBuffer();

    public XWG_StringScorer() {
        super(true, Locale.getDefault(), m_collationRulesBuffer.toString(), false, 6);
    }

    public double scoreString(String inStr1, String inStr2, boolean bNoShortWordBonus) {
        int lenDiff;
        double score = super.scoreString(inStr1, inStr2, bNoShortWordBonus);
        if (score > 0.0 && inStr1 != null && inStr2 != null && (lenDiff = Math.abs(inStr1.length() - inStr2.length())) > 2 && this.isSingleWord(inStr1) && this.isSingleWord(inStr2)) {
            double dAdjust = 0.1 * (double)lenDiff * score;
            score -= dAdjust;
        }
        if (score < 0.0) {
            score = 0.0;
        }
        return score;
    }

    protected boolean isSingleWord(String str) {
        for (char c : str.toCharArray()) {
            if (c != ' ' && c != '-') continue;
            return false;
        }
        return true;
    }

    static {
        for (char key : XWG_AccentHelper.keySet()) {
            m_collationRulesBuffer.append(XWG_AccentHelper.buildCollatorRuleString(key));
        }
    }
}

