/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp;

import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.dp.XWG_IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoRecord;
import com.mapinfo.mapmarker.XWG.utils.AlternatesProviderFactory;
import com.mapinfo.mapmarker.XWG.utils.IAlternatesProvider;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;

public class XWG_GeoInfoDataSourceRecordConvertorImpl
extends GeoInfoDataSourceRecordConvertorImpl {
    static final int COUNTRY_ALTERNATES = 0;
    static final int AREANAME1_ALTERNATES = 1;
    static final int AREANAME2_ALTERNATES = 2;
    private static String AltSeps = ",/;";

    public XWG_GeoInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    protected GeoInfoRecord makeGeoInfoRecordType() {
        return new XWG_GeoInfoRecord();
    }

    protected GeoInfoRecord makeGeoInfoRecord(IGeoInfoDataSourceRecord input) throws DataSourceException {
        XWG_GeoInfoRecord record = (XWG_GeoInfoRecord)super.makeGeoInfoRecord(input);
        if (record != null) {
            XWG_IGeoInfoDataSourceRecord xwgInput = (XWG_IGeoInfoDataSourceRecord)input;
            String country = xwgInput.getCountry();
            record.setCountry(country);
            record.setAlternateCountryArray(this.addCustomAlternates(country, country, new String[0], 0));
            if (xwgInput.hasCityRank()) {
                byte ctyRank = xwgInput.getCityRank();
                record.setCityRank(ctyRank);
            }
            if (!input.hasPrecision() && record.getPoint() != null) {
                if (!StringUtilities.isEmpty((String)record.getAreaName4())) {
                    record.setPrecision((byte)11);
                } else if (!StringUtilities.isEmpty((String)record.getAreaName3())) {
                    record.setPrecision((byte)10);
                } else if (!StringUtilities.isEmpty((String)record.getAreaName2())) {
                    record.setPrecision((byte)9);
                } else if (!StringUtilities.isEmpty((String)record.getAreaName1())) {
                    record.setPrecision((byte)8);
                } else {
                    return null;
                }
            }
            if (!StringUtilities.isEmpty((String)record.getAreaName1())) {
                record.setAreaName1(record.getAreaName1().toUpperCase());
            }
            if (!StringUtilities.isEmpty((String)record.getAreaName2())) {
                record.setAreaName2(record.getAreaName2().toUpperCase());
            }
            if (!StringUtilities.isEmpty((String)record.getAreaName3())) {
                record.setAreaName3(record.getAreaName3().toUpperCase());
            }
            if (!StringUtilities.isEmpty((String)record.getAreaName4())) {
                record.setAreaName4(record.getAreaName4().toUpperCase());
            }
            record.setAltAreaName1Array(this.addCustomAlternates(country, record.getAreaName1(), this.splitAltAreaNames(record.getAltAreaName1()), 1));
            record.setAltAreaName1(null);
            String[] split = this.addCustomAlternates(country, record.getAreaName2(), this.splitAltAreaNames(record.getAltAreaName2()), 2);
            if ("USA".equalsIgnoreCase(record.getCountry())) {
                split = this.addUSA_CountyAltNoWordCounty(record.getAreaName2(), split);
            }
            record.setAltAreaName2Array(split);
            record.setAltAreaName2(null);
            record.setAltAreaName3Array(this.splitAltAreaNames(record.getAltAreaName3()));
            record.setAltAreaName3(null);
            record.setAltAreaName4Array(this.splitAltAreaNames(record.getAltAreaName4()));
            record.setAltAreaName4(null);
            record.setCountry(record.getCountry().toUpperCase());
        }
        return record;
    }

    protected String[] addUSA_CountyAltNoWordCounty(String an2, String[] existingAlternates) {
        StringWithTokens toks;
        int size = 1;
        if (existingAlternates != null) {
            size += existingAlternates.length;
        }
        ArrayList<String> alternates = new ArrayList<String>(size);
        if (existingAlternates != null) {
            alternates.addAll(Arrays.asList(existingAlternates));
        }
        if ((toks = new StringWithTokens(an2)).size() > 1 && (toks.getLastToken().equalsIgnoreCase("County") || toks.getLastToken().equalsIgnoreCase("Parish"))) {
            toks.removeLast();
            alternates.add(toks.toString());
            return alternates.toArray(new String[alternates.size()]);
        }
        return existingAlternates;
    }

    protected String[] addCustomAlternates(String country, String areaname, String[] existingAlternates, int field) throws DataSourceException {
        try {
            IAlternatesProvider provider;
            switch (field) {
                case 0: {
                    provider = AlternatesProviderFactory.getCountryAlternatesProvider();
                    break;
                }
                case 1: {
                    provider = AlternatesProviderFactory.getAreaName1AlternatesProvider(country);
                    break;
                }
                case 2: {
                    provider = AlternatesProviderFactory.getAreaName2AlternatesProvider(country);
                    break;
                }
                default: {
                    throw new DataSourceException(-1, "Illegal CustomAlternate type: " + field);
                }
            }
            Collection<String> alts = provider.getAlternates(areaname);
            if (alts != null && alts.size() > 0) {
                int size = alts.size();
                if (existingAlternates != null) {
                    size += existingAlternates.length;
                }
                ArrayList<String> alternates = new ArrayList<String>(size);
                if (existingAlternates != null) {
                    alternates.addAll(Arrays.asList(existingAlternates));
                }
                alternates.addAll(alts);
                return alternates.toArray(new String[alternates.size()]);
            }
        }
        catch (MapMarkerInternalException ex) {
            throw new RuntimeException(ex);
        }
        return existingAlternates;
    }

    String[] splitAltAreaNames(String areanames) {
        if (StringUtilities.isEmpty((String)areanames)) {
            return null;
        }
        ArrayList<String> split = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(areanames.toUpperCase(), AltSeps);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            while (s.startsWith("+")) {
                s = s.substring(1);
            }
            split.add(s.trim());
        }
        return split.toArray(new String[split.size()]);
    }

    protected MapMarkerIndexKey makeGeoInfoKey(GeoInfoRecord record) {
        XWG_GeoInfoRecord rec = (XWG_GeoInfoRecord)record;
        StringBuilder sb = new StringBuilder();
        sb.append(rec.getCountry());
        sb.append(rec.getAreaName1());
        sb.append(rec.getAreaName2());
        sb.append(rec.getAreaName3());
        sb.append(rec.getAreaName4());
        sb.append(rec.getPostCode());
        return new MiStringIndexKey(sb.toString().toUpperCase());
    }
}

