/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary;

import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoRecord;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.utils.BlobUtilities;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;

public class XWG_DataBuilder
extends GenericStreetBuilder {
    protected void populateLocalGeoInfo(GeoInfoRecord record, IDataFileDataItem geoInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        FrequentDataFileStrings geoinfoFrequentStrings = metadata.getFrequentStrings();
        GeoInfoDataItem geoInfo = (GeoInfoDataItem)geoInfoItem;
        XWG_GeoInfoRecord xwg = (XWG_GeoInfoRecord)record;
        try {
            byte cityrank;
            String[] values;
            String value = xwg.getAreaName1();
            if (!StringUtilities.isEmpty((String)value)) {
                this.putStringItem(value, geoInfo, 0, 0, 32, geoinfoFrequentStrings);
            }
            if (!StringUtilities.isEmpty((String)(value = xwg.getAreaName2()))) {
                this.putStringItem(value, geoInfo, 1, 1, 33, geoinfoFrequentStrings);
            }
            if (!StringUtilities.isEmpty((String)(value = xwg.getAreaName3()))) {
                this.putStringItem(value, geoInfo, 2, 2, 34, geoinfoFrequentStrings);
            }
            if (!StringUtilities.isEmpty((String)(value = xwg.getAreaName4()))) {
                this.putStringItem(value, geoInfo, 3, 3, 35, geoinfoFrequentStrings);
            }
            if (!StringUtilities.isEmpty((String)(value = xwg.getCountry()))) {
                this.putIsoCountry(value, geoInfo);
            }
            if ((values = xwg.getAltAreaName1Array()) != null) {
                geoInfo.putBlob(32, BlobUtilities.encode((String[])values));
            }
            if ((values = xwg.getAltAreaName2Array()) != null) {
                geoInfo.putBlob(33, BlobUtilities.encode((String[])values));
            }
            if ((values = xwg.getAltAreaName3Array()) != null) {
                geoInfo.putBlob(34, BlobUtilities.encode((String[])values));
            }
            if ((values = xwg.getAltAreaName4Array()) != null) {
                geoInfo.putBlob(35, BlobUtilities.encode((String[])values));
            }
            if (xwg.getAlternateCountryArray() != null) {
                geoInfo.putBlob(36, BlobUtilities.encode((String[])xwg.getAlternateCountryArray()));
            }
            if ((cityrank = ((XWG_GeoInfoRecord)record).getCityRank()) > 0) {
                geoInfo.putByte(37, cityrank);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to build XWG_GeoInfoDataItem.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(301, (Throwable)e);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to build XWG_GeoInfoDataItem.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(301, (Throwable)e);
        }
    }

    protected void populateLocalPostInfo(PostInfoRecord record, IDataFileDataItem postInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        block5: {
            PostInfoDataItem postInfo = (PostInfoDataItem)postInfoItem;
            XWG_PostInfoRecord xwg = (XWG_PostInfoRecord)record;
            try {
                String value = xwg.getCountry();
                if (!StringUtilities.isEmpty((String)value)) {
                    this.putIsoCountryPostal(value, postInfo);
                }
                if (xwg.getAlternateCountryArray() == null) break block5;
                try {
                    postInfo.putBlob(32, BlobUtilities.encode((String[])xwg.getAlternateCountryArray()));
                }
                catch (IOException IOEx) {
                    throw new DataCreationException(501, (Throwable)IOEx);
                }
            }
            catch (MMJETypeArraySizeExceededException ex) {
                DataCreationLogger.getLogger().logInternalError("ERROR: Unable to build XWG_PostInfoDataItem.");
                DataCreationLogger.getLogger().logInternalError(ex.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)ex);
                throw new DataCreationException(501, (Throwable)ex);
            }
        }
    }

    protected void putIsoCountry(String countryCode, GeoInfoDataItem geoInfo) throws MMJETypeArraySizeExceededException {
        ISO3166 isoRec = ISO3166.findCountryByISO3((String)countryCode);
        try {
            short num = Short.parseShort(isoRec.getCountryNumber());
            if (num < 127) {
                geoInfo.putByte(36, (byte)num);
            } else {
                geoInfo.putShort(32, num);
            }
        }
        catch (NumberFormatException ex) {
            geoInfo.putString(32, countryCode);
        }
    }

    protected void putIsoCountryPostal(String countryCode, PostInfoDataItem postInfo) throws MMJETypeArraySizeExceededException {
        ISO3166 isoRec = ISO3166.findCountryByISO3((String)countryCode);
        try {
            if (isoRec == null) {
                postInfo.putString(32, countryCode);
                return;
            }
            short num = Short.parseShort(isoRec.getCountryNumber());
            if (num < 127) {
                postInfo.putByte(32, (byte)num);
            } else {
                postInfo.putShort(32, num);
            }
        }
        catch (NumberFormatException ex) {
            postInfo.putString(32, countryCode);
        }
    }

    private void putStringItem(String stringToPlace, GeoInfoDataItem geoInfo, int frequentStringKey, int stringStorageKey, int byteStorageKey, FrequentDataFileStrings geoinfoFrequentStrings) throws MMJETypeArraySizeExceededException {
        if (stringToPlace != null && stringToPlace.length() != 0) {
            int frequentStringIdx = geoinfoFrequentStrings.getStringNumber(frequentStringKey, stringToPlace);
            if (frequentStringIdx != -1) {
                geoInfo.putByte(byteStorageKey, FrequentDataFileStrings.convertIndexToByte((int)frequentStringIdx));
            } else {
                geoInfo.putString(stringStorageKey, stringToPlace);
            }
        }
    }
}

