/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.XWG.XWGSoundex;
import com.mapinfo.mapmarker.XWG.XWG_Constraints;
import com.mapinfo.mapmarker.XWG.XWG_IConstraints;
import com.mapinfo.mapmarker.XWG.XWG_InternalGeographicCandidate;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoRecord;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_SoundexKey;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_MultiLevelNoCountrySoundexIndexKey;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_MultiLevelSoundexIndexKey;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_ReadOnlyMultiLevelNoCountrySoundexIndexFile;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_ReadOnlyMultiLevelSoundexIndexFile;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IBulkDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.OnDemandDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelReadOnlyIndexFile;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class XWG_GeoInfoFetcherImpl
extends GeoInfoFetcherImpl {
    protected final Soundex m_soundex = new XWGSoundex();
    protected IMapMarkerIndex m_geoInfoNoCountryIndex;

    public XWG_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
    }

    protected void init() throws DataDictionaryIntializationException {
        super.init();
        this.m_geoInfoNoCountryIndex = this.getGeoInfoNoCountryIndexType();
        try {
            ((IMapMarkerReadOnlyIndexFile)this.m_geoInfoNoCountryIndex).open(StringUtilities.appendToPath((String)this.getDataPath(), (String)this.getGeoInfoNoCountryIndexFileName()));
        }
        catch (FileNotFoundException e) {
            throw new DataDictionaryIntializationException("exception.no.index.geoinfo", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException("exception.open.index.geoinfo", (Throwable)e);
        }
    }

    protected IMapMarkerIndex getGeoInfoNoCountryIndexType() {
        return new XWG_ReadOnlyMultiLevelNoCountrySoundexIndexFile();
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        return new XWG_ReadOnlyMultiLevelSoundexIndexFile();
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new XWG_GeoInfoPreLoadedDataHelper();
    }

    protected String getGeoInfoIndexFileName() {
        return "geoinfo.sdx";
    }

    protected String getGeoInfoNoCountryIndexFileName() {
        return "geoinfo.cdx";
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        ISO3166 iso;
        boolean bAltSoundex;
        HashSet<XWG_SoundexKey> keySet = new HashSet<XWG_SoundexKey>();
        boolean useStringKeys = ((XWG_IConstraints)constraints).useStringKeys();
        boolean buildCountryKeys = !StringUtilities.isEmpty((String)addr.getCountry()) && ((XWG_Constraints)constraints).useCountryKeys();
        boolean buildAllKeys = constraints.containsCustomObjectKey((Object)"KEY_BUILD_ALL_GEOINFO_KEYS");
        boolean bHasAn1 = !StringUtilities.isEmpty((String)addr.getAreaName1());
        boolean bHasAn2 = !StringUtilities.isEmpty((String)addr.getAreaName2());
        boolean bHasAn3 = !StringUtilities.isEmpty((String)addr.getAreaName3());
        boolean bHasAn4 = !StringUtilities.isEmpty((String)addr.getAreaName4());
        boolean bl = bAltSoundex = !useStringKeys && constraints.containsCustomObjectKey((Object)"KEY_ALTERNATE_SOUNDEX_CODES");
        if (buildAllKeys || bHasAn1 && !bHasAn3 && !bHasAn4) {
            this.addAreaNameKeys(addr.getAreaName1(), useStringKeys, false, keySet);
        }
        if (buildAllKeys || bHasAn2 && !bHasAn3 && !bHasAn4) {
            this.addAreaNameKeys(addr.getAreaName2(), useStringKeys, false, keySet);
        }
        this.addAreaNameKeys(addr.getAreaName3(), useStringKeys, bAltSoundex, keySet);
        this.addAreaNameKeys(addr.getAreaName4(), useStringKeys, false, keySet);
        if (keySet.isEmpty()) {
            this.addAreaNameKeys(addr.getAreaName4(), useStringKeys, false, keySet);
        }
        if (keySet.isEmpty()) {
            this.addAreaNameKeys(addr.getAreaName1(), useStringKeys, false, keySet);
            this.addAreaNameKeys(addr.getAreaName2(), useStringKeys, false, keySet);
        }
        int countryCode = -1;
        if (buildCountryKeys && (iso = ISO3166.findCountryByISO3((String)addr.getCountry())) != null) {
            try {
                countryCode = Integer.valueOf(iso.getCountryNumber());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        MapMarkerIndexKey[] wrapped = keySet.toArray(new MapMarkerIndexKey[keySet.size()]);
        for (int i = 0; i < wrapped.length; ++i) {
            wrapped[i] = buildCountryKeys ? new XWG_MultiLevelSoundexIndexKey((XWG_SoundexKey)wrapped[i], countryCode) : new XWG_MultiLevelNoCountrySoundexIndexKey((XWG_SoundexKey)wrapped[i]);
        }
        return wrapped;
    }

    protected XWG_SoundexKey buildAlternateStringLookupKey(String areaname, char sep) {
        StringTokenizer st = new StringTokenizer(areaname, " -");
        if (st.countTokens() < 2) {
            return null;
        }
        StringBuilder sb = new StringBuilder(areaname.length());
        while (st.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(st.nextToken());
        }
        return (XWG_SoundexKey)XWGSoundex.getStringKey(sb.toString());
    }

    protected void addAreaNameKeys(String areaName, boolean makeStringKey, boolean makeAlternateSoundexes, HashSet<XWG_SoundexKey> keys) {
        XWG_SoundexKey key = null;
        if (!StringUtilities.isEmpty((String)areaName)) {
            key = makeStringKey ? (XWG_SoundexKey)XWGSoundex.getStringKey(areaName) : (XWG_SoundexKey)this.m_soundex.getSoundex(areaName);
        }
        if (!makeStringKey && makeAlternateSoundexes && key != null) {
            ArrayList newKeys = new ArrayList();
            int errors = 204;
            this.m_soundex.calculateAlternateSoundexKeys(areaName, (ISoundexKey)key, errors, newKeys);
            if (!newKeys.isEmpty()) {
                keys.addAll(newKeys);
            }
        } else if (key != null) {
            keys.add(key);
        }
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new XWG_InternalGeographicCandidate();
    }

    protected ICandidate makeGeoInfoCandidate(GeoInfoRecord record) {
        InternalGeographicCandidate candidate = this.makeInternalGeographicCandidate();
        candidate.setGeoInfoRecord(record);
        candidate.setVendorCode(String.valueOf(this.getDataAccessType().getMetadata().getVendorCode()));
        return candidate;
    }

    protected IDataAccess getDataAccessType() {
        return new XWG_RecordOffsetOnDemandDataAccess(this.getDataAccessHelperType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGeoInfoCandidates(Address addrIn, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        ArrayList<XWG_InternalGeographicCandidate> candidates;
        block12: {
            String indexFileName;
            MapMarkerMultiLevelReadOnlyIndexFile index;
            boolean bUseCountry;
            AddressImpl addr = new AddressImpl(addrIn);
            if ("XWG".equalsIgnoreCase(addr.getCountry())) {
                addr.setCountry(null);
                constraints.getHandler().getParsedAddress().setCountry(null);
            }
            boolean bl = bUseCountry = !StringUtilities.isEmpty((String)addr.getCountry()) && ((XWG_Constraints)constraints).useCountryKeys();
            if (bUseCountry) {
                index = (MapMarkerMultiLevelReadOnlyIndexFile)this.getIndex();
                indexFileName = this.getGeoInfoIndexFileName();
            } else {
                index = (MapMarkerMultiLevelReadOnlyIndexFile)this.m_geoInfoNoCountryIndex;
                indexFileName = this.getGeoInfoNoCountryIndexFileName();
            }
            candidates = null;
            SeekableDataInput stream = null;
            try {
                MapMarkerIndexKey[] keys = this.makeGeoInfoIndexKeys((Address)addr, constraints);
                if (keys == null) break block12;
                TreeSet<Long> offsets = new TreeSet<Long>();
                stream = this.getIndexFile(StringUtilities.appendToPath((String)this.getDataPath(), (String)indexFileName));
                for (MapMarkerIndexKey key : keys) {
                    long[] subOffsets;
                    MapMarkerIndexValue value = index.search(key, stream);
                    if (value == null) continue;
                    for (long offset : subOffsets = this.getGeoInfoIndexOffsets(value)) {
                        offsets.add(new Long(offset));
                    }
                }
                if (offsets.isEmpty()) break block12;
                candidates = new ArrayList<XWG_InternalGeographicCandidate>(offsets.size());
                try {
                    List records = ((IBulkDataAccess)this.getDataAccess()).getRecords(new ArrayList(offsets));
                    for (Object record : records) {
                        XWG_InternalGeographicCandidate cand = (XWG_InternalGeographicCandidate)this.makeGeoInfoCandidate((XWG_GeoInfoRecord)((Object)record));
                        cand.setMustMatchFlags(constraints.isMustMatchCountry(), constraints.isMustMatchArea1(), constraints.isMustMatchArea2(), constraints.isMustMatchArea3(), constraints.isMustMatchArea4());
                        cand.setScoringCache(((XWG_IConstraints)constraints).getScoringCache());
                        candidates.add(cand);
                    }
                }
                catch (DataAccessException DAEx) {
                    throw new DataAccessRuntimeException(DAEx);
                }
            }
            finally {
                if (stream != null) {
                    this.releaseIndexFile(stream);
                }
            }
        }
        return candidates;
    }

    protected SeekableDataInput getIndexFile(String indexFilePath) throws IOException {
        return FileProviderFactory.getFileProvider().get(indexFilePath);
    }

    protected void releaseIndexFile(SeekableDataInput file) throws IOException {
        FileProviderFactory.getFileProvider().release(file);
    }

    private class XWG_RecordOffsetOnDemandDataAccess
    extends OnDemandDataAccess {
        public XWG_RecordOffsetOnDemandDataAccess(IDataAccessHelper helper) {
            super(helper);
        }

        public List<Object> getRecords(List<Long> offsets) throws DataAccessException {
            List results = super.getRecords(offsets);
            Iterator<Long> offsetIterator = offsets.iterator();
            Iterator resultsIterator = results.iterator();
            while (offsetIterator.hasNext()) {
                ((XWG_GeoInfoRecord)((Object)resultsIterator.next())).setRecordID(offsetIterator.next());
            }
            return results;
        }
    }
}

