/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.XWG.XWGSoundex;
import com.mapinfo.mapmarker.XWG.XWG_Constraints;
import com.mapinfo.mapmarker.XWG.XWG_InternalPostalCandidate;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostInfoRecord;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_SoundexKey;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_MultiLevelNoCountrySoundexIndexKey;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_MultiLevelSoundexIndexKey;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_ReadOnlyMultiLevelNoCountrySoundexIndexFile;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_ReadOnlyMultiLevelSoundexIndexFile;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.OnDemandDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XWG_PostInfoFetcherImpl
extends PostInfoFetcherImpl {
    private static final String GBR_EndString = "(\\s*\\d[A-Z]{2})";
    private IMapMarkerIndex m_NoCountryIndex;
    private static final Pattern GBR_POSTFULLCODEPATTERN1 = Pattern.compile("([A-Z]{1,2}\\d{1,2})(\\s*\\d[A-Z]{2})");
    private static final Pattern GBR_POSTFULLCODEPATTERN2 = Pattern.compile("([A-Z]{1,2}\\d{1,2}[A-Z]{1})(\\s*\\d[A-Z]{2})");
    private static final Pattern GBR_POSTFULLCODEPATTERN3 = Pattern.compile("(NPT)(\\s*\\d[A-Z]{2})");
    private static final Pattern NLD_POSTCODE_PATTERN = Pattern.compile("(\\d{3,}\\s*)([A-Z]+)");
    private static final Pattern PRT_POSTCODE_PATTERN = Pattern.compile("(\\d{4}\\s{1,})(\\d{1,})");
    private static final Pattern[] GBR_Patterns = new Pattern[]{GBR_POSTFULLCODEPATTERN1, GBR_POSTFULLCODEPATTERN2, GBR_POSTFULLCODEPATTERN3};

    public XWG_PostInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
    }

    protected void init() throws DataDictionaryIntializationException {
        super.init();
        this.m_NoCountryIndex = this.getPostInfoNoCountryIndexType();
        try {
            ((IMapMarkerReadOnlyIndexFile)this.m_NoCountryIndex).open(StringUtilities.appendToPath((String)this.getDataPath(), (String)this.getPostInfoNoCountryIndexFileName()));
        }
        catch (FileNotFoundException e) {
            throw new DataDictionaryIntializationException("exception.no.index.postinfo", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException("exception.open.index.postinfo", (Throwable)e);
        }
    }

    protected ICandidate getPostInfoCandidateType() {
        return new XWG_InternalPostalCandidate();
    }

    protected String getPostInfoNoCountryIndexFileName() {
        return "postinfo.cdx";
    }

    public List getPostInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        if (this.getPostInfoIndex() == null) {
            return null;
        }
        boolean bUseCountry = !StringUtilities.isEmpty((String)addr.getCountry()) && ((XWG_Constraints)constraints).useCountryKeys();
        List candidates = null;
        IMapMarkerIndex index = bUseCountry ? this.getPostInfoIndex() : this.m_NoCountryIndex;
        MapMarkerIndexKey[] keys = this.makePostInfoKeys(addr, constraints);
        if (keys != null) {
            candidates = this.tryToGetCandidates(addr, keys, index);
        }
        if (candidates == null && addr.hasAdditionalFields() && addr.getAdditionalFields().containsKey("PC1_NOSPACES")) {
            addr.setPostCode1((String)addr.getAdditionalFields().get("PC1_NOSPACES"));
            keys = this.makePostInfoKeys(addr, constraints);
            candidates = this.tryToGetCandidates(addr, keys, index);
            addr.setPostCode1((String)addr.getAdditionalFields().get("PC1_ORIG"));
        }
        return candidates;
    }

    protected List tryToGetCandidates(Address addr, MapMarkerIndexKey[] keys, IMapMarkerIndex index) throws IOException, LocalizationException {
        ArrayList<ICandidate> candidates = null;
        if (keys != null) {
            candidates = new ArrayList<ICandidate>(keys.length);
            HashSet<Long> usedOffsets = new HashSet<Long>();
            for (int i = 0; i < keys.length; ++i) {
                MapMarkerIndexValue value = index.search(keys[i]);
                if (value == null) continue;
                long[] offsets = this.getPostInfoIndexOffsets(value);
                for (int j = 0; j < offsets.length; ++j) {
                    Object item = null;
                    if (usedOffsets.contains(offsets[j])) continue;
                    try {
                        XWG_PostInfoRecord record = (XWG_PostInfoRecord)((Object)this.getPostInfoDataAccess().getRecord(offsets[j]));
                        ICandidate candidate = this.makePostalCandidate(record);
                        usedOffsets.add(offsets[j]);
                        if (candidate == null) continue;
                        if (candidates == null) {
                            candidates = new ArrayList();
                        }
                        if (((InternalPostalCandidate)candidate).getPostCode1() == null) continue;
                        candidates.add(candidate);
                        continue;
                    }
                    catch (DataAccessException dataAccessException) {
                        // empty catch block
                    }
                }
            }
            if (candidates.isEmpty()) {
                candidates = null;
            }
        }
        return candidates;
    }

    protected long[] getPostInfoIndexOffsets(MapMarkerIndexValue value) {
        long[] values = null;
        if (value instanceof MapMarkerIndexSingleValue) {
            values = new long[]{((MapMarkerIndexSingleValue)value).getOffset()};
        } else if (value instanceof MapMarkerIndexMultiValue) {
            MapMarkerIndexMultiValue multiValue = (MapMarkerIndexMultiValue)value;
            values = new long[multiValue.getValueCount()];
            for (short i = 0; i < multiValue.getValueCount(); i = (short)(i + 1)) {
                values[i] = multiValue.getOffsetAt(i);
            }
        }
        return values;
    }

    protected ICandidate makePostalCandidate(PostInfoRecord record) throws LocalizationException {
        XWG_InternalPostalCandidate candidate = (XWG_InternalPostalCandidate)this.getPostInfoCandidateType();
        candidate.setAlternateCountryArray(((XWG_PostInfoRecord)record).getAlternateCountryArray());
        candidate.setAreaName1(record.getAreaName1());
        candidate.setAreaName2(record.getAreaName2());
        candidate.setAreaName3(record.getAreaName3());
        candidate.setAreaName4(record.getAreaName4());
        candidate.setPostCode1(record.getPostalCode1());
        candidate.setCountry(((XWG_PostInfoRecord)record).getCountry());
        candidate.setPoint(record.getCentroid());
        candidate.setMatchLevel(record.getPrecision());
        candidate.setVendorCode(String.valueOf(this.getDataAccessType().getMetadata().getVendorCode()));
        return candidate;
    }

    private boolean doGBRPatterns(String postcode, Address addr, HashSet<XWG_SoundexKey> keySet) {
        XWG_SoundexKey key = null;
        GBR_POSTFULLCODEPATTERN1.matcher(postcode).matches();
        for (Pattern pattern : GBR_Patterns) {
            Matcher matcher;
            if (!pattern.matcher(postcode).matches() || !(matcher = pattern.matcher(postcode)).find() || matcher.groupCount() != 2) continue;
            StringBuilder newPC = new StringBuilder(matcher.group(1));
            newPC.append(' ');
            newPC.append(matcher.group(2).trim().substring(0, 1));
            key = (XWG_SoundexKey)XWGSoundex.getStringKey(newPC.toString());
            if (key == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ALT_GBRPC_KEY", newPC.toString());
            addr.setAdditionalFields(map);
            keySet.add(key);
            return true;
        }
        return false;
    }

    protected MapMarkerIndexKey[] makePostInfoKeys(Address addr, IConstraints constraints) {
        ISO3166 iso;
        HashSet<XWG_SoundexKey> keySet = new HashSet<XWG_SoundexKey>();
        boolean buildCountryKeys = !StringUtilities.isEmpty((String)addr.getCountry()) && ((XWG_Constraints)constraints).useCountryKeys();
        boolean bHasPC = !StringUtilities.isEmpty((String)addr.getPostCode1());
        XWG_SoundexKey key = null;
        if (bHasPC) {
            HashMap<String, String> map;
            String newPC;
            Matcher matcher;
            boolean bGBR_patterns;
            String postcode = addr.getPostCode1();
            key = (XWG_SoundexKey)XWGSoundex.getStringKey(postcode);
            if (key != null) {
                keySet.add(key);
            }
            if (!(bGBR_patterns = this.doGBRPatterns(postcode, addr, keySet)) && NLD_POSTCODE_PATTERN.matcher(postcode).matches()) {
                matcher = NLD_POSTCODE_PATTERN.matcher(postcode);
                if (matcher.find() && matcher.groupCount() == 2 && (key = (XWG_SoundexKey)XWGSoundex.getStringKey(newPC = matcher.group(1).trim())) != null) {
                    map = new HashMap<String, String>();
                    map.put("ALT_NUMERICPC_KEY", newPC);
                    addr.setAdditionalFields(map);
                    keySet.add(key);
                }
            } else if (!bGBR_patterns && PRT_POSTCODE_PATTERN.matcher(postcode).matches()) {
                matcher = PRT_POSTCODE_PATTERN.matcher(postcode);
                if (matcher.find() && matcher.groupCount() == 2 && (key = (XWG_SoundexKey)XWGSoundex.getStringKey(newPC = matcher.group(1).trim())) != null) {
                    map = new HashMap();
                    map.put("ALT_NUMERICPC_KEY", newPC);
                    addr.setAdditionalFields(map);
                    keySet.add(key);
                }
            } else if (!bGBR_patterns && postcode.trim().equalsIgnoreCase("BBND1ZZ") && addr.getAdditionalFields().get("PC1_NOSPACES") == null) {
                HashMap map2 = addr.getAdditionalFields();
                StringBuilder pcWithSpace = new StringBuilder(postcode.substring(0, 4).trim());
                pcWithSpace.append(' ');
                pcWithSpace.append(postcode.substring(4));
                map2.put("PC1_WITHSPACE", pcWithSpace.toString());
                addr.setAdditionalFields(map2);
            }
        }
        int countryCode = -1;
        if (buildCountryKeys && (iso = ISO3166.findCountryByISO3((String)addr.getCountry())) != null) {
            try {
                countryCode = Integer.valueOf(iso.getCountryNumber());
            }
            catch (NumberFormatException map2) {
                // empty catch block
            }
        }
        MapMarkerIndexKey[] wrapped = keySet.toArray(new MapMarkerIndexKey[keySet.size()]);
        for (int i = 0; i < wrapped.length; ++i) {
            wrapped[i] = buildCountryKeys ? new XWG_MultiLevelSoundexIndexKey((XWG_SoundexKey)wrapped[i], countryCode) : new XWG_MultiLevelNoCountrySoundexIndexKey((XWG_SoundexKey)wrapped[i]);
        }
        return wrapped;
    }

    protected IMapMarkerIndex getPostInfoIndexType() {
        return new XWG_ReadOnlyMultiLevelSoundexIndexFile();
    }

    protected IMapMarkerIndex getPostInfoNoCountryIndexType() {
        return new XWG_ReadOnlyMultiLevelNoCountrySoundexIndexFile();
    }

    protected IDataAccess getDataAccessType() {
        return new OnDemandDataAccess(this.getDataAccessHelperType());
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new XWG_PostInfoPreLoadedDataHelper();
    }
}

