/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary.index;

import com.mapinfo.mapmarker.XWG.XWGSoundex;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoBase;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoRecord;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_SoundexKey;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class XWG_GeoInfoSoundexIndexer
extends GeoInfoSoundexIndexer {
    private XWG_GeoInfoPreLoadedDataHelper m_geoInfoHelper = new XWG_GeoInfoPreLoadedDataHelper();

    public XWG_GeoInfoSoundexIndexer() {
        this.sndx = new XWGSoundex();
    }

    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        ISO3166 iso;
        XWG_GeoInfoRecord record = this.getRecord(item, metadata);
        String country = record.getCountry();
        int countryCodeNumber = -1;
        if (country != null && (iso = ISO3166.findCountryByISO3((String)country)) != null) {
            try {
                countryCodeNumber = Integer.valueOf(iso.getCountryNumber());
            }
            catch (NumberFormatException ex) {
                DataCreationLogger.getLogger().logError("Cannot find ISO code for country " + country);
            }
        }
        Set<ISoundexKey> keys = this.createKeySet(record);
        ArrayList<XWG_GeoBase> wrapped = new ArrayList<XWG_GeoBase>(keys.size());
        for (ISoundexKey key : keys) {
            wrapped.add(new XWG_GeoBase((XWG_SoundexKey)key, countryCodeNumber));
        }
        return wrapped;
    }

    protected XWG_GeoInfoRecord getRecord(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        try {
            return (XWG_GeoInfoRecord)((Object)this.m_geoInfoHelper.makeDataRecord((IDataFileDataItem)item, (MMJDataFileMetadata)metadata));
        }
        catch (LocalizationException e) {
            DataCreationLogger.getLogger().logError("Error converting data item into XWG_GeoInfoRecord.");
            throw new DataCreationException((Throwable)e);
        }
    }

    protected Set<ISoundexKey> createKeySet(XWG_GeoInfoRecord record) {
        HashSet<ISoundexKey> keys = new HashSet<ISoundexKey>();
        keys.addAll(this.makeKeysForArea(record.getAreaName4()));
        keys.addAll(this.makeKeysForArea(record.getAltAreaName4Array()));
        if (keys.size() == 0) {
            keys.addAll(this.makeKeysForArea(record.getAreaName3()));
            keys.addAll(this.makeKeysForArea(record.getAltAreaName3Array()));
        }
        if (keys.size() == 0) {
            keys.addAll(this.makeKeysForArea(record.getAreaName2()));
            keys.addAll(this.makeKeysForArea(record.getAltAreaName2Array()));
        }
        if (keys.size() == 0) {
            keys.addAll(this.makeKeysForArea(record.getAreaName1()));
            keys.addAll(this.makeKeysForArea(record.getAltAreaName1Array()));
        }
        if (keys.size() == 0) {
            DataCreationLogger.getLogger().logError("Record has no area names only country " + record.getCountry());
            keys.addAll(this.makeKeysForArea(record.getCountry()));
        }
        if (keys.size() == 0) {
            DataCreationLogger.getLogger().logError("No soundex keys created!");
        }
        return keys;
    }

    protected Collection<ISoundexKey> makeKeysForArea(String[] areaname) {
        HashSet<ISoundexKey> keys = new HashSet<ISoundexKey>();
        for (int i = 0; areaname != null && i < areaname.length; ++i) {
            keys.addAll(this.makeKeysForArea(areaname[i]));
        }
        return keys;
    }

    protected Collection<ISoundexKey> makeKeysForArea(String areaname) {
        HashSet<ISoundexKey> keys = new HashSet<ISoundexKey>();
        if (!StringUtilities.isEmpty((String)areaname)) {
            ISoundexKey key = this.sndx.getSoundex(areaname);
            if (key != null) {
                keys.add(key);
                if (((XWG_SoundexKey)key).getFirstChar() == '\u0000') {
                    DataCreationLogger.getLogger().logInternalError("Null first char in string key! AreaName = " + areaname);
                }
            } else {
                DataCreationLogger.getLogger().logInternalError("Null soundex key created! AreaName: " + areaname);
            }
            if ((key = XWGSoundex.getStringKey(areaname)) != null) {
                keys.add(key);
                if (((XWG_SoundexKey)key).getFirstChar() == '\u0000') {
                    DataCreationLogger.getLogger().logInternalError("Null first char in string key! AreaName = " + areaname);
                }
            } else {
                DataCreationLogger.getLogger().logInternalError("Null string key created! AreaName: " + areaname);
            }
        }
        return keys;
    }
}

