/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary.index;

import com.mapinfo.mapmarker.XWG.XWGSoundex;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostInfoRecord;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostalBase;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_SoundexKey;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class XWG_PostInfoIndexer {
    private Soundex m_sndx;
    private XWG_PostInfoPreLoadedDataHelper m_postInfoHelper = new XWG_PostInfoPreLoadedDataHelper();

    public XWG_PostInfoIndexer() {
        this.m_sndx = new XWGSoundex();
    }

    protected MMJComplexDataFileMetadata getMetadataType() {
        return new MMJComplexDataFileMetadata();
    }

    protected ArrayList makeKeys(PostInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        ISO3166 iso;
        XWG_PostInfoRecord record = this.getRecord(item, metadata);
        String country = record.getCountry();
        int countryCodeNumber = -1;
        if (country != null && (iso = ISO3166.findCountryByISO3((String)country)) != null) {
            try {
                countryCodeNumber = Integer.valueOf(iso.getCountryNumber());
            }
            catch (NumberFormatException ex) {
                DataCreationLogger.getLogger().logError("Cannot find ISO code for country " + country);
            }
        }
        Set<ISoundexKey> keys = this.createKeySet(record);
        ArrayList<XWG_PostalBase> wrapped = new ArrayList<XWG_PostalBase>(keys.size());
        for (ISoundexKey key : keys) {
            ((XWG_SoundexKey)key).setKeyType((byte)1);
            wrapped.add(new XWG_PostalBase((XWG_SoundexKey)key, countryCodeNumber));
        }
        return wrapped;
    }

    public void processPostInfoFile(String postInfoBaseName) throws DataCreationException {
        RandomAccessFile postInfoFile = null;
        try {
            postInfoFile = new RandomAccessFile(postInfoBaseName + ".jdr", "r");
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to open postinfo data file: " + postInfoBaseName + ".jdr");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException((Throwable)e);
        }
        MMJComplexDataFileMetadata metadata = this.getMetadataType();
        try {
            metadata.read((DataInput)postInfoFile);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to read the postinfo metadata.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException((Throwable)e);
        }
        RandomAccessFile tempIndexFile = null;
        try {
            tempIndexFile = new RandomAccessFile(postInfoBaseName + ".tdx", "rw");
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to create temporary index file for postinfo.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException((Throwable)e);
        }
        try {
            long pos;
            block17: while (true) {
                PostInfoDataItem item = null;
                pos = -1L;
                try {
                    pos = postInfoFile.getFilePointer();
                    item = new PostInfoDataItem();
                    try {
                        item.read((DataInput)postInfoFile, (MMJDataFileMetadata)metadata);
                    }
                    catch (MMJEDataCorruptedException e) {
                        DataCreationLogger.getLogger().logInternalError("ERROR: Unable to read postinfo item at : " + pos);
                        DataCreationLogger.getLogger().logInternalError(e.getMessage());
                        DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                        throw new DataCreationException((Throwable)e);
                    }
                }
                catch (EOFException EOFEx) {
                    throw EOFEx;
                }
                catch (IOException e) {
                    throw new DataCreationException((Throwable)e);
                }
                ArrayList keyList = this.makeKeys(item, metadata);
                if (keyList == null || keyList.size() <= 0) break;
                int i = 0;
                while (true) {
                    if (i >= keyList.size()) continue block17;
                    try {
                        ((ISoundexKey)keyList.get(i)).write((DataOutput)tempIndexFile);
                        tempIndexFile.writeLong(pos);
                    }
                    catch (IOException e) {
                        throw new DataCreationException((Throwable)e);
                    }
                    ++i;
                }
                break;
            }
            DataCreationLogger.getLogger().logInternalError("ERROR: no keys for geoinfo data item @: " + pos);
            throw new DataCreationException("ERROR: no keys for geoinfo data item @: " + pos);
        }
        catch (EOFException EOFEx) {
            DataCreationLogger.getLogger().logStatus("Finished indexing geoinfo data file.");
            try {
                postInfoFile.close();
                tempIndexFile.close();
            }
            catch (IOException e) {
                throw new DataCreationException((Throwable)e);
            }
            DataCreationLogger.getLogger().logStatus("Finished creating temporary soundex index file.");
            return;
        }
    }

    protected XWG_PostInfoRecord getRecord(PostInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        try {
            return this.m_postInfoHelper.makeDataRecord((IDataFileDataItem)item, (MMJDataFileMetadata)metadata);
        }
        catch (LocalizationException e) {
            DataCreationLogger.getLogger().logError("Error converting data item into XWG_PostInfoRecord.");
            throw new DataCreationException((Throwable)e);
        }
    }

    protected Set<ISoundexKey> createKeySet(XWG_PostInfoRecord record) {
        HashSet<ISoundexKey> keys = new HashSet<ISoundexKey>();
        keys.addAll(this.makeKeysForPostCode(record.getPostalCode1()));
        return keys;
    }

    protected Collection<ISoundexKey> makeKeysForPostCode(String pcode) {
        HashSet<ISoundexKey> keys = new HashSet<ISoundexKey>();
        if (!StringUtilities.isEmpty((String)pcode)) {
            ISoundexKey key = XWGSoundex.getStringKey(pcode);
            if (key != null) {
                keys.add(key);
                if (((XWG_SoundexKey)key).getFirstChar() == '\u0000') {
                    DataCreationLogger.getLogger().logInternalError("Null first char in string key! AreaName = " + pcode);
                }
            } else {
                DataCreationLogger.getLogger().logInternalError("Null string key created! AreaName: " + pcode);
            }
        }
        return keys;
    }
}

