/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary.postgresql;

import com.mapinfo.mapmarker.XWG.dp.binary.postgresql.XWG_PostgreSQLTable;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class XWG_PostgreSQLDataSource
implements IDataSource {
    public static final String EXCEPTION_NO_SELECT_STATEMENT = "No select statement was given.";
    protected Properties m_properties;
    protected Connection m_conn;
    protected PreparedStatement m_metadataSelectStatement;
    protected ResultSet m_metadataResultSet;
    private DATA_TYPE_ENUM m_type = DATA_TYPE_ENUM.GEOINFO;
    private int m_recordCount = 0;
    private static final String[] GEOINFO_FORMAT_1_UNUSED_KEYS = new String[]{"geoInfo_altAreaName1", "geoInfo_altAreaName2", "geoInfo_altAreaName4", "geoInfo_areaName4"};
    private static final String[] GEOINFO_FORMAT_4_UNUSED_KEYS = new String[]{"geoInfo_altAreaName2", "geoInfo_areaName4", "geoInfo_altAreaName4"};
    private static final String[] POSTINFO_FORMAT_2_UNUSED_KEYS = new String[]{"postInfo_areaName2", "postInfo_areaName3", "postInfo_areaName4"};
    private static final String[] POSTINFO_FORMAT_3_UNUSED_KEYS = new String[]{"postInfo_areaName2", "postInfo_areaName4"};
    protected HashSet<XWG_PostgreSQLTable> m_tables;
    protected Iterator<XWG_PostgreSQLTable> m_tableIterator;
    protected XWG_PostgreSQLTable m_currentTable;

    public XWG_PostgreSQLDataSource(Properties properties) {
        this.m_properties = properties;
        if (this.m_properties.containsKey("postInfo_create") && this.m_properties.getProperty("postInfo_create").equalsIgnoreCase("YES")) {
            this.m_type = DATA_TYPE_ENUM.POSTINFO;
        }
    }

    public void open(String[] args) throws DataSourceException {
        if (StringUtilities.isEmpty((String)args[3])) {
            throw new DataSourceException(11, EXCEPTION_NO_SELECT_STATEMENT);
        }
        try {
            this.m_conn = this.getConnection(args[0], args[1], args[2]);
            this.m_metadataSelectStatement = this.m_conn.prepareStatement(args[3], 1003, 1007);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(11, (Throwable)SQLEx);
        }
        try {
            this.m_metadataResultSet = this.m_metadataSelectStatement.executeQuery();
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(10, (Throwable)SQLEx);
        }
        Properties format1Properties = new Properties();
        Properties format4Properties = new Properties();
        Properties PostInfoformat2Properties = new Properties();
        Properties PostInfoformat3Properties = new Properties();
        if (this.m_type == DATA_TYPE_ENUM.GEOINFO) {
            format1Properties.putAll((Map<?, ?>)this.m_properties);
            for (String key : GEOINFO_FORMAT_1_UNUSED_KEYS) {
                System.out.println("removing key from format1 properties: " + key);
                format1Properties.remove(key);
            }
            format4Properties.putAll((Map<?, ?>)this.m_properties);
            for (String key : GEOINFO_FORMAT_4_UNUSED_KEYS) {
                System.out.println("removing key from format4 properties: " + key);
                format4Properties.remove(key);
            }
        } else {
            PostInfoformat2Properties.putAll((Map<?, ?>)this.m_properties);
            for (String key : POSTINFO_FORMAT_2_UNUSED_KEYS) {
                System.out.println("removing key from postinfo format2 properties: " + key);
                PostInfoformat2Properties.remove(key);
            }
            PostInfoformat3Properties.putAll((Map<?, ?>)this.m_properties);
            for (String key : POSTINFO_FORMAT_3_UNUSED_KEYS) {
                System.out.println("removing key from postinfo format3 properties: " + key);
                PostInfoformat3Properties.remove(key);
            }
        }
        this.m_tables = new HashSet();
        JDBCDataSourceRecordObjects metadataObject = this.getNextMetadataRecord();
        try {
            while (metadataObject != null) {
                String country = this.m_metadataResultSet.getString("COUNTRY");
                if (this.m_type == DATA_TYPE_ENUM.POSTINFO) {
                    String postInfoSource = this.m_metadataResultSet.getString("POSTINFO_SOURCE");
                    String postInfoVintage = this.m_metadataResultSet.getString("POSTINFO_VINTAGE");
                    int postInfoFormat = this.m_metadataResultSet.getInt("POSTINFO_FORMAT");
                    System.out.println("country is " + country + " format is " + postInfoFormat + " source is " + postInfoSource);
                    if (!StringUtilities.isEmpty((String)postInfoSource)) {
                        switch (postInfoFormat) {
                            case 2: {
                                this.m_tables.add(new XWG_PostgreSQLTable(this.m_conn, PostInfoformat2Properties, postInfoSource, country));
                                break;
                            }
                            case 3: {
                                this.m_tables.add(new XWG_PostgreSQLTable(this.m_conn, PostInfoformat3Properties, postInfoSource, country));
                                break;
                            }
                            default: {
                                this.m_tables.add(new XWG_PostgreSQLTable(this.m_conn, this.m_properties, postInfoSource, country));
                            }
                        }
                    }
                } else {
                    String geoInfoSource = this.m_metadataResultSet.getString("GEOINFO_SOURCE");
                    String geoInfoVintage = this.m_metadataResultSet.getString("GEOINFO_VINTAGE");
                    int geoInfoFormat = this.m_metadataResultSet.getInt("GEOINFO_FORMAT");
                    System.out.println("country is " + country + " format is " + geoInfoFormat + " source is " + geoInfoSource);
                    if (!StringUtilities.isEmpty((String)geoInfoSource)) {
                        switch (geoInfoFormat) {
                            case 1: {
                                this.m_tables.add(new XWG_PostgreSQLTable(this.m_conn, format1Properties, geoInfoSource, country));
                                break;
                            }
                            case 4: {
                                this.m_tables.add(new XWG_PostgreSQLTable(this.m_conn, format4Properties, geoInfoSource, country));
                                break;
                            }
                            default: {
                                this.m_tables.add(new XWG_PostgreSQLTable(this.m_conn, this.m_properties, geoInfoSource, country));
                            }
                        }
                    }
                }
                System.out.println("getting next metadata object");
                metadataObject = this.getNextMetadataRecord();
            }
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(13, (Throwable)SQLEx);
        }
        try {
            if (this.m_metadataResultSet != null) {
                this.m_metadataResultSet.close();
                this.m_metadataResultSet = null;
            }
            if (this.m_metadataSelectStatement != null) {
                this.m_metadataSelectStatement.close();
                this.m_metadataSelectStatement = null;
            }
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(12, (Throwable)SQLEx);
        }
        finally {
            this.m_metadataResultSet = null;
            this.m_metadataSelectStatement = null;
        }
        for (XWG_PostgreSQLTable table : this.m_tables) {
            System.out.println("table " + table.getCountryCode());
        }
        this.m_tableIterator = this.m_tables.iterator();
        this.openNextTable();
    }

    protected void openNextTable() throws DataSourceException {
        if (this.m_currentTable != null) {
            this.m_currentTable.close();
            this.m_currentTable = null;
        }
        if (this.m_tableIterator.hasNext()) {
            this.m_currentTable = this.m_tableIterator.next();
        }
        if (this.m_currentTable != null) {
            this.m_currentTable.open(null);
            this.m_recordCount += this.m_currentTable.getRecordCount();
            System.out.println("record count now " + this.m_recordCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DataSourceException {
        boolean bNoPreviousException = false;
        try {
            if (this.m_currentTable != null) {
                this.m_currentTable.close();
                this.m_currentTable = null;
            }
            bNoPreviousException = true;
        }
        finally {
            this.m_currentTable = null;
            if (this.m_conn != null) {
                try {
                    this.m_conn.close();
                }
                catch (SQLException SQLEx) {
                    if (bNoPreviousException) {
                        throw new DataSourceException(12, (Throwable)SQLEx);
                    }
                }
                finally {
                    this.m_conn = null;
                }
            }
        }
    }

    public int getRecordCount() {
        return this.m_recordCount;
    }

    public IDataSourceRecordObjects getNextDataSourceRecordObjects() throws DataSourceException {
        if (this.m_currentTable == null) {
            return null;
        }
        IDataSourceRecordObjects retval = this.m_currentTable.getNextDataSourceRecordObjects();
        if (retval != null) {
            return retval;
        }
        this.openNextTable();
        if (this.m_currentTable == null) {
            return null;
        }
        return this.m_currentTable.getNextDataSourceRecordObjects();
    }

    public String getCurrentCountryCode() {
        if (this.m_currentTable != null) {
            return this.m_currentTable.getCountryCode();
        }
        return null;
    }

    protected Connection getConnection(String url, String user, String password) throws SQLException, DataSourceException {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException CNFEx) {
            throw new DataSourceException(11, (Throwable)CNFEx);
        }
        return DriverManager.getConnection(url, user, password);
    }

    private JDBCDataSourceRecordObjects getNextMetadataRecord() throws DataSourceException {
        if (this.m_metadataResultSet == null) {
            System.out.println("metadata result set null");
            return null;
        }
        try {
            if (this.m_metadataResultSet.next()) {
                System.out.println("metadata result set not null");
                return new JDBCDataSourceRecordObjects(this.m_metadataResultSet, this.m_properties);
            }
            System.out.println("metadata result set empty");
            return null;
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(13, (Throwable)SQLEx);
        }
    }

    private static enum DATA_TYPE_ENUM {
        GEOINFO,
        POSTINFO;

    }
}

