/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.intermediate;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.TempDataRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class XWG_InMemoryTempDataRecordHandler
implements ITempDataRecordHandler {
    private List m_dataRecordsList;
    private Iterator m_dataRecordsIterator;
    private boolean m_bUniqueRecords;

    public XWG_InMemoryTempDataRecordHandler() {
    }

    public XWG_InMemoryTempDataRecordHandler(boolean bUniqueRecords) {
        this.m_bUniqueRecords = bUniqueRecords;
    }

    public void open() {
        this.m_dataRecordsList = new ArrayList();
    }

    public void addTempDataRecord(TempDataRecord record) {
        int index = Collections.binarySearch(this.m_dataRecordsList, record);
        if (index < 0) {
            ++index;
            this.m_dataRecordsList.add(index *= -1, record);
        } else {
            TempDataRecord temp = (TempDataRecord)this.m_dataRecordsList.get(index);
            temp.addDataRecordID((IDataRecordID)record.getDataRecordIDs().get(0));
        }
    }

    public boolean hasNextTempDataRecord() {
        if (this.m_dataRecordsIterator == null) {
            this.sortAndSetupIterator();
        }
        return this.m_dataRecordsIterator.hasNext();
    }

    public TempDataRecord getNextTempDataRecord() {
        if (this.m_dataRecordsIterator == null) {
            this.sortAndSetupIterator();
        }
        TempDataRecord record = null;
        if (this.m_dataRecordsIterator.hasNext()) {
            record = (TempDataRecord)this.m_dataRecordsIterator.next();
            this.m_dataRecordsIterator.remove();
        }
        return record;
    }

    public int getTempDataRecordCount() throws DataSourceException {
        return this.m_dataRecordsList.size();
    }

    public void close() {
        if (this.m_dataRecordsList != null) {
            this.m_dataRecordsList.clear();
        }
        this.m_dataRecordsList = null;
        this.m_dataRecordsIterator = null;
    }

    private void sortAndSetupIterator() {
        this.m_dataRecordsIterator = this.m_dataRecordsList.iterator();
    }
}

