/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.intermediate;

import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoRecord;
import com.mapinfo.mapmarker.XWG.dp.intermediate.XWG_IntermediateDataItem;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateFileStreetDataRecordID;
import com.mapinfo.mapmarker.utils.BlobUtilities;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;

public class XWG_IntermediateGeoInfoDataFileFormatHandler
implements IIntermediateDataHandler {
    private File m_file;
    private RandomAccessDataStream m_stream;

    public XWG_IntermediateGeoInfoDataFileFormatHandler(String fileName) {
        this.m_file = new File(fileName);
    }

    public void open() throws DataSourceException {
        this.delete();
        try {
            this.m_stream = new RandomAccessDataStream(this.m_file);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(14, (Throwable)IOEx);
        }
    }

    public void close() throws DataSourceException {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
                this.m_stream = null;
            }
            catch (IOException IOEx) {
                throw new DataSourceException(14, (Throwable)IOEx);
            }
        }
    }

    public void cleanUp() throws DataSourceException {
        this.delete();
    }

    private void delete() throws DataSourceException {
        if (DebugLevel.getDebugLevel((int)5) == 0) {
            if (this.m_file.exists()) {
                if (!this.m_file.delete()) {
                    DataCreationLogger.getLogger().logInternalError("XWG Data Provider:: delete(): ");
                    DataCreationLogger.getLogger().logError("Unable to delete file: " + this.m_file.getAbsolutePath());
                    throw new DataSourceException(14);
                }
            } else {
                DataCreationLogger.getLogger().logStatus("Tried to delete " + this.m_file.getAbsolutePath() + " but it did not exist.");
            }
        } else {
            DataCreationLogger.getLogger().logStatus("Did not attempt to delete " + this.m_file.getAbsolutePath() + " due to current DebugLevel.");
        }
    }

    protected long getFilePointer() throws IOException {
        return this.m_stream.getFilePointer();
    }

    protected DataInput getInput() throws DataSourceException {
        return this.m_stream;
    }

    protected DataOutput getOutput() {
        return this.m_stream;
    }

    protected void seek(long offset) throws IOException {
        this.m_stream.seek(offset);
    }

    protected String prepareStringForDataItem(String item) {
        if (item == null) {
            return null;
        }
        if ((item = item.trim()).length() > 0) {
            return item;
        }
        return null;
    }

    protected void putIsoCountry(String countryCode, XWG_IntermediateDataItem geoInfo) throws MMJETypeArraySizeExceededException {
        ISO3166 isoRec = ISO3166.findCountryByISO3((String)countryCode);
        if (isoRec == null) {
            geoInfo.putString(32, countryCode);
            return;
        }
        try {
            short num = Short.parseShort(isoRec.getCountryNumber());
            if (num < 127) {
                geoInfo.putByte(36, (byte)num);
            } else {
                geoInfo.putShort(32, num);
            }
        }
        catch (NumberFormatException ex) {
            geoInfo.putString(32, countryCode);
        }
    }

    protected void convertGeoInfoRecordToDataItem(MMJGeoInfoRecord geoInfoRecord, XWG_IntermediateDataItem dataItem) throws DataSourceException {
        XWG_GeoInfoRecord geoRec = (XWG_GeoInfoRecord)geoInfoRecord.getRecord();
        try {
            String[] alts;
            String dataString;
            dataItem.putByte(0, geoRec.getPrecision());
            if (geoRec.getPoint() != null) {
                dataItem.putDouble(0, geoRec.getPoint().getX());
                dataItem.putDouble(1, geoRec.getPoint().getY());
            }
            if ((dataString = this.prepareStringForDataItem(geoRec.getCountry())) != null) {
                this.putIsoCountry(dataString, dataItem);
            }
            if (geoRec.getAlternateCountryArray() != null) {
                dataItem.putBlob(36, BlobUtilities.encode((String[])geoRec.getAlternateCountryArray()));
            }
            if ((dataString = this.prepareStringForDataItem(geoRec.getAreaName1())) != null) {
                dataItem.putString(0, dataString);
            }
            if ((dataString = this.prepareStringForDataItem(geoRec.getAreaName2())) != null) {
                dataItem.putString(1, dataString);
            }
            if ((dataString = this.prepareStringForDataItem(geoRec.getAreaName3())) != null) {
                dataItem.putString(2, dataString);
            }
            if ((dataString = this.prepareStringForDataItem(geoRec.getAreaName4())) != null) {
                dataItem.putString(3, dataString);
            }
            if (geoRec.getCityRank() > 0) {
                dataItem.putByte(37, geoRec.getCityRank());
            }
            if ((alts = geoRec.getAltAreaName1Array()) != null) {
                dataItem.putBlob(32, BlobUtilities.encode((String[])alts));
            }
            if ((alts = geoRec.getAltAreaName2Array()) != null) {
                dataItem.putBlob(33, BlobUtilities.encode((String[])alts));
            }
            if ((alts = geoRec.getAltAreaName3Array()) != null) {
                dataItem.putBlob(34, BlobUtilities.encode((String[])alts));
            }
            if ((alts = geoRec.getAltAreaName4Array()) != null) {
                dataItem.putBlob(35, BlobUtilities.encode((String[])alts));
            }
        }
        catch (MMJETypeArraySizeExceededException ex) {
            DataCreationLogger.getLogger().logInternalError("Unable to Geoinfo data.");
            DataCreationLogger.getLogger().logInternalError(ex.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)ex);
            throw new DataSourceException(14, (Throwable)ex);
        }
        catch (IOException ioex) {
            throw new DataSourceException(14, (Throwable)ioex);
        }
    }

    protected XWG_IntermediateDataItem makeGeoInfoDataItem(MMJGeoInfoRecord geoInfoRec) throws DataSourceException {
        XWG_IntermediateDataItem item = new XWG_IntermediateDataItem();
        this.convertGeoInfoRecordToDataItem(geoInfoRec, item);
        return item;
    }

    protected MMJGeoInfoRecord makeGeoInfoDataRecord(XWG_IntermediateDataItem item) throws DataSourceException {
        MMJGeoInfoRecord rec = new MMJGeoInfoRecord((GeoInfoRecord)new XWG_GeoInfoRecord(), (MapMarkerIndexKey)new MiStringIndexKey());
        this.convertGeoInfoDataItem2Record(rec, item);
        return rec;
    }

    private String[] decodeStringArray(byte[] bytes) throws LocalizationException {
        try {
            String[] strs = BlobUtilities.decodeStringArray((byte[])bytes);
            return strs;
        }
        catch (IOException e) {
            throw new LocalizationException((Throwable)e);
        }
    }

    protected void convertGeoInfoDataItem2Record(MMJGeoInfoRecord mmjrec, XWG_IntermediateDataItem item) throws DataSourceException {
        try {
            byte[] alts;
            ISO3166 isoRec;
            XWG_GeoInfoRecord rec = (XWG_GeoInfoRecord)mmjrec.getRecord();
            if (item.hasByte(0)) {
                rec.setPrecision(item.getByte(0));
            }
            DirectPosition pnt = new DirectPosition();
            if (item.hasDouble(0) && item.hasDouble(1)) {
                pnt.setX(item.getDouble(0));
                pnt.setY(item.getDouble(1));
                rec.setPoint(pnt);
            }
            int code = -1;
            if (item.hasString(32)) {
                rec.setCountry(item.getString(32));
            } else if (item.hasByte(36)) {
                code = item.getByte(36);
            } else if (item.hasShort(32)) {
                code = item.getShort(32);
            }
            if (code != -1 && (isoRec = ISO3166.findCountryByNumber((String)StringUtilities.intToLeadingZeroString((int)3, (int)code))) != null) {
                rec.setCountry(isoRec.getISO3Country());
            }
            if (item.hasBlob(36)) {
                rec.setAlternateCountryArray(this.decodeStringArray(item.getBlob(36)));
            }
            if (item.hasString(0)) {
                rec.setAreaName1(item.getString(0));
            }
            if (item.hasString(1)) {
                rec.setAreaName2(item.getString(1));
            }
            if (item.hasString(2)) {
                rec.setAreaName3(item.getString(2));
            }
            if (item.hasString(3)) {
                rec.setAreaName4(item.getString(3));
            }
            if (item.hasByte(37)) {
                rec.setCityRank(item.getByte(37));
            }
            if (item.hasBlob(32)) {
                alts = item.getBlob(32);
                rec.setAltAreaName1Array(this.decodeStringArray(alts));
            }
            if (item.hasBlob(33)) {
                alts = item.getBlob(33);
                rec.setAltAreaName2Array(this.decodeStringArray(alts));
            }
            if (item.hasBlob(34)) {
                alts = item.getBlob(34);
                rec.setAltAreaName3Array(this.decodeStringArray(alts));
            }
            if (item.hasBlob(35)) {
                alts = item.getBlob(35);
                rec.setAltAreaName4Array(this.decodeStringArray(alts));
            }
        }
        catch (MMJETypeArraySizeExceededException ex) {
            DataCreationLogger.getLogger().logInternalError("Unable to Geoinfo data.");
            DataCreationLogger.getLogger().logInternalError(ex.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)ex);
            throw new DataSourceException(14, (Throwable)ex);
        }
        catch (LocalizationException locex) {
            throw new DataSourceException(14, (Throwable)locex);
        }
    }

    public Object getIntermediateData(IDataRecordID ID) throws DataSourceException {
        try {
            IntermediateFileStreetDataRecordID interID = (IntermediateFileStreetDataRecordID)ID;
            this.seek(interID.getOffset());
            XWG_IntermediateDataItem dataItem = new XWG_IntermediateDataItem();
            dataItem.read(this.getInput());
            return this.makeGeoInfoDataRecord(dataItem);
        }
        catch (IOException e) {
            throw new DataSourceException(13, (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataSourceException(13, (Throwable)e);
        }
    }

    public IDataRecordID putIntermediateData(Object record) throws DataSourceException {
        MMJGeoInfoRecord geoinfo = (MMJGeoInfoRecord)record;
        try {
            IntermediateFileStreetDataRecordID ID = new IntermediateFileStreetDataRecordID(this.getFilePointer());
            XWG_IntermediateDataItem dataItem = this.makeGeoInfoDataItem(geoinfo);
            dataItem.write(this.getOutput());
            return ID;
        }
        catch (IOException e) {
            throw new DataSourceException(13, (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataSourceException(13, (Throwable)e);
        }
    }
}

