/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.oracle;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecordObjects;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class XWG_OracleTable
implements IDataSource {
    private int m_recordCount = 0;
    private String m_country;
    protected String m_tableName;
    private String m_query;
    private OracleConnection m_connection;
    protected Properties m_properties;
    protected OraclePreparedStatement m_selectStatement;
    protected OracleResultSet m_rs;

    public XWG_OracleTable(OracleConnection connection, Properties properties, String tableName, String country) {
        this.m_connection = connection;
        this.m_properties = properties;
        this.m_tableName = tableName;
        this.m_country = country;
        this.m_query = this.buildTableQuery(tableName);
    }

    public IDataSourceRecordObjects getNextDataSourceRecordObjects() throws DataSourceException {
        if (this.m_rs == null) {
            return null;
        }
        try {
            if (this.m_rs.next()) {
                return new JDBCDataSourceRecordObjects((ResultSet)this.m_rs, this.m_properties);
            }
            return null;
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(13, (Throwable)SQLEx);
        }
    }

    public void close() throws DataSourceException {
        boolean bResultSetClosed = false;
        try {
            if (this.m_rs != null) {
                this.m_rs.close();
            }
            bResultSetClosed = true;
            this.m_rs = null;
            if (this.m_selectStatement != null) {
                this.m_selectStatement.close();
            }
            this.m_selectStatement = null;
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(12, (Throwable)SQLEx);
        }
        finally {
            if (!bResultSetClosed) {
                try {
                    if (this.m_selectStatement != null) {
                        this.m_selectStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            this.m_rs = null;
            this.m_selectStatement = null;
            this.m_connection = null;
        }
    }

    private String buildTableQuery(String name) {
        StringBuilder sb = new StringBuilder("select * from ");
        sb.append(name);
        return sb.toString();
    }

    public void open(String[] args) throws DataSourceException {
        this.determineRecordCount();
        try {
            this.m_selectStatement = (OraclePreparedStatement)this.m_connection.prepareStatement(this.m_query, 1003, 1007);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(11, (Throwable)SQLEx);
        }
        try {
            this.m_rs = (OracleResultSet)this.m_selectStatement.executeQuery();
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(10, (Throwable)SQLEx);
        }
    }

    public int getRecordCount() {
        return this.m_recordCount;
    }

    protected void determineRecordCount() {
        try {
            OraclePreparedStatement recordCountStatement = (OraclePreparedStatement)this.m_connection.prepareStatement("SELECT COUNT(*) FROM " + this.m_tableName, 1003, 1007);
            OracleResultSet rs = (OracleResultSet)recordCountStatement.executeQuery();
            if (rs.next()) {
                this.m_recordCount = rs.getInt(1);
            }
            rs.close();
            recordCountStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getCountryCode() {
        return this.m_country;
    }
}

