/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.filters;

import com.mapinfo.mapmarker.XWG.XWG_InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class SingleLineInputTokenMatchFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        XWG_InternalGeographicCandidate best = (XWG_InternalGeographicCandidate)bestCandidate;
        XWG_InternalGeographicCandidate other = (XWG_InternalGeographicCandidate)otherCandidate;
        if (best.getCombinedScore() != other.getCombinedScore() || best.getAreaName1Score() != other.getAreaName1Score() || best.getAreaName2Score() != other.getAreaName2Score() || best.getAreaName3Score() != other.getAreaName3Score() || best.getAreaName4Score() != other.getAreaName4Score() || best.getCountryScore() != other.getCountryScore()) {
            return false;
        }
        if (other.getPrecision() == 10) {
            String otherCity = other.getAreaName3();
            if (!StringUtilities.equalStrings((String)best.getAreaName3(), (String)otherCity)) {
                if (StringUtilities.equalStrings((String)otherCity, (String)best.getAreaName1()) || StringUtilities.equalStrings((String)otherCity, (String)best.getAreaName2())) {
                    return true;
                }
                if (best.getStringScorer().scoreString(otherCity, best.getAreaName1()) == 1.0) {
                    return true;
                }
                if (best.getStringScorer().scoreString(otherCity, best.getAreaName2()) == 1.0) {
                    return true;
                }
            }
        } else if (other.getPrecision() == 11) {
            String otherLocality = other.getAreaName4();
            if (!StringUtilities.equalStrings((String)best.getAreaName4(), (String)otherLocality)) {
                if (StringUtilities.equalStrings((String)otherLocality, (String)best.getAreaName1()) || StringUtilities.equalStrings((String)otherLocality, (String)best.getAreaName2()) || StringUtilities.equalStrings((String)otherLocality, (String)best.getAreaName3())) {
                    return true;
                }
                if (best.getStringScorer().scoreString(otherLocality, best.getAreaName1()) == 1.0) {
                    return true;
                }
                if (best.getStringScorer().scoreString(otherLocality, best.getAreaName2()) == 1.0) {
                    return true;
                }
                if (best.getStringScorer().scoreString(otherLocality, best.getAreaName3()) == 1.0) {
                    return true;
                }
            }
        }
        return false;
    }
}

