/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.geographic;

import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.core.geographic.ICoreGeographicCentroidFilter;
import com.mapinfo.mapmarker.core.geographic.IGeographicCentroidFilter;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class XWG_GeographicCentroidFilter
implements IGeographicCentroidFilter {
    public List filterGeographicCloseMatches(IHandler handler) {
        boolean bDebug;
        Address[] inputAddresses = handler.getParsedAddressArray();
        List geographicCandidates = handler.getMatchResults();
        ICloseMatchFilterRule[] closeMatchRules = ((ICoreGeographicCentroidFilter)handler).getGeographicCentroidFilterRules();
        if (closeMatchRules == null) {
            return geographicCandidates;
        }
        boolean resort = false;
        InternalGeographicCandidate bestCandidate = null;
        Iterator bestCandidateIterator = geographicCandidates.iterator();
        boolean bl = bDebug = DebugLevel.getDebugLevel((int)4) >= 2;
        while (bestCandidateIterator.hasNext()) {
            InternalGeographicCandidate otherCandidate = null;
            boolean bGetNextBestCandidate = false;
            boolean bGetNextOtherCandidate = true;
            bestCandidate = (InternalGeographicCandidate)bestCandidateIterator.next();
            if (!bestCandidate.isCloseMatch()) continue;
            Iterator otherCandidateIterator = geographicCandidates.iterator();
            while (otherCandidateIterator.hasNext() && bGetNextOtherCandidate) {
                otherCandidate = (InternalGeographicCandidate)otherCandidateIterator.next();
                if (otherCandidate != bestCandidate) continue;
                bGetNextOtherCandidate = false;
            }
            while (otherCandidateIterator.hasNext() && !bGetNextBestCandidate) {
                otherCandidate = (InternalGeographicCandidate)otherCandidateIterator.next();
                if (!otherCandidate.isCloseMatch()) continue;
                boolean bGetNextCandidate = false;
                for (int i = 0; i < closeMatchRules.length && !bGetNextCandidate; ++i) {
                    if (closeMatchRules[i].demoteOther(inputAddresses, (ICandidate)bestCandidate, (ICandidate)otherCandidate)) {
                        if (bDebug) {
                            MMJLog.getLog().debug("XWG_GeographicCentroidFilter::filterGeographicCloseMatches candidate demoted by rule: " + closeMatchRules[i].getClass().getSimpleName());
                            MMJLog.getLog().debug("demoted candidate: " + otherCandidate);
                            MMJLog.getLog().debug("best candidate: " + bestCandidate);
                        }
                        resort = true;
                        otherCandidate.setCloseMatchStatus(false);
                        bGetNextCandidate = true;
                        continue;
                    }
                    if (!closeMatchRules[i].demoteOther(inputAddresses, (ICandidate)otherCandidate, (ICandidate)bestCandidate)) continue;
                    if (bDebug) {
                        MMJLog.getLog().debug("XWG_GeographicCentroidFilter::filterGeographicCloseMatches candidate demoted by rule: " + closeMatchRules[i].getClass().getSimpleName());
                        MMJLog.getLog().debug("demoted candidate: " + bestCandidate);
                        MMJLog.getLog().debug("best candidate: " + otherCandidate);
                    }
                    resort = true;
                    bestCandidate.setCloseMatchStatus(false);
                    bGetNextCandidate = true;
                    bGetNextBestCandidate = true;
                }
            }
        }
        if (resort) {
            Collections.reverse(geographicCandidates);
            Collections.sort(geographicCandidates);
            Collections.reverse(geographicCandidates);
        }
        return geographicCandidates;
    }
}

