/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.parser;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.XWG.XWGUtils;
import com.mapinfo.mapmarker.XWG.parser.XWG_Standardizer;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.TaggedToken;
import com.mapinfo.mapmarker.utils.TaggedTokenList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XWG_ParsePostAddressRule
implements IParseRule {
    private short SINGLE_LINE = 1;
    private short POST_ADDRESS = (short)2;
    private static final String TAG_CITY = "CITY";
    private static final String TAG_POSTCODE2 = "POSTCODE2";
    private static final String TAG_POSTCODE = "POSTCODE";
    private static final String TAG_OTHER = "OTHER";
    private static final String TAG_COUNTRY = "COUNTRY";
    private static final String TAG_OMIT = "OMITT";
    private static final String TAG_AN1 = "AN1";
    private static final String TAG_AN2 = "AN2";
    private static final Pattern[] nonNumericPostcodePatterns;
    private static String[] nonNumericPostcodeRegexes;
    private static String[] nonNumericPostcodeAreas;
    private static Set<String> m_CountriesWithAN1Abbrevs;
    private static Set<String> m_CountriesWithAN2Abbrevs;
    private static final Pattern POSTCODE_REGEX;
    private boolean m_bNYCase;

    public void parse(Address orig, Address pa, IConstraints constraints) throws ParserException {
        String tmp;
        this.RemoveBadCharsLastLine(pa);
        String postAddress = orig.getPostAddress();
        TaggedTokenList tokens = null;
        if (pa.getCountry() == null || "XWG".equalsIgnoreCase(pa.getCountry())) {
            pa.setCountry("");
        } else {
            pa.setCountry(pa.getCountry().trim().toUpperCase());
        }
        if (postAddress != null) {
            pa.setPostAddress(null);
            postAddress = postAddress.toUpperCase();
            postAddress = postAddress.replaceAll(",", " ");
            postAddress = postAddress.replaceAll("\\.", " ");
            postAddress = postAddress.replaceAll("\\s+", " ");
            tokens = new TaggedTokenList(new StringTokenizer(postAddress, " ()-"));
        } else if (StringUtilities.isEmpty((String)pa.getAreaName1()) && StringUtilities.isEmpty((String)pa.getAreaName2()) && StringUtilities.isEmpty((String)pa.getAreaName3()) && StringUtilities.isEmpty((String)pa.getAreaName4()) && StringUtilities.isEmpty((String)pa.getPostCode1())) {
            postAddress = orig.getMainAddress();
            if (postAddress != null) {
                pa.setMainAddress(null);
                postAddress = postAddress.toUpperCase();
                postAddress = postAddress.replaceAll(",", " , ");
                tokens = new TaggedTokenList(new StringTokenizer(postAddress, " ()-"));
            } else {
                tokens = new TaggedTokenList();
            }
        } else {
            tokens = new TaggedTokenList();
        }
        if (pa.getAreaName1() != null) {
            pa.setAreaName1(pa.getAreaName1().toUpperCase());
        }
        if (pa.getAreaName3() != null) {
            pa.setAreaName3(pa.getAreaName3().toUpperCase());
        }
        this.tagCountry(pa, tokens);
        this.tagPostCode(pa, tokens);
        this.tagCity(pa, tokens);
        this.tagRemaining(pa, tokens);
        this.setCountry(orig, pa, tokens);
        this.setPostCode(orig, pa, tokens);
        this.setCity(orig, pa, tokens);
        this.setRemaining(orig, pa, tokens);
        String an = pa.getAreaName2();
        if (!StringUtilities.isEmpty((String)an)) {
            pa.setGenericField2(an.toUpperCase());
            tmp = XWG_Standardizer.standardizeAreaName(an);
            if (!StringUtilities.isEmpty((String)tmp)) {
                pa.setAreaName2(tmp);
            } else {
                pa.setAreaName2(an.trim().toUpperCase());
            }
        }
        if (!StringUtilities.isEmpty((String)(an = pa.getAreaName4()))) {
            pa.setGenericField4(an.toUpperCase());
            tmp = XWG_Standardizer.standardizeAreaName(an);
            if (!StringUtilities.isEmpty((String)tmp)) {
                pa.setAreaName4(tmp);
            } else {
                pa.setAreaName4(an.trim().toUpperCase());
            }
        }
        this.savePostCodeWithOutSpaces(pa);
    }

    protected void savePostCodeWithOutSpaces(Address pa) {
        if (StringUtilities.isEmpty((String)pa.getPostCode1()) || !pa.getPostCode1().contains(" ")) {
            return;
        }
        String newPC = pa.getPostCode1().replaceAll(" ", "");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("PC1_ORIG", pa.getPostCode1());
        map.put("PC1_NOSPACES", newPC);
        pa.setAdditionalFields(map);
    }

    protected void tagCountry(Address pa, TaggedTokenList tokens) {
        ISO3166 iso;
        TaggedToken currentToken;
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        String tagToUse = TAG_COUNTRY;
        boolean bFoundCountry = false;
        if (tokens.size() > 1 && !(currentToken = tokens.get(tokens.size() - 1)).isTagged() && currentToken.getValue().length() == 3 && (iso = ISO3166.findCountryByISO3((String)currentToken.getValue())) != null) {
            currentToken.setTag(tagToUse);
            bFoundCountry = true;
        }
        if (!bFoundCountry && !(currentToken = tokens.get(0)).isTagged() && currentToken.getValue().length() == 3 && (iso = ISO3166.findCountryByISO3((String)currentToken.getValue())) != null) {
            currentToken.setTag(tagToUse);
        }
    }

    protected void setPostCode(Address ura, Address pa, TaggedTokenList tokens) {
        String tmp = pa.getPostCode1();
        tmp = tmp != null ? tmp.trim() : tokens.getTaggedTokenString(TAG_POSTCODE).trim();
        pa.setPostCode1(tmp);
        tmp = pa.getPostCode2();
        tmp = tmp != null ? tmp.trim() : tokens.getTaggedTokenString(TAG_POSTCODE2).trim();
        pa.setPostCode2(tmp);
    }

    protected void setCountry(Address ura, Address pa, TaggedTokenList tokens) {
        String tmp = pa.getCountry();
        tmp = tmp != null ? tmp.trim() : tokens.getTaggedTokenString(TAG_COUNTRY).trim();
        String isoCntry = null;
        if (!StringUtilities.isEmpty((String)tmp)) {
            isoCntry = XWGUtils.returnCountryIso3FromString(tmp);
        } else {
            int endIdx = tokens.size() > 1 ? tokens.size() - 2 : 0;
            for (int i = 1; i <= endIdx; ++i) {
                String ctryPossible = tokens.subList(i, tokens.size()).valuesAsString();
                isoCntry = XWGUtils.returnCountryIso3FromString(ctryPossible);
                if (isoCntry == null) continue;
                for (int j = i; j < tokens.size(); ++j) {
                    tokens.get(j).setTag(TAG_COUNTRY);
                }
                break;
            }
        }
        if (isoCntry != null) {
            pa.setCountry(isoCntry);
        } else {
            pa.setCountry(tmp);
        }
        if (this.m_bNYCase && StringUtilities.isEmpty((String)pa.getCountry())) {
            pa.setCountry("USA");
        }
    }

    protected void tagRemaining(Address pa, TaggedTokenList tokens) {
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        int startPosition = tokens.indexOfFirstUntaggedToken();
        if (startPosition >= 0 && startPosition < tokens.size()) {
            TaggedToken t;
            for (int i = startPosition; i < tokens.size() && !(t = tokens.get(i)).isTagged(); ++i) {
                if (StringUtilities.hasNumeric((String)t.getValue()) || t.getValue().length() == 1) {
                    t.setTag(TAG_OMIT);
                    continue;
                }
                t.setTag(TAG_OTHER);
            }
        }
    }

    protected void setRemaining(Address ura, Address pa, TaggedTokenList tokens) {
        String other;
        boolean bAN3case = false;
        short indicator = this.singleLineOrPostAddress(ura);
        if (StringUtilities.isEmpty((String)pa.getAreaName3()) && indicator > 0) {
            other = tokens.getTaggedTokenString(TAG_OTHER);
            bAN3case = true;
        } else {
            other = pa.getAreaName1();
            if (StringUtilities.isEmpty((String)other)) {
                other = tokens.getTaggedTokenString(TAG_OTHER);
            }
        }
        String an = other.toUpperCase();
        String tmp = XWG_Standardizer.standardizeAreaName(other);
        if (!StringUtilities.isEmpty((String)tmp)) {
            if (bAN3case) {
                pa.setAreaName3(tmp);
            } else {
                pa.setAreaName1(tmp);
            }
        } else {
            if (!StringUtilities.isEmpty((String)other)) {
                other = other.toUpperCase();
            }
            if (bAN3case) {
                pa.setAreaName3(other);
            } else {
                pa.setAreaName1(other);
            }
        }
        if (bAN3case) {
            pa.setGenericField3(an);
        } else {
            pa.setGenericField1(an);
        }
    }

    protected void tagCity(Address pa, TaggedTokenList tokens) {
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        boolean bTaggedSomethingAsCity = false;
        int startPosition = tokens.indexOfFirstUntaggedToken();
        if (startPosition >= 0 && startPosition < tokens.size()) {
            for (int i = startPosition; i < tokens.size(); ++i) {
                TaggedToken t = tokens.get(i);
                boolean bl = this.m_bNYCase = "NY".equalsIgnoreCase(t.getValue()) && i >= 1 && tokens.size() > 1;
                if (t.isTagged() || this.m_bNYCase) {
                    if (this.m_bNYCase && i > 0 && tokens.get(i - 1).isTagged() && tokens.get(i - 1).getTag().equals(TAG_CITY) && tokens.get(i - 1).getValue().equals(",")) {
                        tokens.get(i - 1).setTag(TAG_AN1);
                    }
                    if (bTaggedSomethingAsCity) break;
                    continue;
                }
                if (StringUtilities.hasNumeric((String)t.getValue())) {
                    t.setTag(TAG_OMIT);
                    if (!bTaggedSomethingAsCity) continue;
                    break;
                }
                t.setTag(TAG_CITY);
                bTaggedSomethingAsCity = true;
            }
        }
    }

    protected void setCity(Address ura, Address pa, TaggedTokenList tokens) {
        String city = pa.getAreaName3();
        if (StringUtilities.isEmpty((String)city)) {
            TaggedTokenList toks;
            String tok;
            boolean hasAN1Abbrevs = m_CountriesWithAN1Abbrevs.contains(pa.getCountry());
            boolean hasAN2Abbrevs = m_CountriesWithAN2Abbrevs.contains(pa.getCountry());
            List list = tokens.getTaggedTokens(TAG_CITY);
            int cityIdx = tokens.indexOfTag(TAG_CITY);
            short indicator = this.singleLineOrPostAddress(ura);
            city = tokens.getTaggedTokenString(TAG_CITY);
            boolean bReGetCity = false;
            if (!StringUtilities.isNumeric((String)city) && indicator > 0 && tokens.getTaggedTokens(TAG_CITY).size() > 0 && !StringUtilities.isEmpty((String)pa.getPostCode1())) {
                tok = (String)list.get(list.size() - 1);
                if (!StringUtilities.isNumeric((String)tok)) {
                    StringBuilder possibleInvalidDashedInputPC = new StringBuilder(tok);
                    possibleInvalidDashedInputPC.append('-');
                    possibleInvalidDashedInputPC.append(pa.getPostCode1());
                    if (indicator == this.SINGLE_LINE && ura.getMainAddress().toUpperCase().contains(possibleInvalidDashedInputPC.toString().toUpperCase()) || indicator == this.POST_ADDRESS && ura.getPostAddress().toUpperCase().contains(possibleInvalidDashedInputPC.toString().toUpperCase())) {
                        tokens.setTag(cityIdx + (list.size() - 1), TAG_OMIT);
                        bReGetCity = true;
                    }
                }
            } else if (!bReGetCity && (hasAN1Abbrevs || hasAN2Abbrevs) && tokens.getTaggedTokens(TAG_CITY).size() > 0) {
                tok = (String)list.get(list.size() - 1);
                String ctry = pa.getCountry();
                if (list.size() > 1 && hasAN1Abbrevs && XWGUtils.containsAN1orAN2AbbrevAlt(ctry, tok)) {
                    pa.setAreaName1(tok);
                    tokens.setTag(cityIdx + (list.size() - 1), TAG_AN1);
                    bReGetCity = true;
                } else if (list.size() > 1 && hasAN2Abbrevs && XWGUtils.containsAN1orAN2AbbrevAlt(ctry, tok)) {
                    pa.setAreaName2(tok);
                    tokens.setTag(cityIdx + (list.size() - 1), TAG_AN2);
                    bReGetCity = true;
                }
            }
            if (!bReGetCity && (toks = new TaggedTokenList(new StringTokenizer(city))).size() > 1) {
                StringBuilder isoCtry = new StringBuilder();
                boolean bFoundSomething = false;
                String str = toks.get(toks.size() - 1).getValue();
                String result = XWGUtils.getAN1AltsForCustomCountry(str, isoCtry);
                ISO3166 iso = ISO3166.findCountryByISO2((String)str);
                if (str.length() == 2 && result != null) {
                    if (!isoCtry.toString().equals("BRA")) {
                        pa.setAreaName1(str);
                    } else {
                        pa.setAreaName1(result);
                    }
                    tokens.setTag(cityIdx + (list.size() - 1), TAG_AN1);
                    if (StringUtilities.isEmpty((String)pa.getCountry()) && result != null && iso == null) {
                        pa.setCountry(isoCtry.toString());
                    }
                    bReGetCity = true;
                    bFoundSomething = true;
                } else if (str.length() == 2 && result == null && iso != null && StringUtilities.isEmpty((String)pa.getCountry()) && !"ST".equals(str)) {
                    pa.setCountry(iso.getISO3Country());
                    tokens.setTag(cityIdx + (list.size() - 1), TAG_COUNTRY);
                    bReGetCity = true;
                    bFoundSomething = true;
                }
                if (!bFoundSomething) {
                    boolean start = false;
                    int endIdx = toks.size() - 1;
                    result = null;
                    String examine = null;
                    for (int i = 0; i <= endIdx; ++i) {
                        String theCountry;
                        examine = toks.subList(i, toks.size()).valuesAsString();
                        if (examine != null && i == endIdx && examine.length() == 2) {
                            examine = null;
                        }
                        StringBuilder iso3 = new StringBuilder(pa.getCountry() == null ? "" : pa.getCountry());
                        result = XWGUtils.getAN1AltsForCustomCountry(examine, iso3);
                        boolean bBRA = false;
                        if ("BRA".equals(iso3.toString())) break;
                        if (!bBRA && i == endIdx && endIdx != 0 && examine != null && examine.length() > 3 && result == null && StringUtilities.isEmpty((String)pa.getCountry()) && (theCountry = XWGUtils.returnCountryIso3FromString(examine)) != null) {
                            int end = toks.size();
                            pa.setCountry(theCountry);
                            for (int j = i; j < end; ++j) {
                                tokens.setTag(cityIdx + j, TAG_COUNTRY);
                            }
                            bReGetCity = true;
                        }
                        if (result == null) continue;
                        pa.setAreaName1(result);
                        bReGetCity = true;
                        int end = toks.size();
                        for (int j = i; j < end; ++j) {
                            tokens.setTag(cityIdx + j, TAG_AN1);
                        }
                        if (!StringUtilities.isEmpty((String)pa.getCountry()) && !tokens.getTaggedTokenString(TAG_CITY).equals("")) break;
                        if (StringUtilities.isEmpty((String)pa.getCountry())) {
                            pa.setCountry(iso3.toString());
                        }
                        if (!tokens.getTaggedTokenString(TAG_CITY).equals("")) break;
                        city = examine;
                        bReGetCity = false;
                        break;
                    }
                }
            }
            if (bReGetCity) {
                city = tokens.getTaggedTokenString(TAG_CITY);
            }
            if (StringUtilities.isEmpty((String)city) && StringUtilities.isEmpty((String)pa.getPostCode1()) && StringUtilities.isEmpty((String)ura.getAreaName1()) && !StringUtilities.isEmpty((String)pa.getAreaName1())) {
                city = pa.getAreaName1();
                pa.setAreaName1(null);
            }
        }
        pa.setGenericField3(city.toUpperCase());
        String tmp = XWG_Standardizer.standardizeAreaName(city);
        if (!StringUtilities.isEmpty((String)tmp)) {
            pa.setAreaName3(tmp);
        } else {
            if (city != null) {
                city = city.toUpperCase();
            }
            pa.setAreaName3(city);
        }
    }

    private short singleLineOrPostAddress(Address orig) {
        boolean bSingleLine;
        boolean bHasSepANInput = !StringUtilities.isEmpty((String)orig.getAreaName1()) || !StringUtilities.isEmpty((String)orig.getAreaName2()) || !StringUtilities.isEmpty((String)orig.getAreaName3()) || !StringUtilities.isEmpty((String)orig.getAreaName4());
        boolean bHasPC = !StringUtilities.isEmpty((String)orig.getPostCode1());
        boolean bHasPostAddress = !bHasSepANInput && !bHasPC && !StringUtilities.isEmpty((String)orig.getPostAddress());
        boolean bl = bSingleLine = !bHasSepANInput && !bHasPC && !bHasPostAddress && !StringUtilities.isEmpty((String)orig.getMainAddress());
        if (bSingleLine) {
            return this.SINGLE_LINE;
        }
        if (bHasPostAddress) {
            return this.POST_ADDRESS;
        }
        return 0;
    }

    static boolean isValidPostcode(String text) {
        return text != null && POSTCODE_REGEX.matcher(text.trim()).matches();
    }

    private void RemoveBadCharsLastLine(Address pa) {
        String[] LastLineParts = new String[5];
        StringBuffer[] newAddrs = new StringBuffer[5];
        LastLineParts[0] = pa.getPostAddress();
        int start = 0;
        int end = 1;
        if (LastLineParts[0] == null) {
            start = 1;
            end = 5;
            LastLineParts[1] = pa.getAreaName1();
            LastLineParts[2] = pa.getAreaName3();
            LastLineParts[3] = pa.getPostCode1();
            LastLineParts[4] = pa.getPostCode2();
        }
        for (int i = start; i < end; ++i) {
            if (LastLineParts[i] == null) continue;
            block4: for (int j = 0; j < LastLineParts[i].length(); ++j) {
                char thischar = LastLineParts[i].charAt(j);
                int ttype = Character.getType(thischar);
                switch (ttype) {
                    case 0: 
                    case 12: 
                    case 15: 
                    case 26: {
                        if (newAddrs[i] != null) {
                            newAddrs[i].append(' ');
                            continue block4;
                        }
                        newAddrs[i] = new StringBuffer();
                        newAddrs[i].append(' ');
                        continue block4;
                    }
                    default: {
                        if (newAddrs[i] == null) {
                            newAddrs[i] = new StringBuffer("");
                            newAddrs[i].append(thischar);
                            continue block4;
                        }
                        newAddrs[i].append(thischar);
                    }
                }
            }
            if (newAddrs[i] == null) continue;
            if (i == 0) {
                pa.setPostAddress(newAddrs[0].toString().trim());
                continue;
            }
            if (i == 1) {
                pa.setAreaName1(newAddrs[i].toString().trim());
                continue;
            }
            if (i == 2) {
                pa.setAreaName3(newAddrs[i].toString().trim());
                continue;
            }
            if (i == 3) {
                pa.setPostCode1(newAddrs[i].toString().trim());
                continue;
            }
            if (i != 4) continue;
            pa.setPostCode2(newAddrs[i].toString().trim());
        }
    }

    protected void tagPostCode(Address pa, TaggedTokenList tokens) {
        String full = tokens.valuesAsString();
        block0: for (Pattern pattern : nonNumericPostcodePatterns) {
            Matcher matcher = pattern.matcher(full);
            if (!matcher.find()) continue;
            String probable = matcher.group();
            boolean twoTokens = probable.indexOf(32) > 0;
            for (int idx = 0; idx < tokens.size(); ++idx) {
                TaggedToken currentToken = tokens.get(idx);
                StringBuilder sb = new StringBuilder(currentToken.getValue());
                if (twoTokens && idx < tokens.size() - 1) {
                    sb.append(' ');
                    sb.append(tokens.getValue(idx + 1));
                }
                if (!probable.equals(sb.toString())) continue;
                currentToken.setTag(TAG_POSTCODE);
                if (!twoTokens) break block0;
                tokens.get(idx + 1).setTag(TAG_POSTCODE);
                break block0;
            }
            break;
        }
    }

    static {
        nonNumericPostcodeRegexes = new String[]{"\\b[A-Z]{1,2}\\d{1,2}[ -]\\d[A-Z]{2}\\b", "\\bBBND\\s*1ZZ\\b", "\\b[A-Z]{1,2}\\d[A-Z][ -]\\d[A-Z]{2}\\b", "\\b[A-Z]\\d[A-Z][ -]\\d[A-Z]\\d\\b", "\\b[A-Z]{2}[ -]?\\d{4}\\b", "\\b\\d{5}[ -]\\d{4}", "\\b\\d{3,9}\\b", "\\b[A-Z]\\d[A-Z]\\d[A-Z]\\d\\b"};
        nonNumericPostcodeAreas = new String[]{"GBR", "GBR", "CAN", "NLD", "USA", "XWG"};
        m_CountriesWithAN1Abbrevs = new HashSet<String>();
        m_CountriesWithAN2Abbrevs = new HashSet<String>();
        m_CountriesWithAN1Abbrevs.add("AUS");
        m_CountriesWithAN1Abbrevs.add("CAN");
        m_CountriesWithAN1Abbrevs.add("MEX");
        m_CountriesWithAN1Abbrevs.add("USA");
        m_CountriesWithAN1Abbrevs.add("DEU");
        m_CountriesWithAN1Abbrevs.add("BRA");
        m_CountriesWithAN2Abbrevs.add("ITA");
        m_CountriesWithAN2Abbrevs.add("NLD");
        m_CountriesWithAN1Abbrevs = Collections.unmodifiableSet(m_CountriesWithAN1Abbrevs);
        m_CountriesWithAN2Abbrevs = Collections.unmodifiableSet(m_CountriesWithAN2Abbrevs);
        POSTCODE_REGEX = Pattern.compile("^(\\d{4,5})$");
        Pattern[] patterns = new Pattern[nonNumericPostcodeRegexes.length];
        for (int i = 0; i < nonNumericPostcodeRegexes.length; ++i) {
            patterns[i] = Pattern.compile(nonNumericPostcodeRegexes[i]);
        }
        nonNumericPostcodePatterns = patterns;
    }
}

