/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.parser;

import com.mapinfo.mapmarker.XWG.XWG_AccentHelper;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.regex.Pattern;

public class XWG_Standardizer {
    private static final Pattern[] accentPatterns;
    private static String[] accentRegexes;
    private static String[] accentReplacements;

    public static String standardizeAreaName(String input) {
        return XWG_Standardizer.standardize(input, null, null);
    }

    private static String standardize(String input, Pattern[] patterns, String[] replacements) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        String upperCase = XWG_Standardizer.toUpperCaseWithoutAccents(input);
        if (StringUtilities.isEmpty((String)upperCase)) {
            return upperCase.trim();
        }
        return upperCase.trim();
    }

    public static String toUpperCaseWithoutAccents(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        return XWG_Standardizer.replace(input.toUpperCase(), accentPatterns, accentReplacements);
    }

    private static Pattern[] preCompile(String[] regexes) {
        Pattern[] patterns = new Pattern[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            patterns[i] = Pattern.compile(regexes[i]);
        }
        return patterns;
    }

    private static String replace(String input, Pattern[] patterns, String[] replacements) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        for (int i = 0; i < patterns.length; ++i) {
            input = patterns[i].matcher(input).replaceAll(replacements[i]);
        }
        return input;
    }

    static {
        int i = 0;
        int count = XWG_AccentHelper.keySet().size();
        accentRegexes = new String[count];
        accentReplacements = new String[count];
        for (char key : XWG_AccentHelper.keySet()) {
            XWG_Standardizer.accentReplacements[i] = String.valueOf(key);
            XWG_Standardizer.accentRegexes[i] = XWG_AccentHelper.buildRegexRuleString(key);
            ++i;
        }
        accentPatterns = XWG_Standardizer.preCompile(accentRegexes);
    }
}

