/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.reverseGeocode;

import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_DataManager;
import com.mapinfo.mapmarker.XWG.reverseGeocode.XWG_AbstractReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.binary.VendorDataType;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.midev.feature.IFeature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class XWG_PostalReverseGeocodeSubHandler
extends XWG_AbstractReverseGeocodeSubHandler
implements IReverseGeocodeSubHandler {
    private static final String POSTAL_PRECISION_CODE_PREFIX = "RZ";
    public static final String POSTAL_COUNTRY = "POSTAL_COUNTRY";
    public static final String POSTCODE = "POSTCODE";
    public static final String POSTAL_ID = "POSTAL_ID";
    public static final String POSTAL_COUNTRY_DEFAULT = "country";
    public static final String POSTCODE_DEFAULT = "postcode";
    public static final String ID_DEFAULT = "featureid";
    protected static final int COUNTRY_ATT_IDX = 0;
    protected static final int POSTCODE_ATT_IDX = 1;
    protected static final int ID_ATT_IDX = 2;
    static List<String> requestedAttributes;

    @Override
    public Address populateAddressAttributes(IFeature feature, IReverseGeocodeInternalConstraints constraints) {
        AddressImpl address = new AddressImpl();
        address.setCountry(feature.getString(requestedAttributes.get(0)));
        address.setPostCode1(feature.getString(requestedAttributes.get(1)));
        address.setGenericField1(feature.getString(requestedAttributes.get(2)));
        HashMap<String, String> map = address.getAdditionalFields();
        if (map == null) {
            map = new HashMap<String, String>();
            address.setAdditionalFields(map);
        }
        map.put("VENDOR", this.getCandidateSource((Address)address));
        map.put("FROM_WORLD_FALLBACK", "true");
        return address;
    }

    public ReverseGeocodeResponse reverseGeocode(ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        String rgTabFile = XWG_DataManager.getReversePostalDictFile();
        String rgTabPath = XWG_DataManager.getReversePostalDictPath();
        if (rgTabFile == null || rgTabPath == null) {
            return new ReverseGeocodeResponse(new ArrayList());
        }
        ArrayList<File> files = new ArrayList<File>(1);
        files.add(new File(rgTabPath, rgTabFile));
        return this.findCandidates(files, requestedAttributes, location, constraints);
    }

    @Override
    public String calculatePrecisionCode(ReverseGeocodeCandidateAddress candidateAddress) {
        return POSTAL_PRECISION_CODE_PREFIX;
    }

    protected String getCandidateSource(Address candidateAddress) {
        return String.valueOf(VendorDataType.DATATYPE_TOMTOM.getDataType());
    }

    static {
        ArrayList<String> attributes = new ArrayList<String>();
        try {
            Properties properties = DataManagerSettingsProvider.getInstance().getSettingsForCountry("XWG");
            if (properties != null) {
                attributes.add(properties.getProperty(POSTAL_COUNTRY, POSTAL_COUNTRY_DEFAULT));
                attributes.add(properties.getProperty(POSTCODE, POSTCODE_DEFAULT));
                attributes.add(properties.getProperty(POSTAL_ID, ID_DEFAULT));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (attributes.size() != 3) {
            attributes.clear();
            attributes.add(POSTAL_COUNTRY_DEFAULT);
            attributes.add(POSTCODE_DEFAULT);
            attributes.add(ID_DEFAULT);
        }
        requestedAttributes = Collections.unmodifiableList(attributes);
    }
}

