/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.AddressSplit;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.TaggedToken;
import com.mapinfo.mapmarker.utils.TaggedTokenList;
import java.util.StringTokenizer;

public class XWG_AddressSplit
extends AddressSplit {
    protected TaggedTokenList tokenList;
    protected byte[] tagPattern = null;
    static final String TAG_PURE_NUMERIC = "N";
    static final String TAG_NON_NUMERIC = "O";
    static final String TAG_PART_NUMERIC = "P";

    public XWG_AddressSplit(Address split, boolean fromDelimited, boolean fromReverseSplit) {
        super(split, fromDelimited, fromReverseSplit);
        String last = split.getPostAddress();
        if (last == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(last);
        this.tokenList = new TaggedTokenList(st);
        StringBuilder sb = new StringBuilder(this.tokenList.size());
        for (int idx = 0; idx < this.tokenList.size(); ++idx) {
            TaggedToken currentToken = this.tokenList.get(idx);
            if (currentToken.isTagged()) continue;
            String currentValue = currentToken.getValue();
            String currentTag = TAG_NON_NUMERIC;
            if (StringUtilities.hasNumeric((String)currentValue)) {
                currentTag = StringUtilities.isNumeric((String)currentValue) ? TAG_PURE_NUMERIC : TAG_PART_NUMERIC;
            }
            sb.append(currentTag);
            currentToken.setTag(currentTag);
        }
        this.tagPattern = sb.toString().getBytes();
    }

    public byte[] getTagPattern() {
        return this.tagPattern;
    }

    public int countPureNumerics() {
        return this.countOccurence('N');
    }

    public int countMixedNumerics() {
        return this.countOccurence('P');
    }

    public int countOther() {
        return this.countOccurence('O');
    }

    private int countOccurence(char type) {
        if (this.tagPattern == null) {
            return 0;
        }
        int ct = 0;
        for (byte test : this.tagPattern) {
            if (test != type) continue;
            ++ct;
        }
        return ct;
    }

    public boolean equals(Object other) {
        Address mine = this.getAddress();
        Address that = ((XWG_AddressSplit)((Object)other)).getAddress();
        return StringUtilities.equalStrings((String)mine.getMainAddress(), (String)that.getMainAddress()) && StringUtilities.equalStrings((String)mine.getPostAddress(), (String)that.getPostAddress());
    }
}

