/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.AUS;

import com.mapinfo.mapmarker.addressparser.analyser.MatrixAnalyserRule;
import com.mapinfo.mapmarker.addressparser.analyser.RegexAddressMatrixAnalyser;

public class AUS_RegexAddressMatrixAnalyser
extends RegexAddressMatrixAnalyser {
    private static AUS_RegexAddressMatrixAnalyser _instance;
    private String _mainAddress = "<((?:word\\d{1,3}|unit\\d{1,3}|state\\d{1,3}|streetPrefix\\d{1,3}|street\\d{1,3}|directional\\d{1,3})+)?>";
    private String _unitType = "<(unit\\d{1,3}(?=addressNumber\\d{1,3}))?>";
    private String _addressNumber = "<((?<!unit\\d{1,3})addressNumber\\d{1,3})?>";
    private String _unitNumber = "<(addressNumber\\d{1,3}(?=addressNumber\\d))?>";
    private String _streetPrefix = "<((?:streetPrefix\\d{1,3})*)>";

    public AUS_RegexAddressMatrixAnalyser() {
        this.initRules();
    }

    public static AUS_RegexAddressMatrixAnalyser getInstance() {
        if (_instance == null) {
            _instance = new AUS_RegexAddressMatrixAnalyser();
        }
        return _instance;
    }

    private void initRules() {
        String commonAddressTokens = " directional? " + this._streetPrefix + " " + this._mainAddress + " street directional?";
        String commonAddressTokensRelaxed = " directional? " + this._streetPrefix + " " + this._mainAddress + " street? directional?";
        MatrixAnalyserRule rule = new MatrixAnalyserRule(this._unitType + " " + this._unitNumber + " " + this._addressNumber + commonAddressTokens);
        rule.putMapping(new String[]{"1"}, "UnitType");
        rule.putMapping(new String[]{"2"}, "UnitValue");
        rule.putMapping(new String[]{"3-1"}, "AddressNumber");
        rule.putMapping(new String[]{"4"}, "PreDirectional");
        rule.putMapping(new String[]{"5"}, "PreAddress");
        rule.putMapping(new String[]{"6"}, "MainAddress");
        rule.putMapping(new String[]{"7"}, "PostThoroughfareType");
        rule.putMapping(new String[]{"8"}, "PostDirectional");
        this.addMatrixAnalyserRule(rule);
        rule = new MatrixAnalyserRule(this._unitType + " " + this._unitNumber + " " + this._addressNumber + commonAddressTokensRelaxed);
        rule.putMapping(new String[]{"1"}, "UnitType");
        rule.putMapping(new String[]{"2"}, "UnitValue");
        rule.putMapping(new String[]{"3-1"}, "AddressNumber");
        rule.putMapping(new String[]{"4"}, "PreDirectional");
        rule.putMapping(new String[]{"5"}, "PreAddress");
        rule.putMapping(new String[]{"6"}, "MainAddress");
        rule.putMapping(new String[]{"7"}, "PostThoroughfareType");
        rule.putMapping(new String[]{"8"}, "PostDirectional");
        this.addMatrixAnalyserRule(rule);
        rule = new MatrixAnalyserRule("unit unitAddressNumber" + commonAddressTokens);
        rule.putMapping(new String[]{"1"}, "UnitType");
        rule.putMapping(new String[]{"2-2"}, "UnitValue");
        rule.putMapping(new String[]{"2-4"}, "AddressNumber");
        rule.setLevel(2);
        this.addMatrixAnalyserRule(rule);
        rule = new MatrixAnalyserRule("unitAddressNumber" + commonAddressTokens);
        rule.putMapping(new String[]{"1-1"}, "UnitType");
        rule.putMapping(new String[]{"1-2"}, "UnitValue");
        rule.putMapping(new String[]{"1-4"}, "AddressNumber");
        rule.setLevel(2);
        this.addMatrixAnalyserRule(rule);
    }
}

