/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.AUS;

import com.mapinfo.mapmarker.addressparser.classifier.TokenCleaner;
import com.mapinfo.mapmarker.addressparser.classifier.TokenSplitter;
import com.mapinfo.mapmarker.addressparser.patterngen.RegexPatternGenerator;
import java.util.regex.Pattern;

public class AUS_RegexPatternGenerator
extends RegexPatternGenerator {
    private static AUS_RegexPatternGenerator _instance;
    private static final String _addrNum = "((?:\\d{1,}(?:[A-Z]|[a-z])?))(?:(?:-?)((?:\\d{1,}(?:[A-Z]|[a-z])?))?)";
    private static final String _unitTypePrefix = "((?:(?:[A-Z]|[a-z]){1,4})??)";
    public static final Pattern ADDRESS_NUMBER;
    public static final Pattern UNIT_NUMBER;
    public static final Pattern UNIT_NUM_LEVEL;
    private static String _bracketMatch;
    public static final Pattern AUS_WORD;
    public static final Pattern AUS_AND_WORD;
    public static final Pattern AUS_CHAR_ONLY_WORD;
    public static final Pattern AUS_WORD_BRACKETS_LEFT;
    public static final Pattern AUS_WORD_BRACKETS_RIGHT;
    public static final Pattern AUS_CAREOF_WORD;
    public static final Pattern AUS_SLASH_WORD;
    private static final Pattern AUS_COMMA;
    private static final Pattern AUS_STREET;

    public static AUS_RegexPatternGenerator getInstance() {
        if (_instance == null) {
            _instance = new AUS_RegexPatternGenerator();
        }
        return _instance;
    }

    public AUS_RegexPatternGenerator() {
        this.addPattern("street", AUS_STREET, 1.0, this.getStreetCleaner());
        this.addPattern("comma", AUS_COMMA, 1.0);
        this.addPattern("addressNumber", ADDRESS_NUMBER, 1.0, new TokenCleaner("addressNumberCleaner"), this.getAddressNumberSplitter());
        this.addPattern("unitAddressNumber", UNIT_NUMBER, 1.0, this.getUnitAddressNumberSplitter());
        this.addPattern("unitNumber", UNIT_NUM_LEVEL, 0.5, this.getUnitNumberTokenCleaner(UNIT_NUM_LEVEL.pattern(), "$2"));
        this.addPattern("word", AUS_WORD, 0.5, new TokenCleaner("wordCleaner"));
        this.addPattern("word", AUS_WORD_BRACKETS_LEFT, 0.5, this.getWordBracketCleaner(AUS_WORD_BRACKETS_LEFT.pattern(), "$2"));
        this.addPattern("word", AUS_WORD_BRACKETS_RIGHT, 0.5, this.getWordBracketCleaner(AUS_WORD_BRACKETS_LEFT.pattern(), "$1"));
        this.addPattern("word", AUS_AND_WORD, 0.5, this.getAusAndWord(AUS_AND_WORD.pattern(), "and"));
        this.addPattern("word", AUS_CHAR_ONLY_WORD, 0.5, this.getAusAndWord(AUS_CHAR_ONLY_WORD.pattern(), ""));
        this.addPattern("word", AUS_CAREOF_WORD, 0.5, this.getBlankCleaner(AUS_CAREOF_WORD.pattern()));
        this.addPattern("word", AUS_SLASH_WORD, 0.5, this.getSlashWordCleaner());
    }

    private TokenCleaner getStreetCleaner() {
        TokenCleaner tokenCleaner = new TokenCleaner("street-cleaner");
        tokenCleaner.addCleaningRule(AUS_STREET.pattern(), "ST");
        return tokenCleaner;
    }

    private TokenSplitter getAddressNumberSplitter() {
        TokenSplitter tokenSplitter = new TokenSplitter("addrNumSplitter");
        tokenSplitter.setRule(ADDRESS_NUMBER.pattern(), "$1 $2");
        return tokenSplitter;
    }

    private TokenSplitter getUnitAddressNumberSplitter() {
        TokenSplitter tokenSplitter = new TokenSplitter("unitAddressNumSplitter");
        tokenSplitter.setRule(UNIT_NUMBER.pattern(), "$1 $2 $3 $4 $5");
        return tokenSplitter;
    }

    public TokenCleaner getSlashWordCleaner() {
        TokenCleaner tokenCleaner = new TokenCleaner("slashwordCleaner");
        tokenCleaner.addCleaningRule(AUS_SLASH_WORD.pattern(), "$3");
        return tokenCleaner;
    }

    public TokenCleaner getBlankCleaner(String pattern) {
        TokenCleaner tokenCleaner = new TokenCleaner("blankCleaner");
        tokenCleaner.addCleaningRule(pattern, "");
        return tokenCleaner;
    }

    public TokenCleaner getWordBracketCleaner(String pattern, String replaceRegex) {
        TokenCleaner tokenCleaner = new TokenCleaner("wordBracketCleaner");
        tokenCleaner.addCleaningRule(pattern, replaceRegex);
        return tokenCleaner;
    }

    public TokenCleaner getAddressNumberCleaner() {
        TokenCleaner tokenCleaner = new TokenCleaner("addressNumberCleaner2");
        tokenCleaner.addCleaningRule(UNIT_NUMBER.pattern(), "$2");
        return tokenCleaner;
    }

    public TokenCleaner getAusAndWord(String pattern, String replaceRegex) {
        TokenCleaner tokenCleaner = new TokenCleaner("charCleaner");
        tokenCleaner.addCleaningRule(pattern, replaceRegex);
        return tokenCleaner;
    }

    public TokenCleaner getUnitNumberTokenCleaner(String pattern, String replaceRegex) {
        TokenCleaner tokenCleaner = new TokenCleaner("unitNumberCleaner");
        tokenCleaner.addCleaningRule(pattern, replaceRegex);
        return tokenCleaner;
    }

    static {
        ADDRESS_NUMBER = Pattern.compile(_addrNum);
        UNIT_NUMBER = Pattern.compile("((?:(?:[A-Z]|[a-z]){1,4})??)((?:\\d{1,}(?:[A-Z]|[a-z])?))(?:(?:-?)((?:\\d{1,}(?:[A-Z]|[a-z])?))?)/((?:\\d{1,}(?:[A-Z]|[a-z])?))(?:(?:-?)((?:\\d{1,}(?:[A-Z]|[a-z])?))?)");
        UNIT_NUM_LEVEL = Pattern.compile("([L|l])" + UNIT_NUMBER.pattern());
        _bracketMatch = "((?:\\(+|\\)+|\\{+|\\}+|\"|'+)+)";
        AUS_WORD = Pattern.compile("((?:[a-z]|[A-Z])*(?:(?:_|-|')??(?:[a-z]|[A-Z]|[0-9])+)+)");
        AUS_AND_WORD = Pattern.compile("&+");
        AUS_CHAR_ONLY_WORD = Pattern.compile("(-+|/+)");
        AUS_WORD_BRACKETS_LEFT = Pattern.compile(_bracketMatch + AUS_WORD.pattern());
        AUS_WORD_BRACKETS_RIGHT = Pattern.compile(AUS_WORD.pattern() + _bracketMatch);
        AUS_CAREOF_WORD = Pattern.compile("(?:[C|c]/-)");
        AUS_SLASH_WORD = Pattern.compile(AUS_WORD.pattern() + "(/|\\\\)" + AUS_WORD.pattern());
        AUS_COMMA = Pattern.compile(",");
        AUS_STREET = Pattern.compile("St.|ST.|st.|sT.");
    }
}

