/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser;

import com.mapinfo.mapmarker.addressparser.analyser.MatrixAnalyserException;
import com.mapinfo.mapmarker.addressparser.analyser.RegexAddressMatrixAnalyser;
import com.mapinfo.mapmarker.addressparser.tokenparser.AddressToken;
import com.mapinfo.mapmarker.common.Address;
import java.util.ArrayList;

public class AddressMatrix {
    private ArrayList _addressTokens = new ArrayList();
    private Address _originalAddress;
    private Address _parsedAddress;
    private boolean _hasBeenParsed;
    private String[] _matchStrings;
    private int _matchedPattern;

    public AddressMatrix(Address address) {
        this._originalAddress = address;
        this._hasBeenParsed = false;
        this._matchStrings = new String[0];
        this._matchedPattern = -1;
    }

    public int size() {
        return this._addressTokens.size();
    }

    public boolean addAddressToken(AddressToken token) {
        return this._addressTokens.add(token);
    }

    public String getMatchString(boolean includeTokenPositions) {
        if (this == null || this.size() == 0) {
            return null;
        }
        return this.buildMatchStringFromMatrix(includeTokenPositions);
    }

    public Address analyseMatrix(RegexAddressMatrixAnalyser analyser) {
        if (analyser == null) {
            return this._parsedAddress;
        }
        try {
            this._parsedAddress = analyser.analyse(this);
            this._hasBeenParsed = true;
        }
        catch (MatrixAnalyserException e) {
            this._parsedAddress = null;
            this._hasBeenParsed = false;
        }
        return this._parsedAddress;
    }

    public AddressToken getAddressToken(int index) throws IndexOutOfBoundsException {
        return (AddressToken)this._addressTokens.get(index);
    }

    public double getScore() {
        return 1.0;
    }

    public Address getAddress() {
        return this._originalAddress;
    }

    public Address getParsedAddress() {
        return this._parsedAddress;
    }

    public boolean hasBeenParsed() {
        return this._hasBeenParsed;
    }

    public String[] getMatchStringList() {
        return this._matchStrings;
    }

    public void setMatchStringList(String[] matchStrings) {
        this._matchStrings = matchStrings;
    }

    private String buildMatchStringFromMatrix(boolean includeTokenPositions) {
        StringBuffer resultMatchString = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            AddressToken addressToken = this.getAddressToken(i);
            resultMatchString.append(addressToken.getClassifier().getType());
            if (includeTokenPositions) {
                resultMatchString.append(addressToken.getPosition());
                continue;
            }
            resultMatchString.append(" ");
        }
        return resultMatchString.toString().trim();
    }

    public int getMatchedPattern() {
        return this._matchedPattern;
    }

    public void setMatchedPattern(int matchedPattern) {
        this._matchedPattern = matchedPattern;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Address Tokens: " + this._addressTokens + "\n");
        sb.append("Original Address: " + this._originalAddress + "\n");
        sb.append("Parsed Address: " + this._parsedAddress + "\n");
        sb.append("HasBeenParsed: " + this._hasBeenParsed + "\n");
        sb.append("MatchedPattern: " + this._matchedPattern + "\n");
        return sb.toString();
    }
}

