/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.analyser;

import com.mapinfo.mapmarker.addressparser.AbstractAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class MatrixAnalyserRule {
    public static final String PATTERN_MULTI_PART_TOKEN = "(\\d+)(?:-(\\d+))?";
    private String _rule;
    private int _ruleLevel = 1;
    private Map _fieldMap = new HashMap();

    public MatrixAnalyserRule() {
        this._rule = null;
    }

    public MatrixAnalyserRule(String rule) {
        this._rule = rule;
    }

    public boolean isValid() {
        return this.getRule() != null && this.getFieldMapSize() > 0;
    }

    public void setRule(String rule) {
        this._rule = rule;
    }

    public String getRule() {
        return this._rule;
    }

    public void setLevel(int level) {
        this._ruleLevel = level;
    }

    public int getLevel() {
        return this._ruleLevel;
    }

    public int getFieldMapSize() {
        return this._fieldMap.size();
    }

    public Map getFieldMap() {
        return this._fieldMap;
    }

    public boolean putMapping(String[] regexGroupsArray, String addressField) {
        if (this.isValidMapping(regexGroupsArray, addressField)) {
            this._fieldMap.put(addressField, regexGroupsArray);
            return true;
        }
        return false;
    }

    private boolean isValidMapping(String[] regexGroupsArray, String addressField) {
        if (regexGroupsArray == null) {
            return false;
        }
        int ruleTokenCount = new StringTokenizer(this._rule).countTokens();
        for (int i = 0; i < regexGroupsArray.length; ++i) {
            String mapping = regexGroupsArray[i];
            String isProperFormat = mapping.replaceAll(PATTERN_MULTI_PART_TOKEN, "MATCH");
            if (!"MATCH".equals(isProperFormat)) continue;
            int regexGroupNumber = new Integer(mapping.replaceAll(PATTERN_MULTI_PART_TOKEN, "$1"));
            if (regexGroupNumber > ruleTokenCount) {
                return false;
            }
            if (regexGroupNumber < 1) {
                return false;
            }
            return AbstractAddress.isValidField(addressField);
        }
        return false;
    }

    public static int getGroupMapping(String str) {
        return MatrixAnalyserRule.getGroupInt(str, "$1");
    }

    public static int getGroupPartMapping(String str) {
        return MatrixAnalyserRule.getGroupInt(str, "$2");
    }

    private static int getGroupInt(String str, String regexGroup) {
        int intValue;
        if (str == null) {
            return -1;
        }
        String replacedString = str.replaceAll(PATTERN_MULTI_PART_TOKEN, regexGroup);
        if (replacedString.length() == 0) {
            return -1;
        }
        try {
            intValue = new Integer(replacedString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return intValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Rule: " + this._rule + "\n");
        sb.append("Rule Level: " + this._ruleLevel + "\n");
        sb.append("Rule Mappings: " + this._fieldMap + "\n");
        return sb.toString();
    }
}

