/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.classifier;

import com.mapinfo.mapmarker.addressparser.classifier.TokenCleaner;
import com.mapinfo.mapmarker.addressparser.classifier.TokenSplitter;

public class TokenClassifier
implements Comparable {
    private String _type;
    private double _priority;
    private TokenCleaner _cleaner;
    private TokenSplitter _splitter;
    private String _tokenAbbreviation;
    private String _tokenFullname;

    public TokenClassifier(String type) {
        this.setType(type.trim());
        this.setPriority(1.0);
        this._cleaner = new TokenCleaner(type);
        this._splitter = new TokenSplitter(type);
        this._tokenAbbreviation = "";
    }

    public String getTokenAbbreviation() {
        return this._tokenAbbreviation;
    }

    public void setTokenAbbreviation(String tokenAbbreviation) {
        this._tokenAbbreviation = tokenAbbreviation;
    }

    public String getTokenFullname() {
        return this._tokenFullname;
    }

    public void setTokenFullname(String tokenFullname) {
        this._tokenFullname = tokenFullname;
    }

    public TokenCleaner getCleaner() {
        return this._cleaner;
    }

    public void setCleaner(TokenCleaner cleaner) {
        this._cleaner = cleaner;
    }

    public TokenSplitter getSplitter() {
        return this._splitter;
    }

    public void setSplitter(TokenSplitter splitter) {
        this._splitter = splitter;
    }

    public double getPriority() {
        return this._priority;
    }

    public void setPriority(double priority) {
        this._priority = priority;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TokenClassifier)) {
            return false;
        }
        return this.getType().equals(((TokenClassifier)obj).getType());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Classifier Type: " + this._type + "\n");
        sb.append("Priority: " + this._priority + "\n");
        sb.append("Token Cleaner: " + this._cleaner + "\n");
        sb.append("Token Splitter: " + this._splitter + "\n");
        sb.append("Abbreviation: " + this._tokenAbbreviation + "\n");
        return sb.toString();
    }

    public int compareTo(Object o) {
        if (!(o instanceof TokenClassifier)) {
            throw new ClassCastException();
        }
        return new Double(this.getPriority()).compareTo(new Double(((TokenClassifier)o).getPriority()));
    }
}

