/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.classifier;

import com.mapinfo.mapmarker.addressparser.classifier.TokenClassifier;
import com.mapinfo.mapmarker.addressparser.keywords.KeywordStore;
import com.mapinfo.mapmarker.addressparser.keywords.KeywordStoreCollection;
import com.mapinfo.mapmarker.addressparser.keywords.KeywordType;
import com.mapinfo.mapmarker.addressparser.patterngen.RegexPatternGenerator;
import java.util.ArrayList;
import java.util.Collections;

public class TokenClassifierEngine {
    RegexPatternGenerator _regexPatternGenerator;
    KeywordStoreCollection _keywordStoreCollection;

    public TokenClassifierEngine(RegexPatternGenerator regexPatternGenerator, KeywordStoreCollection keywordStoreFactory) {
        this._regexPatternGenerator = regexPatternGenerator;
        this._keywordStoreCollection = keywordStoreFactory;
    }

    public TokenClassifier[] classify(String token) {
        if (this._regexPatternGenerator == null && this._keywordStoreCollection == null) {
            return null;
        }
        ArrayList resultList = new ArrayList();
        if (this._keywordStoreCollection != null) {
            resultList.addAll(this.searchKeywordStoresForToken(token));
        }
        if (this._regexPatternGenerator != null) {
            resultList.addAll(this.searchRegexPatternGenerator(token));
        }
        Collections.sort(resultList);
        Collections.reverse(resultList);
        return resultList.toArray(new TokenClassifier[0]);
    }

    public RegexPatternGenerator getRegexPatternGenerator() {
        return this._regexPatternGenerator;
    }

    public KeywordStoreCollection getKeywordStoreFactory() {
        return this._keywordStoreCollection;
    }

    private ArrayList searchRegexPatternGenerator(String token) {
        int[] matchedExpressions = this._regexPatternGenerator.match(token);
        ArrayList resultList = new ArrayList();
        if (matchedExpressions == null) {
            return resultList;
        }
        this.buildResultListFromMatchedExpressions(matchedExpressions, resultList);
        return resultList;
    }

    private void buildResultListFromMatchedExpressions(int[] matchedExpressions, ArrayList resultList) {
        for (int i = 0; i < matchedExpressions.length; ++i) {
            int patternIndex = matchedExpressions[i];
            String patternDescription = this._regexPatternGenerator.getPatternDescription(patternIndex);
            TokenClassifier classifier = new TokenClassifier(patternDescription);
            classifier.setPriority(this._regexPatternGenerator.getPatternPriority(patternIndex));
            classifier.setCleaner(this._regexPatternGenerator.getTokenCleaner(patternIndex));
            classifier.setSplitter(this._regexPatternGenerator.getTokenSplitter(patternIndex));
            resultList.add(classifier);
        }
    }

    private ArrayList searchKeywordStoresForToken(String token) {
        ArrayList<TokenClassifier> resultList = new ArrayList<TokenClassifier>();
        KeywordStore[] stores = this._keywordStoreCollection.getKeywordStores();
        for (int i = 0; i < stores.length; ++i) {
            KeywordType type = stores[i].getKeyword(token);
            if (type == null) continue;
            TokenClassifier classifier = new TokenClassifier(stores[i].getId());
            classifier.setPriority(stores[i].getPriority());
            classifier.setCleaner(stores[i].getCleaner());
            classifier.setTokenAbbreviation(type.getAbbreviation());
            classifier.setTokenFullname(type.getTypeDescription());
            classifier.setSplitter(stores[i].getSplitter());
            resultList.add(classifier);
        }
        return resultList;
    }
}

