/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.classifier;

import java.util.ArrayList;
import java.util.List;

public class TokenCleaner {
    private final String _id;
    private final List _ruleList = new ArrayList();
    private boolean _cleanWithAbbreviation = false;
    private boolean _cleanWithFullName = false;

    public TokenCleaner(String id) {
        this._id = id;
        this._cleanWithAbbreviation = false;
    }

    public boolean isCleanWithAbbreviation() {
        return this._cleanWithAbbreviation;
    }

    public void setCleanWithAbbreviation(boolean cleanWithAbbreviation) {
        this._cleanWithAbbreviation = cleanWithAbbreviation;
    }

    public boolean isCleanWithFullName() {
        return this._cleanWithFullName;
    }

    public void setCleanWithFullName(boolean cleanWithFullName) {
        this._cleanWithFullName = cleanWithFullName;
    }

    public String getId() {
        return this._id;
    }

    public boolean addCleaningRule(String regexExpression, String replacement) {
        return this._ruleList.add(new CleaningRule(regexExpression, replacement));
    }

    public int getNumberOfRules() {
        return this._ruleList.size();
    }

    public String clean(String token) {
        for (int i = 0; i < this.getNumberOfRules(); ++i) {
            CleaningRule rule = (CleaningRule)this._ruleList.get(i);
            token = token.replaceAll(rule._regexExpression, rule._replacement);
        }
        return token;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CleanerId: " + this._id + "\n");
        sb.append("CleanWithAbbreviation: " + this._cleanWithAbbreviation + "\n");
        sb.append("Rule List: " + this._ruleList + "\n");
        return sb.toString();
    }

    private class CleaningRule {
        String _regexExpression;
        String _replacement;

        public CleaningRule(String regexExpression, String replacement) {
            this._regexExpression = regexExpression;
            this._replacement = replacement;
        }
    }
}

