/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.tokenparser;

import com.mapinfo.mapmarker.APAC.utils.APAC_StringUtilities;
import com.mapinfo.mapmarker.addressparser.AddressMatrix;
import com.mapinfo.mapmarker.addressparser.classifier.TokenClassifier;
import com.mapinfo.mapmarker.addressparser.classifier.TokenClassifierEngine;
import com.mapinfo.mapmarker.addressparser.tokenparser.AddressToken;
import com.mapinfo.mapmarker.common.Address;

public class AddressTokenParser {
    TokenClassifierEngine _classifierEngine;

    public AddressTokenParser(TokenClassifierEngine engine) {
        this._classifierEngine = engine;
    }

    public AddressMatrix buildAddressMatrix(Address address, String addressString, boolean tokeniseString) {
        AddressMatrix addressMatrix = new AddressMatrix(address);
        if (APAC_StringUtilities.isEmpty(addressString)) {
            return addressMatrix;
        }
        if (!tokeniseString) {
            this.addAddressToken(addressMatrix, 1, addressString);
        } else {
            String[] splitString = APAC_StringUtilities.split(addressString, ", ", ",");
            for (int tokenPosition = 0; tokenPosition < splitString.length; ++tokenPosition) {
                this.addAddressToken(addressMatrix, tokenPosition, splitString[tokenPosition].trim());
            }
        }
        return addressMatrix;
    }

    protected void addAddressToken(AddressMatrix addressMatrix, int i, String token) {
        AddressToken addressToken = this.parseToken(token);
        addressToken.setPosition(i);
        addressMatrix.addAddressToken(addressToken);
    }

    public AddressToken parseToken(String string) {
        AddressToken addressToken = new AddressToken();
        addressToken.setToken(string);
        TokenClassifier[] classifiers = this._classifierEngine.classify(string);
        if (classifiers.length >= 1) {
            addressToken.setClassifier(classifiers[0]);
            addressToken.setTokenParts(classifiers[0].getSplitter().split(string));
            for (int i = 1; i < classifiers.length; ++i) {
                addressToken.addAdditionalClassifier(classifiers[i]);
            }
        } else {
            addressToken.setClassifier(new TokenClassifier("UNKNOWN_TOKEN"));
        }
        return addressToken;
    }
}

