/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardPost2SacRecord;
import com.mapinfo.mapmarker.core.parser.IParser;
import java.util.ArrayList;
import java.util.Properties;

public class UDStreetDataSourceRecordConvertor
extends StreetDataSourceRecordConvertorImpl {
    private IUDNonStreetDataHandler m_post2SacHandler;
    private IUDNonStreetDataHandler m_geo2SacHandler;

    public UDStreetDataSourceRecordConvertor(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints, IUDNonStreetDataHandler post2SacHandler, IUDNonStreetDataHandler geo2SacHandler) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
        this.m_post2SacHandler = post2SacHandler;
        this.m_geo2SacHandler = geo2SacHandler;
    }

    protected void addRecordToSet(MMJPost2SacRecord record) {
        this.m_post2SacHandler.addRecord(record);
    }

    protected void addRecordToSet(MMJGeo2SacRecord record) {
        this.m_geo2SacHandler.addRecord(record);
    }

    protected MMJPost2SacRecord makePost2SacDataRecordType(int sac, IPostalBase base) {
        return new StandardPost2SacRecord(sac, base);
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType(int sac, IGeoBase base) {
        return new StandardGeo2SacRecord(sac, base);
    }

    protected int getPost2Sac(IPostalBase base) {
        int sac = super.getPost2Sac(base);
        this.addRecordToSet(this.makePost2SacDataRecordType(sac, base));
        return sac;
    }

    protected int[] getGeo2Sac(IGeoBase base) {
        int[] sacs = super.getGeo2Sac(base);
        for (int i = 0; i < sacs.length; ++i) {
            this.addRecordToSet(this.makeGeo2SacDataRecordType(sacs[i], base));
        }
        return sacs;
    }

    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        if (inputData != null) {
            IStreetDataSourceRecord input = (IStreetDataSourceRecord)inputData;
            try {
                ISegmentDataSourceRecord segment = input.getSegment();
                if (segment == null) {
                    return null;
                }
                ArrayList pointList = segment.getPoints();
                if (pointList == null || pointList.size() == 0) {
                    return null;
                }
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(101, (Throwable)DSEx);
            }
        }
        return super.convert(inputData);
    }
}

