/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.AbstractDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.UDDataCreationException;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public abstract class AbstractUDDataProvider
extends AbstractDataProvider {
    public static final String INTERMEDIATE_STREET_FILE_NAME = "street.tmp";
    public static final String DATA_SET_PATH = "dataSetPath";
    public static final String STREET_OUTPUT_FILE_PATH = "street_outputFilePath";
    public static final String SUPPORTS_REVERSEGEOCODING = "supports_reversegeocoding";

    protected AbstractUDDataProvider() {
        this.setForUserDictioary(true);
    }

    public MMJComplexDataFileMetadata getGeoInfoMetadata() throws DataCreationException {
        return null;
    }

    public MMJComplexDataFileMetadata getPostInfoMetadata() throws DataCreationException {
        return null;
    }

    public void preProcessStreetDataSet() throws DataCreationException {
        super.preProcessStreetDataSet();
        this.createOtherFiles();
    }

    protected void createOtherFiles() throws DataCreationException {
        this.createPost2Sac();
        this.createGeo2Sac();
        this.createAlt();
    }

    protected void copyOtherFiles() throws DataCreationException {
        try {
            this.copySupportingFiles(this.m_processProperties.getProperty(DATA_SET_PATH) + File.separator + "geoinfo.jdx", this.m_processProperties.getProperty(STREET_OUTPUT_FILE_PATH) + File.separator + "geoinfo.jdx");
        }
        catch (IOException e) {
            throw new DataCreationException(400, (Throwable)e);
        }
        try {
            this.copySupportingFiles(this.m_processProperties.getProperty(DATA_SET_PATH) + File.separator + "geo2sac.mmj", this.m_processProperties.getProperty(STREET_OUTPUT_FILE_PATH) + File.separator + "geo2sac.mmj");
        }
        catch (IOException e) {
            throw new DataCreationException(400, (Throwable)e);
        }
        try {
            this.copySupportingFiles(this.m_processProperties.getProperty(DATA_SET_PATH) + File.separator + "geoinfo.jdr", this.m_processProperties.getProperty(STREET_OUTPUT_FILE_PATH) + File.separator + "geoinfo.jdr");
        }
        catch (IOException e) {
            throw new DataCreationException(300, (Throwable)e);
        }
        try {
            this.copySupportingFiles(this.m_processProperties.getProperty(DATA_SET_PATH) + File.separator + "geoinfo.sdx", this.m_processProperties.getProperty(STREET_OUTPUT_FILE_PATH) + File.separator + "geoinfo.sdx");
        }
        catch (IOException e) {
            throw new DataCreationException(401, (Throwable)e);
        }
        try {
            this.copySupportingFiles(this.m_processProperties.getProperty(DATA_SET_PATH) + File.separator + "postinfo.jdx", this.m_processProperties.getProperty(STREET_OUTPUT_FILE_PATH) + File.separator + "postinfo.jdx");
        }
        catch (IOException e) {
            throw new DataCreationException(401, (Throwable)e);
        }
        try {
            this.copySupportingFiles(this.m_processProperties.getProperty(DATA_SET_PATH) + File.separator + "postinfo.jdr", this.m_processProperties.getProperty(STREET_OUTPUT_FILE_PATH) + File.separator + "postinfo.jdr");
        }
        catch (IOException e) {
            throw new DataCreationException(401, (Throwable)e);
        }
        try {
            this.copySupportingFiles(this.m_processProperties.getProperty(DATA_SET_PATH) + File.separator + "post2sac.mmj", this.m_processProperties.getProperty(STREET_OUTPUT_FILE_PATH) + File.separator + "post2sac.mmj");
        }
        catch (IOException e) {
            throw new DataCreationException(400, (Throwable)e);
        }
        this.createAlt();
    }

    protected void createPost2Sac() throws DataCreationException {
        this.processPost2Sac(false);
    }

    protected void createGeo2Sac() throws DataCreationException {
        this.processGeo2Sac(false);
    }

    protected void createAlt() throws DataCreationException {
        this.copyAltFile();
    }

    private void copyAltFile() throws DataCreationException {
        File sourceAltFile = new File(StringUtilities.appendToPath((String)this.m_processProperties.getProperty(DATA_SET_PATH), (String)"alt.mmj"));
        if (sourceAltFile.exists()) {
            File destAltFile = new File(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"alt.mmj"));
            FileInputStream inputStream = null;
            FileChannel sourceChannel = null;
            FileOutputStream outputStream = null;
            FileChannel destChannel = null;
            try {
                inputStream = new FileInputStream(sourceAltFile);
                sourceChannel = inputStream.getChannel();
                outputStream = new FileOutputStream(destAltFile);
                destChannel = outputStream.getChannel();
                destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
            }
            catch (IOException e) {
                DataCreationLogger.getLogger().logInternalError("IOException: AbstractUDDataProvider:: copyAltFile(): ");
                DataCreationLogger.getLogger().logError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataCreationException(105, (Throwable)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (sourceChannel != null) {
                        sourceChannel.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (destChannel != null) {
                        destChannel.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logStatus("alt.mmj not found in address dictionary.  Alternate index type file copy not required.");
        }
    }

    protected void deleteFile(String fileToDelete) throws DataCreationException {
        if (DebugLevel.getDebugLevel((int)5) == 0) {
            if (fileToDelete == null) {
                return;
            }
            File fileRef = new File(fileToDelete);
            if (fileRef.exists()) {
                if (!fileRef.delete()) {
                    DataCreationLogger.getLogger().logInternalError("AbstractUDDataProvider:: deleteFile(): ");
                    DataCreationLogger.getLogger().logError("Unable to delete file: " + fileToDelete);
                    throw new DataCreationException(-1);
                }
            } else {
                DataCreationLogger.getLogger().logStatus("Tried to delete " + fileToDelete + " but it did not exist.");
            }
        } else {
            DataCreationLogger.getLogger().logStatus("Did not delete " + fileToDelete + " due to current DebugLevel.");
        }
    }

    protected void cleanUpTempFiles() throws DataCreationException {
        if (DebugLevel.getDebugLevel((int)5) == 0) {
            try {
                this.deleteFiles(this.getTempFileNames());
            }
            catch (DataCreationException e) {
                throw new UDDataCreationException(1902);
            }
        }
    }

    protected void cleanUpFinalFiles() throws DataCreationException {
        if (DebugLevel.getDebugLevel((int)5) == 0) {
            this.deleteFiles(this.getFinalFileNames());
        }
    }

    protected List getTempFileNames() {
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)INTERMEDIATE_STREET_FILE_NAME));
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)this.getStreetFileBaseName(), (String)".tdx"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)this.getStreetFileBaseName(), (String)".tbx"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getPostInfoFilePath(), (String)this.getPostInfoFileBaseName(), (String)".tzx"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getPostInfoFilePath(), (String)this.getPostInfoFileBaseName(), (String)".tdx"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)this.getStreetFileBaseName(), (String)".sts"));
        return fileNameList;
    }

    protected List getFinalFileNames() {
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)this.getStreetFileBaseName(), (String)".bdx"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)this.getStreetFileBaseName(), (String)".jdr"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)this.getStreetFileBaseName(), (String)".jdx"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"sac2fn_ud.mmj"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getPostInfoFilePath(), (String)this.getPostInfoFileBaseName(), (String)".jdr"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getPostInfoFilePath(), (String)this.getPostInfoFileBaseName(), (String)".jdx"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getPost2SacFilePath(), (String)"post2sac.mmj"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getGeo2SacFilePath(), (String)"geo2sac.mmj"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"alt.mmj"));
        fileNameList.add(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"dictionarydesc.txt"));
        return fileNameList;
    }

    public void checkForExistingFiles() throws DataCreationException {
        List fileNamesList = this.getFinalFileNames();
        fileNamesList.addAll(this.getTempFileNames());
        if (this.anyFilesExist(fileNamesList)) {
            UDDataCreationException ex = new UDDataCreationException(1905);
            DataCreationLogger.getLogger().logError(ex.getMessage());
            throw ex;
        }
    }

    private boolean anyFilesExist(List fileNamesList) {
        if (fileNamesList != null) {
            Iterator fileNamesIterator = fileNamesList.iterator();
            while (fileNamesIterator.hasNext()) {
                File file = new File((String)fileNamesIterator.next());
                if (!file.exists()) continue;
                return true;
            }
        }
        return false;
    }

    private void deleteFiles(List fileNames) throws DataCreationException {
        if (fileNames == null) {
            return;
        }
        for (String fileName : fileNames) {
            if (fileName == null) continue;
            this.deleteFile(fileName);
        }
    }

    private void copySupportingFiles(String source, String destination) throws FileNotFoundException, IOException {
        FileUtils.copyFile((File)new File(source), (File)new File(destination));
    }

    public boolean supportsReverseGeocode() {
        String value;
        Boolean supportReverseGeocode = false;
        if (this.m_processProperties != null && "true".equalsIgnoreCase(value = this.m_processProperties.getProperty(SUPPORTS_REVERSEGEOCODING, "false").toString())) {
            supportReverseGeocode = true;
        }
        return supportReverseGeocode;
    }
}

