/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.UserCancelledRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataCreator;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import java.util.Date;
import java.util.Properties;

public class UDDataCreator
extends DataCreator {
    public UDDataCreator() {
        super(false);
        this.m_dataProviderBaseClass = "_TabUDDataProvider";
    }

    public void runProcess(Properties processingProperties) throws DataCreationException {
        try {
            this.setUpLogger(processingProperties);
            DataCreationLogger.getLogger().logStatus("Start: " + new Date().toString());
            this.initializeDataProvider(processingProperties);
            if (this.m_dataProvider == null) {
                throw new DataCreationException(-1, "data provider not initialized");
            }
            ((AbstractUDDataProvider)this.m_dataProvider).checkForExistingFiles();
            this.createDataFiles(processingProperties);
            this.createIndexFiles(processingProperties);
        }
        catch (DataCreationException e) {
            this.cleanUpFinalFiles();
            DataCreationLogger.getLogger().logInternalError("DataCreationException: UDDataCreator:: runProcess(): ");
            DataCreationLogger.getLogger().logError(((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw e;
        }
        catch (UserCancelledRuntimeException UCREx) {
            this.cleanUpFinalFiles();
            throw UCREx;
        }
        catch (RuntimeException e) {
            this.cleanUpFinalFiles();
            DataCreationLogger.getLogger().logInternalError("RuntimeException: UDDataCreator:: runProcess(): ");
            DataCreationLogger.getLogger().logError(e.getClass().getSimpleName() + " : " + e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(-1, (Throwable)e);
        }
        catch (Error e) {
            this.cleanUpFinalFiles();
            DataCreationLogger.getLogger().logInternalError("Error: UDDataCreator:: runProcess(): ");
            DataCreationLogger.getLogger().logError(e.getClass().getSimpleName() + " : " + e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(-1, (Throwable)e);
        }
        finally {
            this.cleanUpTempFiles();
            DataCreationLogger.getLogger().logStatus("End:   " + new Date().toString());
        }
    }

    protected void cleanUpTempFiles() throws DataCreationException {
        if (this.m_dataProvider != null) {
            ((AbstractUDDataProvider)this.m_dataProvider).cleanUpTempFiles();
        }
    }

    protected void cleanUpFinalFiles() throws DataCreationException {
        if (this.m_dataProvider != null) {
            ((AbstractUDDataProvider)this.m_dataProvider).cleanUpFinalFiles();
        }
    }

    protected void initializeDataProvider(Properties processingProperties) throws DataCreationException {
        IDataProvider provider;
        Class<?> providerClass;
        String providerClassName = "com.mapinfo.mapmarker." + processingProperties.getProperty("COUNTRY") + ".dp.ud.tab." + processingProperties.getProperty("COUNTRY") + this.m_dataProviderBaseClass;
        try {
            providerClass = Class.forName(providerClassName);
        }
        catch (ClassNotFoundException e) {
            DataCreationLogger.getLogger().logInternalError("ClassNotFoundException: UDDataCreator:: getDataProvider(): ");
            DataCreationLogger.getLogger().logError("Unable to create data tools for country: " + processingProperties.getProperty("COUNTRY") + "  Please check classpath.");
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(2, (Throwable)e);
        }
        try {
            provider = (IDataProvider)providerClass.newInstance();
        }
        catch (InstantiationException e) {
            DataCreationLogger.getLogger().logInternalError("InstantiationException: UDDataCreator:: getDataProvider(): ");
            DataCreationLogger.getLogger().logError("Unable to create needed classes for country: " + processingProperties);
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(2, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            DataCreationLogger.getLogger().logInternalError("IllegalAccessException: UDDataCreator:: getDataProvider(): ");
            DataCreationLogger.getLogger().logError("Unable to create needed classes for country: " + processingProperties);
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(2, (Throwable)e);
        }
        this.m_dataProvider = provider;
        this.m_dataProvider.initialize(processingProperties);
    }
}

