/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud;

import com.mapinfo.mapmarker.common.dp.gui.ud.UDBuildData;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDColumnDefinition;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDInheritedProperty;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDRequiredOneOfDefinition;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDRequiredSetDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

class UDBuildDataParser {
    private static final String NS = null;
    private static final String ROOT_BUILD_ELEMENT = "UDBuildData";
    private static final String UD_ADDITIONAL_FIELDS_ATTRIBUTE = "AdditionalFields";
    private static final String COUNTRY_CODE_ELEMENT = "CountryCode";
    private static final String UD_COLUMN_DEFINITION_ELEMENT = "UDColumnDefinition";
    private static final String REQUIRED_ATTRIBUTE = "Required";
    private static final String CONDITIONAL_ATTRIBUTE = "Conditional";
    private static final String UD_KEY_ELEMENT = "UDKey";
    private static final String UD_TEXT_ELEMENT = "UDText";
    private static final String UD_INHERITED_PROPERTY_ELEMENT = "UDInheritedProperty";
    private static final String NEW_KEY_ELEMENT = "NewUDKey";
    private static final String FROM_KEY_ELEMENT = "FromUDKey";
    private static final String UD_REQUIRED_ONE_OF_DEFINITION_ELEMENT = "UDRequiredOneOfDefinition";
    private static final String UD_REQUIRED_SET_DEFINITION_ELEMENT = "UDRequiredSetDefinition";
    private static final String ALSO_REQUIRED_KEY_ELEMENT = "AlsoRequiredUDKey";
    private static final String ONE_OF_KEY_ELEMENT = "OneOfUDKey";
    private static final String UD_OPTIONS_ELEMENT = "Options";
    private static String UD_NO_ADDRESS_DICTIONARY_PROMPT_ELEMENT = "NoAddressDictionaryPrompt";
    private static final String ONE_OF_DESCRIPTION = "OneOfDescription";
    private static final String SET_DESCRIPTION = "SetDescription";

    UDBuildDataParser() {
    }

    public static UDBuildData parseUDBuildData(InputStream xmlStream) {
        UDBuildData result = null;
        if (xmlStream == null) {
            return new UDBuildData();
        }
        try {
            SAXBuilder builder = new SAXBuilder(null, false);
            Document doc = builder.build(xmlStream);
            result = UDBuildDataParser.parseDoc(doc);
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (result == null) {
            return new UDBuildData();
        }
        return result;
    }

    private static UDBuildData parseDoc(Document doc) {
        UDBuildData result = new UDBuildData();
        Element root = doc.getRootElement();
        if (!root.getName().equals(ROOT_BUILD_ELEMENT)) {
            throw new IllegalStateException();
        }
        String addField = root.getAttributeValue(UD_ADDITIONAL_FIELDS_ATTRIBUTE);
        boolean bAllowAddFlds = addField != null && addField.equals("true");
        result.setAllowAdditionalFields(bAllowAddFlds);
        Element optionsElement = root.getChild(UD_OPTIONS_ELEMENT);
        UDBuildDataParser.processOptions(result, optionsElement);
        List colElements = root.getChildren(UD_COLUMN_DEFINITION_ELEMENT);
        for (int i = 0; i < colElements.size(); ++i) {
            Element colElement = (Element)colElements.get(i);
            result.getUDColumnDefinitions().add(UDBuildDataParser.parseColumnElement(colElement));
        }
        List inheritedPropertyElements = root.getChildren(UD_INHERITED_PROPERTY_ELEMENT);
        for (int i = 0; i < inheritedPropertyElements.size(); ++i) {
            Element inheritedPropertyElement = (Element)inheritedPropertyElements.get(i);
            result.getInheritedProperties().add(UDBuildDataParser.parseInheritedPropertyElement(inheritedPropertyElement));
        }
        List oneOfDefinitionElements = root.getChildren(UD_REQUIRED_ONE_OF_DEFINITION_ELEMENT);
        for (int i = 0; i < oneOfDefinitionElements.size(); ++i) {
            Element oneOfDefinitionElement = (Element)oneOfDefinitionElements.get(i);
            result.getRequiredOneOfDefinitions().add(UDBuildDataParser.parseOneOfDefinitionElement(oneOfDefinitionElement));
        }
        List setDefinitionElements = root.getChildren(UD_REQUIRED_SET_DEFINITION_ELEMENT);
        for (int i = 0; i < setDefinitionElements.size(); ++i) {
            Element setDefinitionElement = (Element)setDefinitionElements.get(i);
            result.getRequiredSetDefinitions().add(UDBuildDataParser.parseSetDefinitionElement(setDefinitionElement));
        }
        return result;
    }

    private static void processOptions(UDBuildData result, Element optionsElement) {
        if (optionsElement == null) {
            return;
        }
        Element noPromptElement = optionsElement.getChild(UD_NO_ADDRESS_DICTIONARY_PROMPT_ELEMENT);
        result.setPromptForAddressDictionary(noPromptElement == null);
    }

    private static UDInheritedProperty parseInheritedPropertyElement(Element inheritedPropertyElement) {
        String newKey = inheritedPropertyElement.getChild(NEW_KEY_ELEMENT).getChild(UD_KEY_ELEMENT).getTextTrim();
        String fromKey = inheritedPropertyElement.getChild(FROM_KEY_ELEMENT).getChild(UD_KEY_ELEMENT).getTextTrim();
        return new UDInheritedProperty(newKey, fromKey);
    }

    private static UDColumnDefinition parseColumnElement(Element colElement) {
        String requiredStr = colElement.getAttributeValue(REQUIRED_ATTRIBUTE);
        boolean required = requiredStr != null && requiredStr.equals("true");
        boolean conditional = false;
        if (required) {
            String condStr = colElement.getAttributeValue(CONDITIONAL_ATTRIBUTE);
            conditional = condStr != null && condStr.equals("true");
        }
        String key = colElement.getChild(UD_KEY_ELEMENT).getTextTrim();
        String text = colElement.getChild(UD_TEXT_ELEMENT).getTextTrim();
        return new UDColumnDefinition(required, conditional, key, text);
    }

    private static UDRequiredOneOfDefinition parseOneOfDefinitionElement(Element parseOneOfDefinitionElement) {
        String key = parseOneOfDefinitionElement.getChild(UD_KEY_ELEMENT).getTextTrim();
        List oneOfKeyElements = parseOneOfDefinitionElement.getChildren(ONE_OF_KEY_ELEMENT);
        UDRequiredOneOfDefinition result = null;
        for (int i = 0; i < oneOfKeyElements.size(); ++i) {
            Element oneOfElement = (Element)oneOfKeyElements.get(i);
            String oneOf = oneOfElement.getTextTrim();
            if (result == null) {
                result = new UDRequiredOneOfDefinition(key, oneOf);
                continue;
            }
            result.addOneOfProperty(oneOf);
        }
        String desc = parseOneOfDefinitionElement.getChild(ONE_OF_DESCRIPTION).getTextTrim();
        result.setDescription(desc);
        return result;
    }

    private static UDRequiredSetDefinition parseSetDefinitionElement(Element parseSetDefinitionElement) {
        String key = parseSetDefinitionElement.getChild(UD_KEY_ELEMENT).getTextTrim();
        List alsoKeyElements = parseSetDefinitionElement.getChildren(ALSO_REQUIRED_KEY_ELEMENT);
        UDRequiredSetDefinition result = null;
        for (int i = 0; i < alsoKeyElements.size(); ++i) {
            Element alsoElement = (Element)alsoKeyElements.get(i);
            String also = alsoElement.getTextTrim();
            if (result == null) {
                result = new UDRequiredSetDefinition(key, also);
                continue;
            }
            result.addAlsoRequiredProperty(also);
        }
        String desc = parseSetDefinitionElement.getChild(SET_DESCRIPTION).getTextTrim();
        result.setDescription(desc);
        return result;
    }
}

