/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud;

import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDBuildData;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDBuildDataParser;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDGUIController;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.midev.data.IDataSourceTable;
import com.mapinfo.midev.data.ITableMetadata;
import com.mapinfo.midev.dp.tab.NativeDataProvider;
import com.mapinfo.midev.feature.IAttributeDefinition;
import com.mapinfo.midev.feature.util.AttributeDefinitionCollection;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class UDBuildHelper {
    private static final String EMPTY_STRING = "";
    private Map m_udBuildDataMap = new HashMap();

    public List availableCountries() {
        ISO3166[] countries = GeocodableAddressFactory.getVersionDescriptor().getSupportedCountries();
        ArrayList<String> result = new ArrayList<String>(countries.length);
        for (int i = 0; i < countries.length; ++i) {
            String country = countries[i].getISO3Country();
            if (this.findUDFile(country, country + "_UDBuildData.xml") == null) continue;
            result.add(country);
        }
        return result;
    }

    public String getDatasetPath(String countryCode) {
        try {
            Properties dp = DataManagerSettingsProvider.getSettingsFileProperties((String)countryCode);
            int numDict = Integer.parseInt(dp.getProperty("DICTIONARY_COUNT"));
            for (int i = 1; i <= numDict; ++i) {
                String addressDictionary = dp.getProperty("DICTIONARY_PATH" + i);
                if (!this.isValidAddressDictionary(addressDictionary, countryCode)) continue;
                return addressDictionary;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return EMPTY_STRING;
    }

    public boolean isValidAddressDictionary(String path, String countryCode) {
        if (path == null || path.length() == 0) {
            return false;
        }
        File addressDictionary = new File(path);
        if (!addressDictionary.exists()) {
            return false;
        }
        File[] sac2fnFiles = addressDictionary.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isDirectory() && name.indexOf("sac2fn") >= 0 && name.indexOf(".mmj") >= 0 && name.indexOf("_ud") < 0;
            }
        });
        if (sac2fnFiles.length == 0) {
            return false;
        }
        File[] jdrFiles = addressDictionary.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.toLowerCase().endsWith(".jdr");
            }
        });
        for (int i = 0; i < jdrFiles.length; ++i) {
            File jdrFile = jdrFiles[i];
            if (!countryCode.equalsIgnoreCase(this.countryFromJdrFile(jdrFile))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String countryFromJdrFile(File jdrFile) {
        String countryCode = EMPTY_STRING;
        MMJDataFileMetadata dfm = new MMJDataFileMetadata();
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(jdrFile)));
            dfm.read((DataInput)((Object)dis));
            countryCode = dfm.getCountry();
        }
        catch (FileNotFoundException e) {
            String string = EMPTY_STRING;
            return string;
        }
        catch (IOException e) {
            String string = EMPTY_STRING;
            return string;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return countryCode;
    }

    public List getColumnsToMap(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        return this.getUDBuildData(countryCode, locale, udType).getUDColumnDefinitions();
    }

    public boolean isAllowAdditionalFields(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        return this.getUDBuildData(countryCode, locale, udType).allowAdditionalFields();
    }

    public boolean shouldPromptForAddressDictionary(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        return this.getUDBuildData(countryCode, locale, udType).shouldPromptForAddressDictionary();
    }

    private UDBuildData readUDBuildData(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        URL udBuildDataURL = this.findUDBuildData(countryCode, locale, udType);
        UDBuildData result = null;
        try {
            if (udBuildDataURL != null) {
                result = UDBuildDataParser.parseUDBuildData(udBuildDataURL.openStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            result = new UDBuildData();
        }
        return result;
    }

    public List getInheritedUDProperties(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        return this.getUDBuildData(countryCode, locale, udType).getInheritedProperties();
    }

    public List getUDRequiredOneOfDefinitions(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        return this.getUDBuildData(countryCode, locale, udType).getRequiredOneOfDefinitions();
    }

    public List getUDRequiredSetDefinitions(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        return this.getUDBuildData(countryCode, locale, udType).getRequiredSetDefinitions();
    }

    public boolean isValidOutputUD(String outputUD) {
        if (outputUD == null) {
            return false;
        }
        File parentDir = new File(outputUD).getParentFile();
        if (parentDir == null) {
            return false;
        }
        String[] files = parentDir.list();
        return files != null && files.length <= 0;
    }

    public EnumSet determinePermittedDictionaryTypes(String countryCode, Locale locale) {
        boolean hash = false;
        EnumSet<UDGUIController.USER_DICT_TYPE> enums = EnumSet.noneOf(UDGUIController.USER_DICT_TYPE.class);
        URL url = this.findUDBuildData(countryCode, locale, UDGUIController.USER_DICT_TYPE.RANGE_BASED);
        if (url != null) {
            enums.add(UDGUIController.USER_DICT_TYPE.RANGE_BASED);
        }
        if ((url = this.findUDBuildData(countryCode, locale, UDGUIController.USER_DICT_TYPE.POINT_BASED)) != null) {
            enums.add(UDGUIController.USER_DICT_TYPE.POINT_BASED);
        }
        return enums;
    }

    private UDBuildData getUDBuildData(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        String udReqKey = countryCode + locale.getLanguage() + locale.getCountry() + (Object)((Object)udType);
        UDBuildData data = (UDBuildData)this.m_udBuildDataMap.get(udReqKey);
        if (data == null) {
            data = this.readUDBuildData(countryCode, locale, udType);
            this.m_udBuildDataMap.put(udReqKey, data);
        }
        return data;
    }

    private URL findUDBuildData(String countryCode, Locale locale, UDGUIController.USER_DICT_TYPE udType) {
        URL result;
        String baseFileName = "_UDBuildData";
        if (udType == UDGUIController.USER_DICT_TYPE.POINT_BASED) {
            baseFileName = "_UDPointBuildData";
        }
        if ((result = this.findUDFile(countryCode, countryCode + baseFileName + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".xml")) == null) {
            result = this.findUDFile(countryCode, countryCode + baseFileName + "_" + locale.getLanguage() + ".xml");
        }
        if (result == null) {
            result = this.findUDFile(countryCode, countryCode + baseFileName + ".xml");
        }
        if (result == null && udType == UDGUIController.USER_DICT_TYPE.POINT_BASED) {
            result = this.findUDFile(countryCode, "XXX" + baseFileName + ".xml");
        }
        return result;
    }

    private URL findUDFile(String countryCode, String name) {
        URL result = this.getClass().getResource("/com/mapinfo/mapmarker/" + countryCode + "/dp/ud/" + name);
        if (result == null) {
            result = this.getClass().getResource("/" + name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableColumnNames(File table) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        IDataSourceTable t = null;
        try {
            NativeDataProvider dp = NativeDataProvider.getInstance();
            if (table != null && table.getParent() != null && table.getName() != null && table.exists()) {
                t = dp.openTable(new File(table.getParent(), table.getName()));
            }
            if (t != null) {
                ITableMetadata md = t.getMetadata();
                AttributeDefinitionCollection attributeDefinitions = md.getAttributeDefinitions();
                for (IAttributeDefinition col : attributeDefinitions) {
                    result.add(col.getName());
                }
            }
        }
        finally {
            if (t != null && !t.isClosed()) {
                t.close();
            }
        }
        return result;
    }
}

