/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud;

import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDGUI;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDGUIController;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDGUIStringKeys;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.VersionDescriptor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UDButtonPnl
extends JPanel {
    private static final String RESOURCE_BUNDLE_NAME = "com.mapinfo.mapmarker.common.dp.gui.ud.UDGUI";
    private JButton m_backBtn;
    private JButton m_nextBtn;
    private JButton m_cancelBtn;
    private JButton m_sysInfoBtn;
    private ResourceBundle m_resourceBundle;
    private final UDGUI m_udgui;
    private UDGUIController m_controller;
    private final Locale m_locale;

    public UDButtonPnl(Locale locale, UDGUI udgui, UDGUIController controller) {
        this.m_locale = locale;
        this.m_udgui = udgui;
        this.m_controller = controller;
        this.m_resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale);
        this.initComponents();
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(Box.createHorizontalGlue());
        this.add(this.m_backBtn);
        this.add(this.m_nextBtn);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.m_cancelBtn);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.m_sysInfoBtn);
    }

    private void initComponents() {
        String backBtnKey = this.m_controller.getButtonLabelKey(0);
        this.m_backBtn = new JButton(this.m_resourceBundle.getString(backBtnKey));
        this.m_backBtn.addActionListener(new BackListener());
        this.setMnemonic(this.m_backBtn, backBtnKey);
        this.m_backBtn.setEnabled(this.m_controller.isButtonEnabled(0));
        String nextBtnKey = this.m_controller.getButtonLabelKey(1);
        this.m_nextBtn = new JButton(this.m_resourceBundle.getString(nextBtnKey));
        this.m_nextBtn.addActionListener(new NextListener());
        this.setMnemonic(this.m_nextBtn, "next");
        this.m_nextBtn.setEnabled(this.m_controller.isButtonEnabled(1));
        this.m_cancelBtn = new JButton(this.m_resourceBundle.getString("cancel"));
        this.m_cancelBtn.addActionListener(new CancelListener());
        this.setMnemonic(this.m_cancelBtn, "cancel");
        this.m_sysInfoBtn = new JButton(this.m_resourceBundle.getString("systemInformation"));
        this.m_sysInfoBtn.addActionListener(new SysInfoListener());
        this.setMnemonic(this.m_sysInfoBtn, "systemInformation");
    }

    private void setMnemonic(JButton btn, String key) {
        try {
            btn.setMnemonic(this.m_resourceBundle.getString(UDGUIStringKeys.getMnemonicKey(key)).charAt(0));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void updateButtons() {
        String backBtnKey = this.m_controller.getButtonLabelKey(0);
        this.m_backBtn.setText(this.m_resourceBundle.getString(backBtnKey));
        this.setMnemonic(this.m_backBtn, backBtnKey);
        this.m_backBtn.setEnabled(this.m_controller.isButtonEnabled(0));
        String nextBtnKey = this.m_controller.getButtonLabelKey(1);
        this.m_nextBtn.setText(this.m_resourceBundle.getString(nextBtnKey));
        this.setMnemonic(this.m_nextBtn, nextBtnKey);
        this.m_nextBtn.setEnabled(this.m_controller.isButtonEnabled(1));
        String cancelBtnKey = this.m_controller.getButtonLabelKey(2);
        this.m_cancelBtn.setText(this.m_resourceBundle.getString(cancelBtnKey));
        this.setMnemonic(this.m_cancelBtn, cancelBtnKey);
        this.m_cancelBtn.setEnabled(this.m_controller.isButtonEnabled(2));
    }

    private class SysInfoListener
    implements ActionListener {
        private SysInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String lf = System.getProperty("line.separator");
            String SPACING = "   ";
            StringBuffer sb = new StringBuffer();
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("title"));
            sb.append(lf);
            sb.append(lf);
            VersionDescriptor vd = GeocodableAddressFactory.getVersionDescriptor();
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationMMJCore"));
            sb.append(" ");
            sb.append(vd.getCoreVersion());
            sb.append(lf);
            sb.append(lf);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationMMJPlugins"));
            sb.append(lf);
            ISO3166[] countries = vd.getSupportedCountries();
            for (int i = 0; i < countries.length; ++i) {
                ISO3166 country = countries[i];
                sb.append(SPACING);
                sb.append(country.getDisplayCountry(UDButtonPnl.this.m_locale));
                sb.append(" (");
                sb.append(country.getISO3Country());
                sb.append("): ");
                sb.append(vd.getVersion(country));
                sb.append(lf);
            }
            sb.append(lf);
            sb.append(lf);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationEnvDetails"));
            sb.append(lf);
            sb.append(SPACING);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationOSName"));
            sb.append(" ");
            sb.append(System.getProperty("os.name"));
            sb.append(lf);
            sb.append(SPACING);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationOSVersion"));
            sb.append(" ");
            sb.append(System.getProperty("os.version"));
            sb.append(lf);
            sb.append(SPACING);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationOSArch"));
            sb.append(" ");
            sb.append(System.getProperty("os.arch"));
            sb.append(lf);
            sb.append(lf);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationJVMDetails"));
            sb.append(lf);
            sb.append(SPACING);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationJavaHome"));
            sb.append(" ");
            sb.append(System.getProperty("java.home"));
            sb.append(lf);
            sb.append(SPACING);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationJavaVer"));
            sb.append(" ");
            sb.append(System.getProperty("java.version"));
            sb.append(lf);
            sb.append(SPACING);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationJavaVendor"));
            sb.append(" ");
            sb.append(System.getProperty("java.vendor"));
            sb.append(lf);
            sb.append(SPACING);
            sb.append(UDButtonPnl.this.m_resourceBundle.getString("systemInformationClasspath"));
            sb.append(" ");
            sb.append(System.getProperty("java.class.path"));
            JTextArea textArea = new JTextArea(sb.toString());
            textArea.setEditable(false);
            JScrollPane component = new JScrollPane(textArea);
            component.setPreferredSize(new Dimension(320, 240));
            JOptionPane.showMessageDialog(UDButtonPnl.this.getTopLevelAncestor(), component, UDButtonPnl.this.m_resourceBundle.getString("systemInformationTitle"), -1);
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container top = UDButtonPnl.this.getTopLevelAncestor();
            if (top instanceof Window) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                EventQueue evtQ = tk.getSystemEventQueue();
                evtQ.postEvent(new WindowEvent((Window)top, 201));
            }
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UDButtonPnl.this.m_controller.back();
            UDButtonPnl.this.updateButtons();
            UDButtonPnl.this.m_udgui.updateWizardPanel();
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UDButtonPnl.this.m_controller.next();
            UDButtonPnl.this.m_udgui.updateWizardPanel();
            UDButtonPnl.this.updateButtons();
        }
    }
}

