/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud;

import com.mapinfo.mapmarker.common.dp.IProgressBarUpdater;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBounds;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBoundsProvider;
import com.mapinfo.mapmarker.common.dp.ProgressBarUpdaterProvider;
import com.mapinfo.mapmarker.common.dp.UserCancelledRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.UDDataCreator;
import com.mapinfo.mapmarker.common.dp.gui.ud.RequiredColumnHelper;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDBuildHelper;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDColumnDefinition;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDInheritedProperty;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDRequiredOneOfDefinition;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDRequiredSetDefinition;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.IMultipleThreadProgressUpdator;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.MultipleDataCreationManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

class UDGUIController {
    public static final int BUTTON_KEY_BACK = 0;
    public static final int BUTTON_KEY_NEXT = 1;
    public static final int BUTTON_KEY_CANCEL = 2;
    public static final int PANEL_KEY_INPUT_TABLE = 0;
    public static final int PANEL_KEY_REQUIRED_COLUMNS = 1;
    public static final int PANEL_KEY_OPTIONAL_COLUMNS = 2;
    public static final int PANEL_KEY_OUTPUT_FILE = 3;
    public static final int PANEL_KEY_PROGRESS = 4;
    public static final int PANEL_KEY_COMPLETE = 5;
    public static final int PANEL_KEY_COUNTRY = 6;
    public static final int PANEL_KEY_DICT_TYPE = 7;
    public static final int PANEL_KEY_ADDRESS_DICT = 8;
    public static final int PANEL_KEY_CONDITIONAL_COLUMNS = 9;
    public static final int PANEL_KEY_CUSTOM_COLUMNS = 10;
    public static final int PANEL_KEY_CUSTOM_UNIT_COLUMNS = 11;
    public static final int USER_MSG_KEY_NONE = -1;
    public static final int USER_MSG_KEY_NEED_COUNTRY = 0;
    public static final int USER_MSG_KEY_NEED_ADDRESS_DICTIONARY = 1;
    public static final int USER_MSG_KEY_NEED_INPUT_TABLE = 2;
    public static final int USER_MSG_KEY_NEED_EMPTY_OUTPUT_DIR = 3;
    public static final int USER_MSG_KEY_REQUIRED_COLUMN_NOT_DEFINED = 4;
    public static final int USER_MSG_KEY_MISSING_ONE_OF_REQUIRED_COLUMNS = 5;
    public static final int USER_MSG_KEY_MISSING_ELEMENT_REQUIRED_COLUMN_SET = 6;
    private USER_DICT_TYPE m_udDataType = USER_DICT_TYPE.RANGE_BASED;
    private EnumSet m_permittedUserDictionaryTypes = EnumSet.noneOf(USER_DICT_TYPE.class);
    private boolean m_allowAdditionalFields = false;
    private static final String EMPTY_STRING = "";
    private static final String SAC2FN = "sac2fn.mmj";
    private static final String GEOINFO_BASE_NAME = "geoinfo";
    private static final String POSTINFO_BASE_NAME = "postinfo";
    private static final String USE_CONSOLE = "useConsole";
    private static final String LOG_FILES = "logFiles";
    private static final String ZERO = "0";
    private static final String ERR_EXT = ".err";
    private static final String ERROR_LOG = "errorLog";
    private static final String STATUS_LOG = "statusLog";
    private static final String LOG_EXT = ".log";
    private static final String UD_DESCRIPTION = "outputDatasetDescription";
    private final Locale m_locale;
    private final UDBuildHelper m_buildHelper;
    private final UDDataCreator m_dataCreator;
    private final RequiredColumnHelper m_requiredColumnHelper;
    private ControllerProgressBarUpdater m_internalProgressUpdater;
    private Properties m_properties = new Properties();
    private List m_UDColumnDefs = Collections.EMPTY_LIST;
    private List m_tableColumns = Collections.EMPTY_LIST;
    private List m_UDOneOfDefs = Collections.EMPTY_LIST;
    private List m_UDSetDefs = Collections.EMPTY_LIST;
    private List<String> m_mappedUDKeys = new ArrayList<String>();
    private int m_currentPanel = 3;
    private int m_progress;
    private Set m_availableCountries;
    private static final Set<String> unitMappings;

    public UDGUIController(Locale locale, Properties properties, UDBuildHelper buildHelper, UDDataCreator dataCreator, IProgressBarUpdater progressUpdater) {
        this.m_locale = locale;
        this.m_buildHelper = buildHelper;
        this.m_dataCreator = dataCreator;
        this.m_internalProgressUpdater = new ControllerProgressBarUpdater(progressUpdater);
        this.m_availableCountries = new HashSet(this.m_buildHelper.availableCountries());
        this.m_requiredColumnHelper = new RequiredColumnHelper();
        if (properties != null) {
            this.loadProperties(properties);
        }
        this.setDefaultProperties();
    }

    private void loadProperties(Properties properties) {
        String countryCode = this.getCountryCode(properties);
        if (countryCode != null && countryCode.length() == 3 && this.m_availableCountries.contains(countryCode)) {
            this.setCountryCode(countryCode);
            this.setAddressDictionary(this.getAddressDictionary(properties));
            this.setInputTable(this.getInputTable(properties));
            for (int i = 0; i < this.m_UDColumnDefs.size(); ++i) {
                UDColumnDefinition def = (UDColumnDefinition)this.m_UDColumnDefs.get(i);
                String initValue = properties.getProperty(def.getPropertyKey());
                if (initValue == null || !this.m_tableColumns.contains(initValue)) continue;
                this.setColumnMap(def.getPropertyKey(), initValue);
            }
            this.setOutputFile(this.getOutputFile(properties));
            String description = this.getUDDescription(properties);
            if (description != null) {
                this.setUDDescription(description);
            }
        }
    }

    private void setDefaultProperties() {
        this.m_properties.setProperty(USE_CONSOLE, "NO");
        this.m_properties.setProperty("geo2sac_create", "NO");
        this.m_properties.setProperty("post2sac_create", "NO");
        this.m_properties.setProperty("postInfo_create", "NO");
        this.m_properties.setProperty("geoInfo_create", "NO");
        this.m_properties.setProperty(LOG_FILES, "NO");
        this.m_properties.setProperty("street_create", "YES");
        this.m_properties.setProperty("postInfo_outputFile", POSTINFO_BASE_NAME);
        this.m_properties.setProperty("geoInfo_outputFile", GEOINFO_BASE_NAME);
        this.m_properties.setProperty("startRow", ZERO);
        this.m_properties.setProperty("endRow", ZERO);
    }

    public void setCountryCode(String countryCode) {
        String prevCountry = this.getCountryCode();
        this.m_properties.setProperty("COUNTRY", countryCode);
        this.m_permittedUserDictionaryTypes = this.m_buildHelper.determinePermittedDictionaryTypes(countryCode, this.m_locale);
        this.m_udDataType = this.m_permittedUserDictionaryTypes.contains((Object)USER_DICT_TYPE.RANGE_BASED) ? USER_DICT_TYPE.RANGE_BASED : USER_DICT_TYPE.POINT_BASED;
        this.populateColumnDefList();
        this.populateAddressDictionary();
        if (countryCode != null && !countryCode.equals(prevCountry)) {
            this.clearPreviousColumnMappings();
        }
    }

    private void clearPreviousColumnMappings() {
        for (int i = 0; i < this.m_mappedUDKeys.size(); ++i) {
            String key = this.m_mappedUDKeys.get(i);
            this.m_properties.remove(key);
        }
        this.m_mappedUDKeys.clear();
    }

    public String getCountryCode() {
        return this.getCountryCode(this.m_properties);
    }

    public void setUserDictionaryDataType(USER_DICT_TYPE udType) {
        if (udType == this.m_udDataType) {
            return;
        }
        this.m_udDataType = udType;
        this.populateTableColumns();
        this.populateColumnDefList();
    }

    public USER_DICT_TYPE getUserDictionaryDataType() {
        return this.m_udDataType;
    }

    private String getCountryCode(Properties props) {
        String result = props.getProperty("COUNTRY");
        return result == null ? EMPTY_STRING : result;
    }

    private boolean isFinalPanel() {
        if (this.m_allowAdditionalFields) {
            return this.m_currentPanel == 11 || this.m_currentPanel == 10 && !this.hasMappedUnits();
        }
        return this.m_currentPanel == 2 || !this.hasOptionalColumns() && this.m_currentPanel == 1;
    }

    public Properties buildProperties() {
        Properties buildProperties = (Properties)this.m_properties.clone();
        if (this.m_udDataType == USER_DICT_TYPE.POINT_BASED) {
            buildProperties.setProperty("pointAddressRanges", "TRUE");
        } else {
            buildProperties.remove("pointAddressRanges");
        }
        List inhProps = this.m_buildHelper.getInheritedUDProperties(this.getCountryCode(), this.m_locale, this.m_udDataType);
        for (int i = 0; i < inhProps.size(); ++i) {
            UDInheritedProperty inheritedProperty = (UDInheritedProperty)inhProps.get(i);
            String value = buildProperties.getProperty(inheritedProperty.getCopyValueFromProperty());
            if (value == null) {
                value = "NONE";
            }
            buildProperties.setProperty(inheritedProperty.getNewProperty(), value);
        }
        return buildProperties;
    }

    public List getUDColumnDefinitions() {
        return this.m_UDColumnDefs;
    }

    public int getCurrentPanel() {
        return this.m_currentPanel;
    }

    public String getAddressDictionary() {
        return this.getAddressDictionary(this.m_properties);
    }

    private String getAddressDictionary(Properties props) {
        String addressDictionaryDir = props.getProperty("dataSetPath");
        return addressDictionaryDir == null ? EMPTY_STRING : addressDictionaryDir;
    }

    public void setAddressDictionary(String sac2fnPath) {
        if (sac2fnPath == null || sac2fnPath.length() == 0) {
            this.m_properties.remove("dataSetPath");
        } else {
            this.m_properties.setProperty("dataSetPath", sac2fnPath);
        }
    }

    public boolean isButtonEnabled(int buttonKey) {
        switch (buttonKey) {
            case 0: {
                return this.m_currentPanel >= 0 && this.m_currentPanel != 3 && this.m_currentPanel != 4 && this.m_currentPanel != 5;
            }
            case 1: {
                switch (this.m_currentPanel) {
                    case 0: {
                        return this.inputPanelInformationSpecified();
                    }
                    case 9: {
                        return this.conditionallyRequiredColumnsNotMapped() == 0;
                    }
                    case 1: {
                        return this.requiredColumnsNotMapped() == 0;
                    }
                    case 2: {
                        return this.requiredSetColumnsNotMapped() == 0;
                    }
                    case 6: {
                        return this.m_UDColumnDefs.size() != 0;
                    }
                    case 7: {
                        return true;
                    }
                    case 8: {
                        return this.addrDictPanelInformationSpecified();
                    }
                    case 3: {
                        return this.outputFileSpecified();
                    }
                    case 10: {
                        return true;
                    }
                    case 11: {
                        return true;
                    }
                    case 4: {
                        return false;
                    }
                    case 5: {
                        return false;
                    }
                }
                throw new IllegalStateException();
            }
            case 2: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    private int requiredColumnsNotMapped() {
        HashSet columns = new HashSet(this.getTableColumns());
        List defs = this.getUDColumnDefinitions();
        return this.m_requiredColumnHelper.requiredColumnsNotMapped(columns, defs, this.m_properties, this.m_UDOneOfDefs, this.m_UDSetDefs);
    }

    private int conditionallyRequiredColumnsNotMapped() {
        HashSet columns = new HashSet(this.getTableColumns());
        List defs = this.getUDColumnDefinitions();
        return this.m_requiredColumnHelper.conditionallyRequiredColumnsNotMapped(columns, defs, this.m_properties, this.m_UDOneOfDefs, this.m_UDSetDefs);
    }

    private int requiredSetColumnsNotMapped() {
        HashSet columns = new HashSet(this.getTableColumns());
        List defs = this.getUDColumnDefinitions();
        return this.m_requiredColumnHelper.requiredSetColumnsNotMapped(columns, defs, this.m_properties, this.m_UDSetDefs);
    }

    public String returnUnmappedRequiredColumnDescription() {
        return this.m_requiredColumnHelper.returnUnmappedRequiredColumnDescription();
    }

    public String getButtonLabelKey(int buttonKey) {
        switch (buttonKey) {
            case 0: {
                return "back";
            }
            case 1: {
                if (this.isFinalPanel()) {
                    return "finish";
                }
                return "next";
            }
            case 2: {
                return this.m_currentPanel == 5 ? "exit" : "cancel";
            }
        }
        throw new IllegalArgumentException();
    }

    public void next() {
        if (!this.isButtonEnabled(1)) {
            throw new IllegalStateException();
        }
        if (this.isFinalPanel()) {
            this.runUDCreation();
        }
        switch (this.m_currentPanel) {
            case 3: {
                this.m_currentPanel = 6;
                break;
            }
            case 6: {
                if (this.m_buildHelper.shouldPromptForAddressDictionary(this.getCountryCode(), this.m_locale, this.m_udDataType)) {
                    this.m_currentPanel = 8;
                    break;
                }
            }
            case 8: {
                this.m_currentPanel = 7;
                break;
            }
            case 7: {
                this.m_currentPanel = 0;
                break;
            }
            case 0: {
                if (this.hasUDRequiredOneOfDefinitions()) {
                    this.m_currentPanel = 9;
                    break;
                }
            }
            case 9: {
                this.m_currentPanel = 1;
                break;
            }
            case 1: {
                if (this.hasOptionalColumns()) {
                    this.m_currentPanel = 2;
                    break;
                }
                if (this.m_allowAdditionalFields) {
                    this.m_currentPanel = 10;
                    break;
                }
                this.m_currentPanel = 4;
                break;
            }
            case 2: {
                if (this.m_allowAdditionalFields) {
                    this.m_currentPanel = 10;
                    break;
                }
                this.m_currentPanel = 4;
                break;
            }
            case 10: {
                if (this.hasMappedUnits()) {
                    this.m_currentPanel = 11;
                    break;
                }
                this.m_currentPanel = 4;
                break;
            }
            case 11: {
                this.m_currentPanel = 4;
                break;
            }
            case 4: {
                this.m_currentPanel = 5;
            }
        }
    }

    public void back() {
        if (!this.isButtonEnabled(0)) {
            throw new IllegalStateException();
        }
        switch (this.m_currentPanel) {
            case 11: {
                this.m_currentPanel = 10;
                break;
            }
            case 10: {
                if (this.hasOptionalColumns()) {
                    this.m_currentPanel = 2;
                    break;
                }
                this.m_currentPanel = 1;
                break;
            }
            case 2: {
                this.m_currentPanel = 1;
                break;
            }
            case 1: {
                if (this.hasUDRequiredOneOfDefinitions()) {
                    this.m_currentPanel = 9;
                    break;
                }
            }
            case 9: {
                this.m_currentPanel = 0;
                break;
            }
            case 0: {
                this.m_currentPanel = 7;
                break;
            }
            case 7: {
                if (this.m_buildHelper.shouldPromptForAddressDictionary(this.getCountryCode(), this.m_locale, this.m_udDataType)) {
                    this.m_currentPanel = 8;
                    break;
                }
            }
            case 8: {
                this.m_currentPanel = 6;
                break;
            }
            case 6: {
                this.m_currentPanel = 3;
            }
        }
    }

    private boolean hasOptionalColumns() {
        for (UDColumnDefinition def : this.m_UDColumnDefs) {
            if (def.isRequired()) continue;
            return true;
        }
        return false;
    }

    public boolean supportsMultipleDictTypes() {
        return this.m_permittedUserDictionaryTypes.size() > 1;
    }

    private boolean addrDictPanelInformationSpecified() {
        return this.m_buildHelper.isValidAddressDictionary(this.getAddressDictionary(), this.getCountryCode());
    }

    private boolean inputPanelInformationSpecified() {
        if (this.getCountryCode().length() == 0) {
            return false;
        }
        return this.m_UDColumnDefs.size() > 0 && this.m_tableColumns.size() > 0;
    }

    private void populateAddressDictionary() {
        this.setAddressDictionary(this.m_buildHelper.getDatasetPath(this.getCountryCode()));
    }

    private void populateColumnDefList() {
        this.m_UDColumnDefs = this.m_buildHelper.getColumnsToMap(this.getCountryCode(), this.m_locale, this.m_udDataType);
        this.m_allowAdditionalFields = this.m_buildHelper.isAllowAdditionalFields(this.getCountryCode(), this.m_locale, this.m_udDataType);
    }

    public void setInputTable(String inputTable) {
        String prevTable = this.getInputTable();
        this.m_properties.setProperty("street_inputTable", inputTable);
        this.populateTableColumns();
        if (prevTable != null && !prevTable.equals(this.getInputTable())) {
            this.clearPreviousColumnMappings();
        }
    }

    public String getInputTable() {
        String inputTable = this.m_properties.getProperty("street_inputTable");
        return inputTable == null ? EMPTY_STRING : inputTable;
    }

    private String getInputTable(Properties props) {
        String inputTable = props.getProperty("street_inputTable");
        return inputTable == null ? EMPTY_STRING : inputTable;
    }

    public List getTableColumns() {
        return this.m_tableColumns;
    }

    private void populateTableColumns() {
        try {
            this.m_tableColumns = Collections.unmodifiableList(this.m_buildHelper.getTableColumnNames(new File(this.getInputTable())));
        }
        catch (IOException e) {
            this.m_tableColumns = Collections.EMPTY_LIST;
        }
        this.m_UDOneOfDefs = Collections.unmodifiableList(this.m_buildHelper.getUDRequiredOneOfDefinitions(this.getCountryCode(), this.m_locale, this.m_udDataType));
        this.m_UDSetDefs = Collections.unmodifiableList(this.m_buildHelper.getUDRequiredSetDefinitions(this.getCountryCode(), this.m_locale, this.m_udDataType));
    }

    public boolean hasUDRequiredOneOfDefinitions() {
        return this.m_UDOneOfDefs.size() != 0;
    }

    public void appendOneOfAndSetDescriptions(StringBuffer sb) {
        String desc;
        int i;
        for (i = 0; i < this.m_UDOneOfDefs.size(); ++i) {
            UDRequiredOneOfDefinition oneof = (UDRequiredOneOfDefinition)this.m_UDOneOfDefs.get(i);
            desc = oneof.getDescription();
            if (desc == null || desc.length() <= 0) continue;
            sb.append("  ");
            sb.append(desc);
        }
        for (i = 0; i < this.m_UDSetDefs.size(); ++i) {
            UDRequiredSetDefinition set = (UDRequiredSetDefinition)this.m_UDSetDefs.get(i);
            desc = set.getDescription();
            if (desc == null || desc.length() <= 0) continue;
            sb.append("  ");
            sb.append(desc);
        }
    }

    public void setColumnMap(String udColumnKey, String tableColumnName) {
        if (tableColumnName == null || tableColumnName.length() == 0) {
            this.m_properties.remove(udColumnKey);
            this.m_mappedUDKeys.remove(udColumnKey);
        } else {
            this.m_properties.setProperty(udColumnKey, tableColumnName);
            this.m_mappedUDKeys.add(udColumnKey);
        }
    }

    public String getColumnMap(String udColumnKey) {
        return this.m_properties.getProperty(udColumnKey);
    }

    public void setOutputFile(String outputFilePath) {
        File outputFile = new File(this.stripJDRExtension(outputFilePath));
        if (outputFile.getParentFile() != null) {
            this.m_properties.setProperty("street_outputFilePath", outputFile.getParent());
            this.m_properties.setProperty("geo2sac_outputFilePath", outputFile.getParent());
            this.m_properties.setProperty("post2sac_outputFilePath", outputFile.getParent());
            this.m_properties.setProperty("postInfo_outputFilePath", outputFile.getParent());
            this.m_properties.setProperty("geoInfo_outputFilePath", outputFile.getParent());
        }
        this.m_properties.setProperty("street_outputFile", outputFile.getName());
        this.m_properties.setProperty(ERROR_LOG, outputFile.getPath() + ERR_EXT);
        this.m_properties.setProperty(STATUS_LOG, outputFile.getPath() + LOG_EXT);
    }

    public String getOutputFile() {
        return this.getOutputFile(this.m_properties);
    }

    private String getOutputFile(Properties props) {
        String path = props.getProperty("street_outputFilePath");
        String name = props.getProperty("street_outputFile");
        if (path != null && name != null) {
            return new File(path, name + ".jdr").getPath();
        }
        return EMPTY_STRING;
    }

    public void cancel() {
        this.m_internalProgressUpdater.issueCancel();
    }

    private boolean outputFileSpecified() {
        return this.m_buildHelper.isValidOutputUD(this.getOutputFile());
    }

    private String stripJDRExtension(String outputFilePath) {
        String result = outputFilePath;
        int extIndex = outputFilePath.lastIndexOf(46);
        if (extIndex > 0) {
            String strippedName = outputFilePath.substring(0, extIndex);
            String strippedExt = outputFilePath.substring(extIndex, outputFilePath.length());
            if (strippedExt.toLowerCase().equals(".jdr")) {
                result = strippedName;
            }
        }
        return result;
    }

    private void setProgress(int progress) {
        this.m_progress = progress;
        if (this.m_progress == 100) {
            this.m_currentPanel = 5;
        }
    }

    private void runUDCreation() {
        ProgressBarUpdaterProvider.assignProgressBarUpdater((IProgressBarUpdater)this.m_internalProgressUpdater);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List propertySet = UDGUIController.this.getProperties(UDGUIController.this.buildProperties());
                    if (propertySet.size() > 1 && ((Properties)propertySet.get(0)).getProperty("COUNTRY") != null && !((Properties)propertySet.get(0)).getProperty("COUNTRY").equalsIgnoreCase("USA")) {
                        MultipleControllerProgressBarUpdater updater = new MultipleControllerProgressBarUpdater(UDGUIController.this.m_internalProgressUpdater.m_progressUpdater);
                        MultipleDataCreationManager dataCreationMgr = new MultipleDataCreationManager();
                        dataCreationMgr.createData(propertySet, updater);
                    } else {
                        PhaseProgressBoundsProvider provider = PhaseProgressBoundsProvider.getInstance();
                        provider.addBounds(0, new PhaseProgressBounds(0, 40));
                        provider.addBounds(1, new PhaseProgressBounds(41, 80));
                        provider.addBounds(2, new PhaseProgressBounds(81, 100));
                        UDGUIController.this.m_dataCreator.runProcess(UDGUIController.this.buildProperties());
                    }
                }
                catch (DataCreationException dataCreationException) {
                }
                catch (UserCancelledRuntimeException userCancelledRuntimeException) {
                }
                finally {
                    try {
                        UDGUIController.this.m_internalProgressUpdater.update(100);
                    }
                    catch (UserCancelledRuntimeException userCancelledRuntimeException) {}
                }
            }
        }).start();
    }

    public int getProgress() {
        return this.m_progress;
    }

    public File getErrorFile() {
        String log = this.m_properties.getProperty(ERROR_LOG);
        if (log != null) {
            return new File(log);
        }
        return new File(EMPTY_STRING);
    }

    public File getStatusFile() {
        String log = this.m_properties.getProperty(STATUS_LOG);
        if (log != null) {
            return new File(log);
        }
        return new File(EMPTY_STRING);
    }

    public int getUserMessage() {
        switch (this.m_currentPanel) {
            case 8: {
                if (!this.m_buildHelper.isValidAddressDictionary(this.getAddressDictionary(), this.getCountryCode())) {
                    return 1;
                }
                return -1;
            }
            case 6: {
                if (this.m_UDColumnDefs.size() == 0) {
                    return 0;
                }
                return -1;
            }
            case 0: {
                if (this.m_tableColumns.size() == 0) {
                    return 2;
                }
                return -1;
            }
            case 3: {
                return this.outputFileSpecified() ? -1 : 3;
            }
            case 9: {
                int result = this.conditionallyRequiredColumnsNotMapped();
                if (result == 2) {
                    return 5;
                }
                if (result == 3) {
                    return 6;
                }
                return -1;
            }
            case 1: {
                int result = this.requiredColumnsNotMapped();
                if (result == 1) {
                    return 4;
                }
                return -1;
            }
            case 2: {
                int result = this.requiredSetColumnsNotMapped();
                if (result == 3) {
                    return 6;
                }
                return -1;
            }
        }
        return -1;
    }

    public String getUDDescription() {
        return this.getUDDescription(this.m_properties);
    }

    private String getUDDescription(Properties properties) {
        return properties.getProperty(UD_DESCRIPTION);
    }

    public void setUDDescription(String udDescription) {
        this.m_properties.setProperty(UD_DESCRIPTION, udDescription);
    }

    public boolean hasMappedUnits() {
        for (String key : this.m_mappedUDKeys) {
            if (!unitMappings.contains(key)) continue;
            return true;
        }
        return false;
    }

    private List<Properties> getProperties(Properties baseProperty) {
        ArrayList<Properties> propertySet = new ArrayList<Properties>();
        String[] tabfiles = null;
        File tabFileParentPath = null;
        if (null != baseProperty) {
            String tabPath = baseProperty.getProperty("street_inputTable");
            File tabFilePath = new File(tabPath);
            tabFileParentPath = new File(tabFilePath.getParent());
            tabfiles = tabFileParentPath.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.toUpperCase().endsWith(".TAB");
                }
            });
        }
        for (void var8_9 : tabfiles) {
            Properties property = (Properties)baseProperty.clone();
            property.setProperty("street_inputTable", tabFileParentPath + "/" + (String)var8_9);
            property.setProperty("street_outputFile", var8_9.substring(0, var8_9.toUpperCase().indexOf(".TAB")));
            propertySet.add(property);
        }
        return propertySet;
    }

    static {
        HashSet<String> tmp = new HashSet<String>(6);
        tmp.add("street_leftLowUnit");
        tmp.add("street_rightLowUnit");
        tmp.add("street_leftUnitType");
        tmp.add("street_rightUnitType");
        tmp.add("street_leftHighUnit");
        tmp.add("street_rightHighUnit");
        unitMappings = Collections.unmodifiableSet(tmp);
    }

    private class MultipleControllerProgressBarUpdater
    implements IMultipleThreadProgressUpdator {
        private boolean m_issueCancel;
        private final IProgressBarUpdater m_progressUpdater;

        public MultipleControllerProgressBarUpdater(IProgressBarUpdater progressUpdater) {
            this.m_progressUpdater = progressUpdater;
        }

        public synchronized void issueCancel() {
            this.m_issueCancel = true;
        }

        public synchronized void update(int percentComplete) throws UserCancelledRuntimeException {
            if (this.m_issueCancel) {
                throw new UserCancelledRuntimeException();
            }
            UDGUIController.this.setProgress(percentComplete);
            this.m_progressUpdater.update(percentComplete);
        }

        @Override
        public int getProgress() {
            return UDGUIController.this.m_progress;
        }
    }

    private class ControllerProgressBarUpdater
    implements IProgressBarUpdater {
        private boolean m_issueCancel;
        private final IProgressBarUpdater m_progressUpdater;

        public ControllerProgressBarUpdater(IProgressBarUpdater progressUpdater) {
            this.m_progressUpdater = progressUpdater;
        }

        public synchronized void issueCancel() {
            this.m_issueCancel = true;
        }

        public synchronized void update(int percentComplete) throws UserCancelledRuntimeException {
            if (this.m_issueCancel) {
                throw new UserCancelledRuntimeException();
            }
            UDGUIController.this.setProgress(percentComplete);
            this.m_progressUpdater.update(percentComplete);
        }
    }

    public static enum USER_DICT_TYPE {
        RANGE_BASED,
        POINT_BASED;

    }
}

