/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud;

import com.mapinfo.mapmarker.common.dp.AdditionalFieldsDefinitionTranslator;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDBuildHelper;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDColumnDefinition;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDGUI;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDGUIController;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

class UDWizardPnl
extends JPanel {
    private static final String RESOURCE_BUNDLE_NAME = "com.mapinfo.mapmarker.common.dp.gui.ud.UDGUI";
    private static final String PANEL_NAME_INPUT = "input panel";
    private static final String PANEL_NAME_ADDRESS_DICT = "address dict panel";
    private static final String PANEL_NAME_COUNTRY = "country panel";
    private static final String PANEL_NAME_CONDITIONAL_COLUMNS = "conditional columns panel";
    private static final String PANEL_NAME_REQUIRED_COLUMNS = "required columns panel";
    private static final String PANEL_NAME_OPTIONAL_COLUMNS = "optional columns panel";
    private static final String PANEL_NAME_CUSTOM_COLUMNS = "custom columns panel";
    private static final String PANEL_NAME_CUSTOM_UNIT_COLUMNS = "custom unit columns panel";
    private static final String PANEL_NAME_OUTPUT = "output panel";
    private static final String PANEL_NAME_PROGRESS = "progress panel";
    private static final String PANEL_NAME_COMPLETE = "complete panel";
    private static final String PANEL_NAME_DICT_TYPE = "dict type panel";
    private static String SIDE_BOTH;
    private static String SIDE_LEFT;
    private static String SIDE_RIGHT;
    private static int INDEX_SIDE_BOTH;
    private static int INDEX_SIDE_LEFT;
    private static int INDEX_SIDE_RIGHT;
    private ResourceBundle m_resourceBundle;
    private JPanel m_inputPnl;
    private JPanel m_addrDictPnl;
    private JPanel m_countryPnl;
    private JPanel m_dictTypePnl;
    private JPanel m_customPnl;
    private JPanel m_customUnitPnl;
    private JTextArea m_dictTypePnlDirections;
    private String m_standardDictTypePnlDirections;
    private String m_noPointDictTypePnlDirections;
    private JComboBox m_countryInput;
    private JComboBox m_customCombo;
    private JComboBox m_customSideCombo;
    private JComboBox m_customUnitSideCombo;
    private JLabel m_customSideLabel;
    private JLabel m_customUnitSideLabel;
    private JTextField m_customKeyField;
    private JTable m_customMappingTable;
    private JComboBox m_customUnitCombo;
    private JTextField m_customUnitKeyField;
    private JTable m_customUnitMappingTable;
    private final Locale m_locale;
    private final UDGUI m_udgui;
    private UDGUIController m_controller;
    private final UDBuildHelper m_helper;
    private JTextField m_tableInput;
    private JPanel m_requiredPnl;
    private Box m_requiredColBox1;
    private Box m_requiredColBox2;
    private List m_requiredCombos = new ArrayList();
    private JPanel m_conditionalPnl;
    private JTextArea m_conditionalPnlDirections;
    private Box m_conditionalColBox1;
    private Box m_conditionalColBox2;
    private List m_conditionalCombos = new ArrayList();
    private JRadioButton m_standardRadio;
    private JRadioButton m_pointRadio;
    private JPanel m_optionalPnl;
    private Box m_optionalColBox1;
    private Box m_optionalColBox2;
    private List m_optionalCombos = new ArrayList();
    private JPanel m_outputPnl;
    private JTextField m_udDescription;
    private JTextField m_outputUD;
    private Box m_progressPnl;
    private JProgressBar m_progressBar;
    private JPanel m_completePnl;
    private JTextArea m_logFileTextArea;
    private JTextArea m_errFileTextArea;
    private List m_tableColumns = Collections.EMPTY_LIST;
    private List m_columnDefs = Collections.EMPTY_LIST;
    private JTextField m_addressDictInput;
    private JLabel m_addressDictPanelMessage;
    private JLabel m_inputPanelMessage;
    private JLabel m_outputPanelMessage;
    private JLabel m_requiredColsPanelMessage;
    private JLabel m_conditionalColsPanelMessage;
    private JLabel m_optionalColsPanelMessage;
    private JLabel m_customColsPanelMessage;
    private JLabel m_customUnitColsPanelMessage;
    private String m_shownPanel = "";
    private JButton m_addressBrowseBtn;

    public UDWizardPnl(Locale locale, UDBuildHelper helper, UDGUI udgui, UDGUIController controller) {
        this.m_locale = locale;
        this.m_udgui = udgui;
        this.m_controller = controller;
        this.m_helper = helper;
        this.m_resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale);
        SIDE_LEFT = this.m_resourceBundle.getString("customSideLeft");
        SIDE_RIGHT = this.m_resourceBundle.getString("customSideRight");
        SIDE_BOTH = this.m_resourceBundle.getString("customSideBoth");
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.createInputPanel();
        this.createAddressDictPanel();
        this.createCountryPanel();
        this.createDictTypePanel();
        this.createConditionalColumnsPanel();
        this.createRequiredColumnsPanel();
        this.createOptionalColumnsPanel();
        this.createCustomAdditionalFieldsPanel();
        this.createCustomUnitAdditionalFieldsPanel();
        this.createOutputPanel();
        this.createProgressPanel();
        this.createCompletePanel();
        this.setInitialValues();
    }

    private void setInitialValues() {
        String udDescription;
        JComboBox box;
        int i;
        String inputTable;
        String addressDictionary;
        String countryCode = this.m_controller.getCountryCode();
        if (countryCode != null) {
            this.m_countryInput.setSelectedItem(countryCode);
        }
        if ((addressDictionary = this.m_controller.getAddressDictionary()) != null) {
            this.m_addressDictInput.setText(addressDictionary);
        }
        if ((inputTable = this.m_controller.getInputTable()) != null) {
            this.m_tableInput.setText(inputTable);
        }
        this.updateColumns();
        for (i = 0; i < this.m_requiredCombos.size(); ++i) {
            box = (JComboBox)this.m_requiredCombos.get(i);
            box.setSelectedItem(this.m_controller.getColumnMap(box.getName()));
        }
        for (i = 0; i < this.m_conditionalCombos.size(); ++i) {
            box = (JComboBox)this.m_conditionalCombos.get(i);
            box.setSelectedItem(this.m_controller.getColumnMap(box.getName()));
        }
        for (i = 0; i < this.m_optionalCombos.size(); ++i) {
            box = (JComboBox)this.m_optionalCombos.get(i);
            box.setSelectedItem(this.m_controller.getColumnMap(box.getName()));
        }
        String outputTable = this.m_controller.getOutputFile();
        if (outputTable != null) {
            this.m_outputUD.setText(outputTable);
        }
        if ((udDescription = this.m_controller.getUDDescription()) != null) {
            this.m_udDescription.setText(udDescription);
        }
        String customLeftProperties = this.m_controller.getColumnMap("street_leftRangeAddFlds");
        String customRightProperties = this.m_controller.getColumnMap("street_rightRangeAddFlds");
        this.m_customMappingTable.removeAll();
        if (!StringUtilities.isEmpty((String)customLeftProperties)) {
            if (StringUtilities.equalStrings((String)customLeftProperties, (String)customRightProperties)) {
                this.addPropertyStringValuesToTable(this.m_customMappingTable, customLeftProperties, SIDE_BOTH);
            } else {
                this.addPropertyStringValuesToTable(this.m_customMappingTable, customLeftProperties, SIDE_LEFT);
            }
        }
        if (!StringUtilities.isEmpty((String)customRightProperties) && !StringUtilities.equalStrings((String)customLeftProperties, (String)customRightProperties)) {
            this.addPropertyStringValuesToTable(this.m_customMappingTable, customLeftProperties, SIDE_RIGHT);
        }
        String customLeftUnitProperties = this.m_controller.getColumnMap("street_leftUnitAddFlds");
        String customRightUnitProperties = this.m_controller.getColumnMap("street_rightUnitAddFlds");
        this.m_customUnitMappingTable.removeAll();
        if (!StringUtilities.isEmpty((String)customLeftUnitProperties)) {
            if (StringUtilities.equalStrings((String)customLeftUnitProperties, (String)customRightUnitProperties)) {
                this.addPropertyStringValuesToTable(this.m_customUnitMappingTable, customLeftUnitProperties, SIDE_BOTH);
            } else {
                this.addPropertyStringValuesToTable(this.m_customUnitMappingTable, customLeftUnitProperties, SIDE_LEFT);
            }
        }
        if (!StringUtilities.isEmpty((String)customRightUnitProperties) && !StringUtilities.equalStrings((String)customLeftUnitProperties, (String)customRightUnitProperties)) {
            this.addPropertyStringValuesToTable(this.m_customUnitMappingTable, customRightUnitProperties, SIDE_RIGHT);
        }
        this.updateUserMessage();
    }

    private void createCompletePanel() {
        this.m_completePnl = new JPanel(new GridLayout(2, 1, 0, 20));
        this.m_completePnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("completePanelTitle")));
        JPanel logPnl = new JPanel(new BorderLayout());
        logPnl.add((Component)new JLabel(this.m_resourceBundle.getString("logFileLbl")), "North");
        this.m_logFileTextArea = new JTextArea();
        JScrollPane logScroller = new JScrollPane(this.m_logFileTextArea);
        logPnl.add((Component)logScroller, "Center");
        this.m_completePnl.add(logPnl);
        JPanel errPnl = new JPanel(new BorderLayout());
        errPnl.add((Component)new JLabel(this.m_resourceBundle.getString("errFileLbl")), "North");
        this.m_errFileTextArea = new JTextArea();
        JScrollPane errScroller = new JScrollPane(this.m_errFileTextArea);
        errPnl.add((Component)errScroller, "Center");
        this.m_completePnl.add(errPnl);
    }

    private void createProgressPanel() {
        this.m_progressPnl = new Box(1);
        this.m_progressPnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("progressPanelTitle")));
        this.m_progressPnl.add(Box.createGlue());
        Box progressBox = new Box(0);
        this.m_progressBar = new JProgressBar(0, 0, 100);
        progressBox.add(Box.createHorizontalStrut(10));
        progressBox.add(this.m_progressBar);
        progressBox.add(Box.createHorizontalStrut(10));
        this.m_progressPnl.add(progressBox);
        this.m_progressPnl.add(Box.createGlue());
    }

    private void createOutputPanel() {
        this.m_outputPnl = new JPanel();
        this.m_outputPnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("outputPanelTitle")));
        SpringLayout layout = new SpringLayout();
        this.m_outputPnl.setLayout(layout);
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("outputDirectionsLbl"), null);
        this.m_outputPnl.add(directions);
        layout.putConstraint("West", (Component)directions, 5, "West", (Component)this.m_outputPnl);
        layout.putConstraint("North", (Component)directions, 10, "North", (Component)this.m_outputPnl);
        JLabel outputLbl = new JLabel(this.m_resourceBundle.getString("outputDictionaryLbl"));
        this.m_outputPnl.add(outputLbl);
        layout.putConstraint("West", (Component)outputLbl, 10, "West", (Component)this.m_outputPnl);
        layout.putConstraint("North", (Component)outputLbl, 10, "South", (Component)directions);
        Box outputBrowseBox = new Box(0);
        this.m_outputUD = new JTextField(30);
        outputBrowseBox.add(this.m_outputUD);
        this.m_outputUD.getDocument().addDocumentListener(new OutputDictionaryListener());
        outputBrowseBox.add(Box.createHorizontalStrut(10));
        JButton browseBtn = new JButton(this.m_resourceBundle.getString("browseBtn"));
        browseBtn.addActionListener(new OutputBrowseListener());
        outputBrowseBox.add(browseBtn);
        this.m_outputPnl.add(outputBrowseBox);
        layout.putConstraint("West", (Component)outputBrowseBox, 10, "West", (Component)this.m_outputPnl);
        layout.putConstraint("North", (Component)outputBrowseBox, 0, "South", (Component)outputLbl);
        JLabel descrLbl = new JLabel(this.m_resourceBundle.getString("outputDescriptionLbl"));
        this.m_outputPnl.add(descrLbl);
        layout.putConstraint("West", (Component)descrLbl, 10, "West", (Component)this.m_outputPnl);
        layout.putConstraint("North", (Component)descrLbl, 10, "South", (Component)outputBrowseBox);
        this.m_udDescription = new JTextField(30);
        this.m_outputPnl.add(this.m_udDescription);
        this.m_udDescription.getDocument().addDocumentListener(new UDDescriptionListener());
        layout.putConstraint("West", (Component)this.m_udDescription, 10, "West", (Component)this.m_outputPnl);
        layout.putConstraint("North", (Component)this.m_udDescription, 10, "South", (Component)descrLbl);
        this.m_outputPanelMessage = new JLabel();
        this.m_outputPanelMessage.setVisible(false);
        this.m_outputPnl.add(this.m_outputPanelMessage);
        layout.putConstraint("South", (Component)this.m_outputPanelMessage, 0, "South", (Component)this.m_outputPnl);
        layout.putConstraint("West", (Component)this.m_outputPanelMessage, 10, "West", (Component)this.m_outputPnl);
        this.m_outputPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                UDWizardPnl.this.m_outputUD.requestFocusInWindow();
            }
        });
    }

    private void createRequiredColumnsPanel() {
        this.m_requiredColBox1 = new Box(1);
        this.m_requiredColBox2 = new Box(1);
        Box finalBox = new Box(0);
        finalBox.add(Box.createGlue());
        finalBox.add(this.m_requiredColBox1);
        finalBox.add(Box.createGlue());
        finalBox.add(Box.createHorizontalStrut(10));
        finalBox.add(Box.createGlue());
        finalBox.add(this.m_requiredColBox2);
        finalBox.add(Box.createGlue());
        JScrollPane requiredColScrollPne = new JScrollPane(finalBox);
        requiredColScrollPne.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("requiredPanelTitle")));
        this.m_requiredPnl = new JPanel();
        this.m_requiredPnl.setLayout(new BorderLayout());
        this.m_requiredPnl.add((Component)requiredColScrollPne, "Center");
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("requiredDirectionsLbl"), BorderFactory.createLineBorder(this.getBackground(), 15));
        this.m_requiredPnl.add((Component)directions, "North");
        this.m_requiredColsPanelMessage = new JLabel();
        this.m_requiredPnl.add((Component)this.m_requiredColsPanelMessage, "South");
        this.m_requiredPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (UDWizardPnl.this.m_requiredCombos.size() > 0) {
                    ((JComboBox)UDWizardPnl.this.m_requiredCombos.get(0)).requestFocusInWindow();
                }
            }
        });
        this.m_requiredPnl.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_requiredCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_requiredCombos.get(0);
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_requiredCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_requiredCombos.get(0);
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_requiredCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_requiredCombos.get(UDWizardPnl.this.m_requiredCombos.size() - 1);
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (UDWizardPnl.this.m_requiredCombos.size() == 0) {
                    return null;
                }
                int idx = UDWizardPnl.this.m_requiredCombos.indexOf(aComponent);
                if (idx == UDWizardPnl.this.m_requiredCombos.size() - 1) {
                    return this.getFirstComponent(focusCycleRoot);
                }
                if (idx >= 0) {
                    return (JComboBox)UDWizardPnl.this.m_requiredCombos.get(idx + 1);
                }
                return null;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                if (UDWizardPnl.this.m_requiredCombos.size() == 0) {
                    return null;
                }
                int idx = UDWizardPnl.this.m_requiredCombos.indexOf(aComponent);
                if (idx == 0) {
                    return this.getLastComponent(focusCycleRoot);
                }
                if (idx >= 0) {
                    return (JComboBox)UDWizardPnl.this.m_requiredCombos.get(idx - 1);
                }
                return null;
            }
        });
        this.m_requiredPnl.setFocusCycleRoot(true);
    }

    private void createConditionalColumnsPanel() {
        this.m_conditionalColBox1 = new Box(1);
        this.m_conditionalColBox2 = new Box(1);
        Box finalBox = new Box(0);
        finalBox.add(Box.createGlue());
        finalBox.add(this.m_conditionalColBox1);
        finalBox.add(Box.createGlue());
        finalBox.add(Box.createHorizontalStrut(10));
        finalBox.add(Box.createGlue());
        finalBox.add(this.m_conditionalColBox2);
        finalBox.add(Box.createGlue());
        JScrollPane conditionalColScrollPne = new JScrollPane(finalBox);
        conditionalColScrollPne.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("conditionalPanelTitle")));
        this.m_conditionalPnl = new JPanel();
        this.m_conditionalPnl.setLayout(new BorderLayout());
        this.m_conditionalPnl.add((Component)conditionalColScrollPne, "Center");
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("conditionalDirectionsLbl"), BorderFactory.createLineBorder(this.getBackground(), 15));
        this.m_conditionalPnlDirections = (JTextArea)directions.getViewport().getComponent(0);
        this.m_conditionalPnl.add((Component)directions, "North");
        this.m_conditionalColsPanelMessage = new JLabel();
        this.m_conditionalPnl.add((Component)this.m_conditionalColsPanelMessage, "South");
        this.m_conditionalPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (UDWizardPnl.this.m_conditionalCombos.size() > 0) {
                    ((JComboBox)UDWizardPnl.this.m_conditionalCombos.get(0)).requestFocusInWindow();
                }
            }
        });
        this.m_conditionalPnl.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_conditionalCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_conditionalCombos.get(0);
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_conditionalCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_conditionalCombos.get(0);
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_conditionalCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_conditionalCombos.get(UDWizardPnl.this.m_conditionalCombos.size() - 1);
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (UDWizardPnl.this.m_conditionalCombos.size() == 0) {
                    return null;
                }
                int idx = UDWizardPnl.this.m_conditionalCombos.indexOf(aComponent);
                if (idx == UDWizardPnl.this.m_conditionalCombos.size() - 1) {
                    return this.getFirstComponent(focusCycleRoot);
                }
                if (idx >= 0) {
                    return (JComboBox)UDWizardPnl.this.m_conditionalCombos.get(idx + 1);
                }
                return null;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                if (UDWizardPnl.this.m_conditionalCombos.size() == 0) {
                    return null;
                }
                int idx = UDWizardPnl.this.m_conditionalCombos.indexOf(aComponent);
                if (idx == 0) {
                    return this.getLastComponent(focusCycleRoot);
                }
                if (idx >= 0) {
                    return (JComboBox)UDWizardPnl.this.m_conditionalCombos.get(idx - 1);
                }
                return null;
            }
        });
        this.m_conditionalPnl.setFocusCycleRoot(true);
    }

    private void createOptionalColumnsPanel() {
        this.m_optionalColBox1 = new Box(1);
        this.m_optionalColBox2 = new Box(1);
        Box mainBox = new Box(0);
        mainBox.add(Box.createGlue());
        mainBox.add(this.m_optionalColBox1);
        mainBox.add(Box.createGlue());
        mainBox.add(Box.createHorizontalStrut(10));
        mainBox.add(Box.createGlue());
        mainBox.add(this.m_optionalColBox2);
        mainBox.add(Box.createGlue());
        JScrollPane optionalColScrollPne = new JScrollPane(mainBox);
        optionalColScrollPne.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("optionalPanelTitle")));
        this.m_optionalPnl = new JPanel();
        this.m_optionalPnl.setLayout(new BorderLayout());
        this.m_optionalPnl.add((Component)optionalColScrollPne, "Center");
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("optionalDirectionsLbl"), BorderFactory.createLineBorder(this.getBackground(), 15));
        this.m_optionalPnl.add((Component)directions, "North");
        this.m_optionalColsPanelMessage = new JLabel();
        this.m_optionalPnl.add((Component)this.m_optionalColsPanelMessage, "South");
        this.m_optionalPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (UDWizardPnl.this.m_optionalCombos.size() > 0) {
                    ((JComboBox)UDWizardPnl.this.m_optionalCombos.get(0)).requestFocusInWindow();
                }
            }
        });
        this.m_optionalPnl.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_optionalCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_optionalCombos.get(0);
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_optionalCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_optionalCombos.get(0);
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                if (UDWizardPnl.this.m_optionalCombos.size() == 0) {
                    return null;
                }
                return (JComboBox)UDWizardPnl.this.m_optionalCombos.get(UDWizardPnl.this.m_optionalCombos.size() - 1);
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (UDWizardPnl.this.m_optionalCombos.size() == 0) {
                    return null;
                }
                int idx = UDWizardPnl.this.m_optionalCombos.indexOf(aComponent);
                if (idx == UDWizardPnl.this.m_optionalCombos.size() - 1) {
                    return this.getFirstComponent(focusCycleRoot);
                }
                if (idx >= 0) {
                    return (JComboBox)UDWizardPnl.this.m_optionalCombos.get(idx + 1);
                }
                return null;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                if (UDWizardPnl.this.m_optionalCombos.size() == 0) {
                    return null;
                }
                int idx = UDWizardPnl.this.m_optionalCombos.indexOf(aComponent);
                if (idx == 0) {
                    return this.getLastComponent(focusCycleRoot);
                }
                if (idx >= 0) {
                    return (JComboBox)UDWizardPnl.this.m_optionalCombos.get(idx - 1);
                }
                return null;
            }
        });
        this.m_optionalPnl.setFocusCycleRoot(true);
    }

    private void createCountryPanel() {
        int westIndent = 10;
        this.m_countryPnl = new JPanel();
        SpringLayout layout = new SpringLayout();
        this.m_countryPnl.setLayout(layout);
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("countryDirectionsLbl"), null);
        this.m_countryPnl.add(directions);
        layout.putConstraint("West", (Component)directions, 5, "West", (Component)this.m_countryPnl);
        layout.putConstraint("North", (Component)directions, 10, "North", (Component)this.m_countryPnl);
        JLabel countryLbl = new JLabel(this.m_resourceBundle.getString("countryLbl"));
        this.m_countryPnl.add(countryLbl);
        layout.putConstraint("West", (Component)countryLbl, westIndent, "West", (Component)this.m_countryPnl);
        layout.putConstraint("North", (Component)countryLbl, 10, "South", (Component)directions);
        List countryLst = this.m_helper.availableCountries();
        this.m_countryInput = new JComboBox<Object>(countryLst.toArray());
        if (!countryLst.isEmpty()) {
            this.m_countryInput.setSelectedIndex(0);
        }
        this.m_countryPnl.add(this.m_countryInput);
        layout.putConstraint("West", (Component)this.m_countryInput, westIndent, "West", (Component)this.m_countryPnl);
        layout.putConstraint("North", (Component)this.m_countryInput, 0, "South", (Component)countryLbl);
        this.m_countryInput.addItemListener(new CountryListener());
        this.m_countryPnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("countryPanelTitle")));
        this.m_countryPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                UDWizardPnl.this.m_countryInput.requestFocusInWindow();
            }
        });
    }

    private void createDictTypePanel() {
        int westIndent = 10;
        this.m_dictTypePnl = new JPanel();
        SpringLayout layout = new SpringLayout();
        this.m_dictTypePnl.setLayout(layout);
        this.m_standardDictTypePnlDirections = this.m_resourceBundle.getString("dictTypeDirectionsLbl");
        this.m_noPointDictTypePnlDirections = this.m_resourceBundle.getString("dictTypeNoPointUDDirectionsLbl");
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_standardDictTypePnlDirections, null);
        this.m_dictTypePnl.add(directions);
        layout.putConstraint("West", (Component)directions, 5, "West", (Component)this.m_dictTypePnl);
        layout.putConstraint("North", (Component)directions, 10, "North", (Component)this.m_dictTypePnl);
        this.m_dictTypePnlDirections = (JTextArea)directions.getViewport().getComponent(0);
        String lbl = this.m_resourceBundle.getString("standardUDLbl");
        this.m_standardRadio = new JRadioButton(lbl);
        this.m_standardRadio.setSelected(true);
        this.m_standardRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDWizardPnl.this.checkRadios();
            }
        });
        this.m_dictTypePnl.add(this.m_standardRadio);
        layout.putConstraint("West", (Component)this.m_standardRadio, westIndent, "West", (Component)this.m_dictTypePnl);
        layout.putConstraint("North", (Component)this.m_standardRadio, 10, "South", (Component)directions);
        lbl = this.m_resourceBundle.getString("pointUDLbl");
        this.m_pointRadio = new JRadioButton(lbl);
        this.m_dictTypePnl.add(this.m_pointRadio);
        this.m_pointRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDWizardPnl.this.checkRadios();
            }
        });
        layout.putConstraint("West", (Component)this.m_pointRadio, westIndent, "West", (Component)this.m_dictTypePnl);
        layout.putConstraint("North", (Component)this.m_pointRadio, 10, "South", (Component)this.m_standardRadio);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_standardRadio);
        group.add(this.m_pointRadio);
        this.m_dictTypePnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("typePanelTitle")));
        this.m_dictTypePnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                UDWizardPnl.this.m_standardRadio.requestFocusInWindow();
            }
        });
    }

    private void createInputPanel() {
        int westIndent = 10;
        this.m_inputPnl = new JPanel();
        SpringLayout layout = new SpringLayout();
        this.m_inputPnl.setLayout(layout);
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("inputDirectionsLbl"), null);
        this.m_inputPnl.add(directions);
        layout.putConstraint("West", (Component)directions, 5, "West", (Component)this.m_inputPnl);
        layout.putConstraint("North", (Component)directions, 10, "North", (Component)this.m_inputPnl);
        JLabel tableLbl = new JLabel(this.m_resourceBundle.getString("tableLbl"));
        this.m_inputPnl.add(tableLbl);
        layout.putConstraint("West", (Component)tableLbl, westIndent, "West", (Component)this.m_inputPnl);
        layout.putConstraint("North", (Component)tableLbl, 10, "South", (Component)directions);
        Box tableInputBrowseBox = new Box(0);
        this.m_tableInput = new JTextField(30);
        tableInputBrowseBox.add(this.m_tableInput);
        this.m_tableInput.getDocument().addDocumentListener(new TableInputListener());
        tableInputBrowseBox.add(Box.createHorizontalStrut(10));
        JButton tableBrowseBtn = new JButton(this.m_resourceBundle.getString("browseBtn"));
        tableBrowseBtn.addActionListener(new InputBrowseListener());
        tableInputBrowseBox.add(tableBrowseBtn);
        this.m_inputPnl.add(tableInputBrowseBox);
        layout.putConstraint("West", (Component)tableInputBrowseBox, westIndent, "West", (Component)this.m_inputPnl);
        layout.putConstraint("North", (Component)tableInputBrowseBox, 0, "South", (Component)tableLbl);
        this.m_inputPanelMessage = new JLabel();
        this.m_inputPanelMessage.setVisible(false);
        this.m_inputPnl.add(this.m_inputPanelMessage);
        layout.putConstraint("South", (Component)this.m_inputPanelMessage, 0, "South", (Component)this.m_inputPnl);
        layout.putConstraint("West", (Component)this.m_inputPanelMessage, westIndent, "West", (Component)this.m_inputPnl);
        this.m_inputPnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("inputPanelTitle")));
        this.m_inputPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                UDWizardPnl.this.m_tableInput.requestFocusInWindow();
            }
        });
    }

    private void createAddressDictPanel() {
        int westIndent = 10;
        this.m_addrDictPnl = new JPanel();
        SpringLayout layout = new SpringLayout();
        this.m_addrDictPnl.setLayout(layout);
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("addrDictDirectionsLbl"), null);
        this.m_addrDictPnl.add(directions);
        layout.putConstraint("West", (Component)directions, 5, "West", (Component)this.m_addrDictPnl);
        layout.putConstraint("North", (Component)directions, 10, "North", (Component)this.m_addrDictPnl);
        JLabel addressDictLbl = new JLabel(this.m_resourceBundle.getString("addressDictionaryLbl"));
        this.m_addrDictPnl.add(addressDictLbl);
        layout.putConstraint("West", (Component)addressDictLbl, westIndent, "West", (Component)this.m_addrDictPnl);
        layout.putConstraint("North", (Component)addressDictLbl, 10, "South", (Component)directions);
        Box addressDictBox = new Box(0);
        this.m_addressDictInput = new JTextField(30);
        addressDictBox.add(this.m_addressDictInput);
        this.m_addressDictInput.getDocument().addDocumentListener(new AddressDictInputListener());
        addressDictBox.add(Box.createHorizontalStrut(10));
        this.m_addressBrowseBtn = new JButton(this.m_resourceBundle.getString("browseBtn"));
        this.m_addressBrowseBtn.addActionListener(new AddressDictBrowseListener());
        addressDictBox.add(this.m_addressBrowseBtn);
        this.m_addrDictPnl.add(addressDictBox);
        layout.putConstraint("West", (Component)addressDictBox, westIndent, "West", (Component)this.m_addrDictPnl);
        layout.putConstraint("North", (Component)addressDictBox, 0, "South", (Component)addressDictLbl);
        this.m_addressDictPanelMessage = new JLabel();
        this.m_addressDictPanelMessage.setVisible(false);
        this.m_addrDictPnl.add(this.m_addressDictPanelMessage);
        layout.putConstraint("South", (Component)this.m_addressDictPanelMessage, 0, "South", (Component)this.m_addrDictPnl);
        layout.putConstraint("West", (Component)this.m_addressDictPanelMessage, westIndent, "West", (Component)this.m_addrDictPnl);
        this.m_addrDictPnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("addrDictPanelTitle")));
        this.m_addrDictPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                UDWizardPnl.this.m_addressDictInput.requestFocusInWindow();
            }
        });
    }

    String createPropertyStringFromTable(JTable table, int leftRightBoth) {
        StringBuilder sb = new StringBuilder(1024);
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        int ct = model.getRowCount();
        if (ct == 0) {
            return "NONE";
        }
        sb.append('{');
        for (int i = 0; i < ct; ++i) {
            String lrbString = (String)model.getValueAt(i, 2);
            int lrb = INDEX_SIDE_BOTH;
            if (SIDE_LEFT.equalsIgnoreCase(lrbString)) {
                lrb = INDEX_SIDE_LEFT;
            } else if (SIDE_RIGHT.equalsIgnoreCase(lrbString)) {
                lrb = INDEX_SIDE_RIGHT;
            }
            if (leftRightBoth != INDEX_SIDE_BOTH && lrb != INDEX_SIDE_BOTH && leftRightBoth != lrb) continue;
            int len = sb.length();
            if (len != 1 && ',' != sb.charAt(len - 1)) {
                sb.append(',');
            }
            sb.append('[');
            sb.append(model.getValueAt(i, 0));
            sb.append(',');
            sb.append(model.getValueAt(i, 1));
            sb.append(']');
        }
        if (sb.length() == 1) {
            return "NONE";
        }
        sb.append('}');
        return sb.toString();
    }

    void addPropertyStringValuesToTable(JTable table, String props, String side) {
        table.removeAll();
        Map keyValueMap = AdditionalFieldsDefinitionTranslator.translate((String)props);
        if (keyValueMap.isEmpty()) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        for (String key : keyValueMap.keySet()) {
            Vector<String> vector = new Vector<String>(3);
            vector.add(key);
            vector.add((String)keyValueMap.get(key));
            vector.add(side);
            model.addRow(vector);
        }
    }

    void addCustomKey() {
        DefaultTableModel model = (DefaultTableModel)this.m_customMappingTable.getModel();
        String key = this.m_customKeyField.getText().toUpperCase().trim();
        if (key.length() == 0) {
            return;
        }
        String value = this.m_customCombo.getSelectedItem().toString();
        int lrb = this.m_customSideCombo.getSelectedIndex();
        this.addCustomTableValue(model, key, value, lrb);
        this.setRangeAdditionalFields();
    }

    private void addCustomTableValue(DefaultTableModel model, String key, String value, int lrb) {
        Vector<String> row = new Vector<String>(3);
        if (lrb < 0) {
            lrb = INDEX_SIDE_BOTH;
        }
        for (int idx = model.getRowCount(); idx > 0; --idx) {
            String tmpKey = (String)model.getValueAt(idx - 1, 0);
            if (!tmpKey.equals(key)) continue;
            String tmpSide = (String)model.getValueAt(idx - 1, 2);
            if (lrb == INDEX_SIDE_BOTH || SIDE_BOTH.equals(tmpSide)) {
                model.removeRow(idx - 1);
                continue;
            }
            if ((lrb != INDEX_SIDE_LEFT || !SIDE_LEFT.equals(tmpSide)) && (lrb != INDEX_SIDE_RIGHT || !SIDE_RIGHT.equals(tmpSide))) continue;
            model.removeRow(idx - 1);
        }
        row.add(key);
        row.add(value);
        if (lrb == INDEX_SIDE_BOTH) {
            row.add(SIDE_BOTH);
        } else if (lrb == INDEX_SIDE_LEFT) {
            row.add(SIDE_LEFT);
        } else {
            row.add(SIDE_RIGHT);
        }
        model.addRow(row);
    }

    void removeCustomKey() {
        int idx = this.m_customMappingTable.getSelectedRow();
        if (idx >= 0) {
            DefaultTableModel model = (DefaultTableModel)this.m_customMappingTable.getModel();
            model.removeRow(idx);
            this.setRangeAdditionalFields();
        }
    }

    private void createCustomAdditionalFieldsPanel() {
        this.m_customPnl = new JPanel();
        SpringLayout layout = new SpringLayout();
        this.m_customPnl.setLayout(layout);
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("customDirectionsLbl"), null);
        this.m_customPnl.add(directions);
        layout.putConstraint("West", (Component)directions, 5, "West", (Component)this.m_customPnl);
        layout.putConstraint("North", (Component)directions, 10, "North", (Component)this.m_customPnl);
        this.m_customColsPanelMessage = new JLabel();
        this.m_customPnl.add((Component)this.m_customColsPanelMessage, "South");
        Box tableButtonsBox = new Box(0);
        JButton addBtn = new JButton(this.m_resourceBundle.getString("customKeyAdd"));
        tableButtonsBox.add(addBtn);
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDWizardPnl.this.addCustomKey();
            }
        });
        tableButtonsBox.add(Box.createHorizontalStrut(10));
        JButton delBtn = new JButton(this.m_resourceBundle.getString("customKeyDelete"));
        tableButtonsBox.add(delBtn);
        delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDWizardPnl.this.removeCustomKey();
            }
        });
        tableButtonsBox.add(Box.createHorizontalStrut(40));
        this.m_customSideLabel = new JLabel(this.m_resourceBundle.getString("customSideLbl"));
        tableButtonsBox.add(this.m_customSideLabel);
        tableButtonsBox.add(Box.createHorizontalStrut(10));
        this.m_customSideCombo = new JComboBox();
        this.m_customSideCombo.addItem(SIDE_BOTH);
        this.m_customSideCombo.addItem(SIDE_LEFT);
        this.m_customSideCombo.addItem(SIDE_RIGHT);
        tableButtonsBox.add(this.m_customSideCombo);
        tableButtonsBox.add(Box.createHorizontalStrut(20));
        this.m_customPnl.add(tableButtonsBox);
        layout.putConstraint("East", (Component)tableButtonsBox, 3, "East", (Component)this.m_customPnl);
        layout.putConstraint("South", (Component)tableButtonsBox, 0, "South", (Component)this.m_customPnl);
        layout.putConstraint("West", (Component)tableButtonsBox, 3, "West", (Component)this.m_customPnl);
        Box tableCustomAddBox = new Box(0);
        JLabel customLbl = new JLabel(this.m_resourceBundle.getString("customLbl"));
        tableCustomAddBox.add(customLbl);
        tableCustomAddBox.add(Box.createHorizontalStrut(5));
        this.m_customKeyField = new JTextField(10);
        tableCustomAddBox.add(this.m_customKeyField);
        tableCustomAddBox.add(Box.createHorizontalStrut(10));
        JLabel customColLbl = new JLabel(this.m_resourceBundle.getString("customColLbl"));
        tableCustomAddBox.add(customColLbl);
        tableCustomAddBox.add(Box.createHorizontalStrut(5));
        this.m_customCombo = new JComboBox();
        tableCustomAddBox.add(this.m_customCombo);
        this.m_customPnl.add(tableCustomAddBox);
        layout.putConstraint("South", (Component)tableCustomAddBox, -35, "South", (Component)this.m_customPnl);
        layout.putConstraint("West", (Component)tableCustomAddBox, 3, "West", (Component)this.m_customKeyField);
        this.m_customMappingTable = new JTable();
        Vector<String> inputNameVector = new Vector<String>(3);
        inputNameVector.add(this.m_resourceBundle.getString("customLbl"));
        inputNameVector.add(this.m_resourceBundle.getString("customColLbl"));
        inputNameVector.add(this.m_resourceBundle.getString("customSideLbl"));
        this.m_customMappingTable.setModel(new DefaultTableModel(inputNameVector, 0));
        JScrollPane pane = new JScrollPane(this.m_customMappingTable);
        this.m_customPnl.add(pane);
        layout.putConstraint("East", (Component)pane, 0, "East", (Component)this.m_customPnl);
        layout.putConstraint("South", (Component)pane, -10, "North", (Component)tableCustomAddBox);
        layout.putConstraint("West", (Component)pane, 0, "West", (Component)this.m_customPnl);
        layout.putConstraint("North", (Component)pane, 10, "South", (Component)directions);
        this.m_customPnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("customPanelTitle")));
        this.m_customPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                UDWizardPnl.this.m_customCombo.requestFocusInWindow();
            }
        });
    }

    void addCustomUnitKey() {
        DefaultTableModel model = (DefaultTableModel)this.m_customUnitMappingTable.getModel();
        String key = this.m_customUnitKeyField.getText().toUpperCase().trim();
        if (key.length() == 0) {
            return;
        }
        String value = this.m_customUnitCombo.getSelectedItem().toString();
        int lrb = this.m_customUnitSideCombo.getSelectedIndex();
        this.addCustomTableValue(model, key, value, lrb);
        this.setUnitAdditionalFields();
    }

    void removeCustomUnitKey() {
        int idx = this.m_customUnitMappingTable.getSelectedRow();
        if (idx >= 0) {
            DefaultTableModel model = (DefaultTableModel)this.m_customUnitMappingTable.getModel();
            model.removeRow(idx);
            this.setUnitAdditionalFields();
        }
    }

    private void createCustomUnitAdditionalFieldsPanel() {
        this.m_customUnitPnl = new JPanel();
        SpringLayout layout = new SpringLayout();
        this.m_customUnitPnl.setLayout(layout);
        JScrollPane directions = this.createScrolledDirectionsPane(this.m_resourceBundle.getString("customUnitDirectionsLbl"), null);
        this.m_customUnitPnl.add(directions);
        layout.putConstraint("West", (Component)directions, 5, "West", (Component)this.m_customUnitPnl);
        layout.putConstraint("North", (Component)directions, 10, "North", (Component)this.m_customUnitPnl);
        this.m_customUnitColsPanelMessage = new JLabel();
        this.m_customUnitPnl.add((Component)this.m_customUnitColsPanelMessage, "South");
        Box tableButtonsBox = new Box(0);
        JButton addBtn = new JButton(this.m_resourceBundle.getString("customKeyAdd"));
        tableButtonsBox.add(addBtn);
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDWizardPnl.this.addCustomUnitKey();
            }
        });
        tableButtonsBox.add(Box.createHorizontalStrut(10));
        JButton delBtn = new JButton(this.m_resourceBundle.getString("customKeyDelete"));
        tableButtonsBox.add(delBtn);
        delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDWizardPnl.this.removeCustomUnitKey();
            }
        });
        tableButtonsBox.add(Box.createHorizontalStrut(40));
        this.m_customUnitSideLabel = new JLabel(this.m_resourceBundle.getString("customSideLbl"));
        tableButtonsBox.add(this.m_customUnitSideLabel);
        tableButtonsBox.add(Box.createHorizontalStrut(10));
        this.m_customUnitSideCombo = new JComboBox();
        this.m_customUnitSideCombo.addItem(SIDE_BOTH);
        this.m_customUnitSideCombo.addItem(SIDE_LEFT);
        this.m_customUnitSideCombo.addItem(SIDE_RIGHT);
        tableButtonsBox.add(this.m_customUnitSideCombo);
        tableButtonsBox.add(Box.createHorizontalStrut(20));
        this.m_customUnitPnl.add(tableButtonsBox);
        layout.putConstraint("East", (Component)tableButtonsBox, 3, "East", (Component)this.m_customUnitPnl);
        layout.putConstraint("South", (Component)tableButtonsBox, 0, "South", (Component)this.m_customUnitPnl);
        layout.putConstraint("West", (Component)tableButtonsBox, 3, "West", (Component)this.m_customUnitPnl);
        Box tableCustomAddBox = new Box(0);
        JLabel customLbl = new JLabel(this.m_resourceBundle.getString("customLbl"));
        tableCustomAddBox.add(customLbl);
        tableCustomAddBox.add(Box.createHorizontalStrut(5));
        this.m_customUnitKeyField = new JTextField(10);
        tableCustomAddBox.add(this.m_customUnitKeyField);
        tableCustomAddBox.add(Box.createHorizontalStrut(10));
        JLabel customColLbl = new JLabel(this.m_resourceBundle.getString("customColLbl"));
        tableCustomAddBox.add(customColLbl);
        tableCustomAddBox.add(Box.createHorizontalStrut(5));
        this.m_customUnitCombo = new JComboBox();
        tableCustomAddBox.add(this.m_customUnitCombo);
        this.m_customUnitPnl.add(tableCustomAddBox);
        layout.putConstraint("South", (Component)tableCustomAddBox, -35, "South", (Component)this.m_customUnitPnl);
        layout.putConstraint("West", (Component)tableCustomAddBox, 3, "West", (Component)this.m_customUnitKeyField);
        this.m_customUnitMappingTable = new JTable();
        Vector<String> inputNameVector = new Vector<String>(3);
        inputNameVector.add(this.m_resourceBundle.getString("customLbl"));
        inputNameVector.add(this.m_resourceBundle.getString("customColLbl"));
        inputNameVector.add(this.m_resourceBundle.getString("customSideLbl"));
        this.m_customUnitMappingTable.setModel(new DefaultTableModel(inputNameVector, 0));
        JScrollPane pane = new JScrollPane(this.m_customUnitMappingTable);
        this.m_customUnitPnl.add(pane);
        layout.putConstraint("East", (Component)pane, 0, "East", (Component)this.m_customUnitPnl);
        layout.putConstraint("South", (Component)pane, -10, "North", (Component)tableCustomAddBox);
        layout.putConstraint("West", (Component)pane, 0, "West", (Component)this.m_customUnitPnl);
        layout.putConstraint("North", (Component)pane, 10, "South", (Component)directions);
        this.m_customUnitPnl.setBorder(this.createTitledBorder(this.m_resourceBundle.getString("customUnitPanelTitle")));
        this.m_customUnitPnl.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                UDWizardPnl.this.m_customUnitKeyField.requestFocusInWindow();
            }
        });
    }

    private Border createTitledBorder(String title) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title, 1, 2);
        Border paddedBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        return BorderFactory.createCompoundBorder(paddedBorder, titledBorder);
    }

    private JScrollPane createScrolledDirectionsPane(String contents, Border border) {
        JTextArea directions = new JTextArea(contents);
        directions.setEditable(false);
        directions.setFocusable(false);
        directions.setBorder(null);
        directions.setWrapStyleWord(true);
        Dimension dim = new Dimension(420, 90);
        directions.setLineWrap(true);
        directions.setBackground(this.getBackground());
        JScrollPane sp = new JScrollPane(directions);
        sp.setVerticalScrollBarPolicy(20);
        sp.setHorizontalScrollBarPolicy(31);
        sp.setAutoscrolls(true);
        sp.setPreferredSize(dim);
        if (border == null) {
            sp.setBorder(BorderFactory.createLineBorder(this.getBackground()));
        } else {
            sp.setBorder(border);
        }
        return sp;
    }

    private void layoutComponents() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLayout(new CardLayout());
        this.add((Component)this.m_outputPnl, PANEL_NAME_OUTPUT);
        this.add((Component)this.m_countryPnl, PANEL_NAME_COUNTRY);
        this.add((Component)this.m_dictTypePnl, PANEL_NAME_DICT_TYPE);
        this.add((Component)this.m_inputPnl, PANEL_NAME_INPUT);
        this.add((Component)this.m_addrDictPnl, PANEL_NAME_ADDRESS_DICT);
        this.add((Component)this.m_conditionalPnl, PANEL_NAME_CONDITIONAL_COLUMNS);
        this.add((Component)this.m_requiredPnl, PANEL_NAME_REQUIRED_COLUMNS);
        this.add((Component)this.m_optionalPnl, PANEL_NAME_OPTIONAL_COLUMNS);
        this.add((Component)this.m_customPnl, PANEL_NAME_CUSTOM_COLUMNS);
        this.add((Component)this.m_customUnitPnl, PANEL_NAME_CUSTOM_UNIT_COLUMNS);
        this.add((Component)this.m_progressPnl, PANEL_NAME_PROGRESS);
        this.add((Component)this.m_completePnl, PANEL_NAME_COMPLETE);
    }

    private void updateCompleteTextAreas() {
        File errorFile = this.m_controller.getErrorFile();
        this.readFileToTextArea(errorFile, this.m_errFileTextArea);
        File logFile = this.m_controller.getStatusFile();
        this.readFileToTextArea(logFile, this.m_logFileTextArea);
        String replaceLogMessage = this.m_resourceBundle.getString("creationSuccessLocalizedLogReplacementMessage");
        if (replaceLogMessage != null && replaceLogMessage.length() != 0) {
            if (this.m_errFileTextArea.getText().length() == 0) {
                this.m_logFileTextArea.setText(replaceLogMessage);
            } else {
                replaceLogMessage = this.m_resourceBundle.getString("creationFailureLocalizedLogReplacementMessage");
                this.m_errFileTextArea.setText(replaceLogMessage);
                this.m_logFileTextArea.setText("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileToTextArea(File file, JTextArea area) {
        if (file.exists()) {
            FileReader fr = null;
            try {
                fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                area.read(br, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void updateColumnPanels() {
        if (this.m_tableColumns.size() > 0 && this.m_columnDefs.size() > 0) {
            String[] comboData = this.m_tableColumns.toArray(new String[this.m_tableColumns.size()]);
            Arrays.sort(comboData, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((String)o1).compareToIgnoreCase((String)o2);
                }
            });
            String[] optionalComboData = new String[comboData.length + 1];
            System.arraycopy(comboData, 0, optionalComboData, 1, comboData.length);
            optionalComboData[0] = "";
            if (this.m_controller.hasUDRequiredOneOfDefinitions()) {
                this.updateColumnsPanel(this.m_conditionalCombos, optionalComboData, this.m_conditionalColBox1, this.m_conditionalColBox2, true, true);
            }
            this.updateColumnsPanel(this.m_requiredCombos, comboData, this.m_requiredColBox1, this.m_requiredColBox2, true, false);
            this.updateColumnsPanel(this.m_optionalCombos, optionalComboData, this.m_optionalColBox1, this.m_optionalColBox2, false, false);
            this.m_customCombo.removeAllItems();
            this.m_customUnitCombo.removeAllItems();
            for (String colName : comboData) {
                this.m_customCombo.addItem(colName);
                this.m_customUnitCombo.addItem(colName);
            }
            this.updateCustomPages();
            this.updateRequiredColumnsDirections();
        }
    }

    private void updateCustomPages() {
        boolean bPoint = this.m_controller.getUserDictionaryDataType() == UDGUIController.USER_DICT_TYPE.POINT_BASED;
        this.updateCustomWidgets(bPoint, this.m_customMappingTable, this.m_customSideCombo, this.m_customSideLabel);
        this.updateCustomWidgets(bPoint, this.m_customUnitMappingTable, this.m_customUnitSideCombo, this.m_customUnitSideLabel);
    }

    private void updateCustomWidgets(boolean bPoint, JTable table, JComboBox combo, JLabel label) {
        TableColumn third = table.getColumn(table.getColumnName(2));
        if (bPoint) {
            combo.setSelectedIndex(INDEX_SIDE_BOTH);
            third.setMinWidth(0);
            third.setMaxWidth(0);
            third.setPreferredWidth(0);
            third.setWidth(0);
        } else {
            third.setMaxWidth(10);
            third.setMaxWidth(100);
            int width = table.getWidth() / 4;
            third.setWidth(width);
            third.setPreferredWidth(width);
        }
        third.setResizable(!bPoint);
        combo.setVisible(!bPoint);
        label.setVisible(!bPoint);
    }

    private void updateColumns() {
        List tableColumns = this.m_controller.getTableColumns();
        List columnDefs = this.m_controller.getUDColumnDefinitions();
        this.m_tableColumns = tableColumns;
        this.m_columnDefs = columnDefs;
        this.updateColumnPanels();
    }

    private void updateColumnsPanel(List comboList, String[] comboData, Box box1, Box box2, boolean useRequiredCols, boolean useConditionalCols) {
        box1.removeAll();
        box2.removeAll();
        comboList.clear();
        int comboCnt = 0;
        for (int i = 0; i < this.m_columnDefs.size(); ++i) {
            UDColumnDefinition def = (UDColumnDefinition)this.m_columnDefs.get(i);
            if (def.isRequired() != useRequiredCols || def.isConditional() != useConditionalCols) continue;
            JLabel label = new JLabel(def.getPropertyText());
            label.setAlignmentX(0.0f);
            JComboBox<String> newCombo = new JComboBox<String>(comboData);
            newCombo.setName(def.getPropertyKey());
            newCombo.setSelectedIndex(-1);
            String value = this.m_controller.getColumnMap(def.getPropertyKey());
            newCombo.setSelectedItem(value);
            newCombo.addItemListener(new ColumnComboListener());
            newCombo.setMaximumSize(new Dimension((int)newCombo.getMaximumSize().getWidth(), (int)newCombo.getPreferredSize().getHeight()));
            newCombo.setAlignmentX(0.0f);
            newCombo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Container parent;
                    JComponent cmbo = (JComponent)e.getSource();
                    Rectangle scrollRect = cmbo.getBounds();
                    Rectangle workRect = new Rectangle();
                    int dx = UDWizardPnl.this.getX();
                    int dy = UDWizardPnl.this.getY();
                    for (parent = cmbo.getParent(); parent != null && !(parent instanceof JViewport); parent = parent.getParent()) {
                        Rectangle bounds = parent.getBounds(workRect);
                        dx += bounds.x;
                        dy += bounds.y;
                    }
                    if (parent != null) {
                        scrollRect.x += dx;
                        scrollRect.y += dy;
                        ((JComponent)parent).scrollRectToVisible(scrollRect);
                    }
                }
            });
            comboList.add(newCombo);
            if (comboCnt++ % 2 == 0) {
                box1.add(label);
                box1.add(newCombo);
                continue;
            }
            box2.add(label);
            box2.add(newCombo);
        }
        box1.add(Box.createGlue());
        box2.add(Box.createGlue());
    }

    private void updateRequiredColumnsDirections() {
        StringBuffer dir = new StringBuffer();
        dir.append(this.m_resourceBundle.getString("conditionalDirectionsLbl"));
        this.m_controller.appendOneOfAndSetDescriptions(dir);
        this.m_conditionalPnlDirections.setText(dir.toString());
    }

    public void updatePanel() {
        int panel = this.m_controller.getCurrentPanel();
        switch (panel) {
            case 0: {
                this.updateUserMessage();
                if (!this.m_shownPanel.equals(PANEL_NAME_INPUT)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_INPUT);
                }
                this.m_shownPanel = PANEL_NAME_INPUT;
                break;
            }
            case 8: {
                this.updateUserMessage();
                if (!this.m_shownPanel.equals(PANEL_NAME_ADDRESS_DICT)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_ADDRESS_DICT);
                }
                this.m_shownPanel = PANEL_NAME_ADDRESS_DICT;
                break;
            }
            case 6: {
                List countryLst;
                if (!(this.m_controller.getCountryCode() != null && this.m_controller.getCountryCode().length() != 0 || (countryLst = this.m_helper.availableCountries()).isEmpty())) {
                    this.m_controller.setCountryCode((String)countryLst.get(0));
                }
                if (!this.m_shownPanel.equals(PANEL_NAME_COUNTRY)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_COUNTRY);
                }
                this.m_shownPanel = PANEL_NAME_COUNTRY;
                break;
            }
            case 7: {
                if (!this.m_controller.supportsMultipleDictTypes()) {
                    UDGUIController.USER_DICT_TYPE type = this.m_controller.getUserDictionaryDataType();
                    if (type == UDGUIController.USER_DICT_TYPE.RANGE_BASED) {
                        this.m_pointRadio.setEnabled(false);
                        this.m_standardRadio.setSelected(true);
                        this.m_dictTypePnlDirections.setText(this.m_noPointDictTypePnlDirections);
                    } else {
                        this.m_standardRadio.setEnabled(false);
                        this.m_dictTypePnlDirections.setText(this.m_standardDictTypePnlDirections);
                    }
                } else {
                    this.m_pointRadio.setEnabled(true);
                    this.m_standardRadio.setEnabled(true);
                    this.m_dictTypePnlDirections.setText(this.m_standardDictTypePnlDirections);
                }
                if (!this.m_shownPanel.equals(PANEL_NAME_DICT_TYPE)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_DICT_TYPE);
                }
                this.m_shownPanel = PANEL_NAME_DICT_TYPE;
                break;
            }
            case 9: {
                this.updateUserMessage();
                if (!this.m_shownPanel.equals(PANEL_NAME_CONDITIONAL_COLUMNS)) {
                    this.updateColumns();
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_CONDITIONAL_COLUMNS);
                }
                this.m_shownPanel = PANEL_NAME_CONDITIONAL_COLUMNS;
                break;
            }
            case 1: {
                this.updateUserMessage();
                if (!this.m_shownPanel.equals(PANEL_NAME_REQUIRED_COLUMNS)) {
                    this.updateColumns();
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_REQUIRED_COLUMNS);
                }
                this.m_shownPanel = PANEL_NAME_REQUIRED_COLUMNS;
                break;
            }
            case 2: {
                this.updateUserMessage();
                if (!this.m_shownPanel.equals(PANEL_NAME_OPTIONAL_COLUMNS)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_OPTIONAL_COLUMNS);
                }
                this.m_shownPanel = PANEL_NAME_OPTIONAL_COLUMNS;
                break;
            }
            case 10: {
                this.updateUserMessage();
                if (!this.m_shownPanel.equals(PANEL_NAME_CUSTOM_COLUMNS)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_CUSTOM_COLUMNS);
                }
                this.m_shownPanel = PANEL_NAME_CUSTOM_COLUMNS;
                break;
            }
            case 11: {
                this.updateUserMessage();
                if (!this.m_shownPanel.equals(PANEL_NAME_CUSTOM_UNIT_COLUMNS)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_CUSTOM_UNIT_COLUMNS);
                }
                this.m_shownPanel = PANEL_NAME_CUSTOM_UNIT_COLUMNS;
                break;
            }
            case 3: {
                this.updateUserMessage();
                if (!this.m_shownPanel.equals(PANEL_NAME_OUTPUT)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_OUTPUT);
                }
                this.m_shownPanel = PANEL_NAME_OUTPUT;
                break;
            }
            case 4: {
                this.updateProgress();
                if (!this.m_shownPanel.equals(PANEL_NAME_PROGRESS)) {
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_PROGRESS);
                }
                this.m_shownPanel = PANEL_NAME_PROGRESS;
                break;
            }
            case 5: {
                if (!this.m_shownPanel.equals(PANEL_NAME_COMPLETE)) {
                    this.updateCompleteTextAreas();
                    ((CardLayout)this.getLayout()).show(this, PANEL_NAME_COMPLETE);
                }
                this.m_shownPanel = PANEL_NAME_COMPLETE;
            }
        }
    }

    private void updateProgress() {
        int progress = this.m_controller.getProgress();
        if (progress != 0) {
            this.m_progressBar.setValue(progress);
        }
    }

    private void updateUserMessage() {
        String userMessage = this.determineUserMessage();
        int panel = this.m_controller.getCurrentPanel();
        switch (panel) {
            case 0: {
                if (userMessage.length() > 0) {
                    this.m_inputPanelMessage.setText(userMessage);
                    this.m_inputPanelMessage.setVisible(true);
                    break;
                }
                this.m_inputPanelMessage.setVisible(false);
                break;
            }
            case 8: {
                if (userMessage.length() > 0) {
                    this.m_addressDictPanelMessage.setText(userMessage);
                    this.m_addressDictPanelMessage.setVisible(true);
                    break;
                }
                this.m_addressDictPanelMessage.setVisible(false);
                break;
            }
            case 3: {
                if (userMessage.length() > 0) {
                    this.m_outputPanelMessage.setText(userMessage);
                    this.m_outputPanelMessage.setVisible(true);
                    break;
                }
                this.m_outputPanelMessage.setVisible(false);
                break;
            }
            case 1: {
                if (userMessage.length() > 0) {
                    this.m_requiredColsPanelMessage.setText(userMessage);
                    this.m_requiredColsPanelMessage.setVisible(true);
                    break;
                }
                this.m_requiredColsPanelMessage.setVisible(false);
                break;
            }
            case 9: {
                if (userMessage.length() > 0) {
                    this.m_conditionalColsPanelMessage.setText(userMessage);
                    this.m_conditionalColsPanelMessage.setVisible(true);
                    break;
                }
                this.m_conditionalColsPanelMessage.setVisible(false);
                break;
            }
            case 2: {
                if (userMessage.length() > 0) {
                    this.m_optionalColsPanelMessage.setText(userMessage);
                    this.m_optionalColsPanelMessage.setVisible(true);
                    break;
                }
                this.m_optionalColsPanelMessage.setVisible(false);
                break;
            }
            case 10: {
                if (userMessage.length() > 0) {
                    this.m_customColsPanelMessage.setText(userMessage);
                    this.m_customColsPanelMessage.setVisible(true);
                    break;
                }
                this.m_customColsPanelMessage.setVisible(false);
                break;
            }
            case 11: {
                if (userMessage.length() > 0) {
                    this.m_customUnitColsPanelMessage.setText(userMessage);
                    this.m_customUnitColsPanelMessage.setVisible(true);
                    break;
                }
                this.m_customUnitColsPanelMessage.setVisible(false);
            }
        }
    }

    private String determineUserMessage() {
        int messageID = this.m_controller.getUserMessage();
        switch (messageID) {
            case 0: {
                return this.m_resourceBundle.getString("missingCountry");
            }
            case 1: {
                return this.m_resourceBundle.getString("missingAddressDictionary");
            }
            case 2: {
                return this.m_resourceBundle.getString("missingInputTable");
            }
            case 3: {
                return this.m_resourceBundle.getString("needEmptyOutputDir");
            }
            case 5: 
            case 6: {
                return this.m_controller.returnUnmappedRequiredColumnDescription();
            }
            case 4: {
                String msg = this.m_resourceBundle.getString("requiredColumnNotDefined") + " " + this.m_controller.returnUnmappedRequiredColumnDescription();
                return msg;
            }
        }
        return "";
    }

    private void setRangeAdditionalFields() {
        String customLeftProperties = this.createPropertyStringFromTable(this.m_customMappingTable, 1);
        String customRightProperties = this.createPropertyStringFromTable(this.m_customMappingTable, 2);
        this.m_controller.setColumnMap("street_leftRangeAddFlds", customLeftProperties);
        this.m_controller.setColumnMap("street_rightRangeAddFlds", customRightProperties);
    }

    private void setUnitAdditionalFields() {
        String customLeftUnitProperties = this.createPropertyStringFromTable(this.m_customUnitMappingTable, 1);
        String customRightUnitProperties = this.createPropertyStringFromTable(this.m_customUnitMappingTable, 2);
        this.m_controller.setColumnMap("street_leftUnitAddFlds", customLeftUnitProperties);
        this.m_controller.setColumnMap("street_rightUnitAddFlds", customRightUnitProperties);
    }

    private void checkRadios() {
        UDGUIController.USER_DICT_TYPE udType = this.m_standardRadio.isSelected() ? UDGUIController.USER_DICT_TYPE.RANGE_BASED : UDGUIController.USER_DICT_TYPE.POINT_BASED;
        this.m_controller.setUserDictionaryDataType(udType);
    }

    static {
        INDEX_SIDE_BOTH = 0;
        INDEX_SIDE_LEFT = 1;
        INDEX_SIDE_RIGHT = 2;
    }

    private class AddressDictBrowseListener
    implements ActionListener {
        JFileChooser m_fc;

        private AddressDictBrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_fc == null) {
                this.m_fc = new JFileChooser();
                this.m_fc.setAcceptAllFileFilterUsed(false);
            }
            this.m_fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String name = f.getName().toLowerCase();
                    return f.isDirectory() || name.indexOf("sac2fn") >= 0 && name.indexOf(".mmj") >= 0 && name.indexOf("_ud") < 0;
                }

                @Override
                public String getDescription() {
                    return UDWizardPnl.this.m_resourceBundle.getString("adFilterDesc");
                }
            });
            String currentPath = UDWizardPnl.this.m_addressDictInput.getText();
            this.m_fc.setCurrentDirectory(new File(currentPath));
            this.m_fc.showOpenDialog(UDWizardPnl.this);
            File selectedFile = this.m_fc.getSelectedFile();
            if (selectedFile != null) {
                UDWizardPnl.this.m_addressDictInput.setText(selectedFile.getParent());
            }
        }
    }

    private class OutputBrowseListener
    implements ActionListener {
        JFileChooser m_fc;

        private OutputBrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_fc == null) {
                this.m_fc = new JFileChooser();
                this.m_fc.setAcceptAllFileFilterUsed(false);
            }
            this.m_fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".jdr");
                }

                @Override
                public String getDescription() {
                    return UDWizardPnl.this.m_resourceBundle.getString("udFilterDesc");
                }
            });
            String currentPath = UDWizardPnl.this.m_outputUD.getText();
            this.m_fc.setSelectedFile(new File(currentPath));
            this.m_fc.showSaveDialog(UDWizardPnl.this);
            File selectedFile = this.m_fc.getSelectedFile();
            if (selectedFile != null) {
                UDWizardPnl.this.m_outputUD.setText(selectedFile.getPath());
            }
        }
    }

    private class InputBrowseListener
    implements ActionListener {
        JFileChooser m_fc;

        private InputBrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_fc == null) {
                this.m_fc = new JFileChooser();
                this.m_fc.setAcceptAllFileFilterUsed(false);
            }
            this.m_fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".tab");
                }

                @Override
                public String getDescription() {
                    return UDWizardPnl.this.m_resourceBundle.getString("tabFilterDesc");
                }
            });
            String currentPath = UDWizardPnl.this.m_tableInput.getText();
            this.m_fc.setCurrentDirectory(new File(currentPath));
            this.m_fc.showOpenDialog(UDWizardPnl.this);
            File selectedFile = this.m_fc.getSelectedFile();
            if (selectedFile != null) {
                UDWizardPnl.this.m_tableInput.setText(selectedFile.getPath());
            }
        }
    }

    private class UDDescriptionListener
    implements DocumentListener {
        private UDDescriptionListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String output = UDWizardPnl.this.m_udDescription.getText();
            UDWizardPnl.this.m_controller.setUDDescription(output);
        }
    }

    private class OutputDictionaryListener
    implements DocumentListener {
        private OutputDictionaryListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String output = UDWizardPnl.this.m_outputUD.getText();
            UDWizardPnl.this.m_controller.setOutputFile(output);
            UDWizardPnl.this.updateUserMessage();
            UDWizardPnl.this.m_udgui.updateButtonPanel();
        }
    }

    private class AddressDictInputListener
    implements DocumentListener {
        private AddressDictInputListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String input = UDWizardPnl.this.m_addressDictInput.getText();
            UDWizardPnl.this.m_controller.setAddressDictionary(input);
            UDWizardPnl.this.updateUserMessage();
            UDWizardPnl.this.m_udgui.updateButtonPanel();
        }
    }

    private class TableInputListener
    implements DocumentListener {
        private TableInputListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String input = UDWizardPnl.this.m_tableInput.getText();
            UDWizardPnl.this.m_controller.setInputTable(input);
            UDWizardPnl.this.updateUserMessage();
            UDWizardPnl.this.m_udgui.updateButtonPanel();
        }
    }

    private class ColumnComboListener
    implements ItemListener {
        private ColumnComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String key = ((JComboBox)e.getSource()).getName();
                String value = (String)e.getItem();
                UDWizardPnl.this.m_controller.setColumnMap(key, value);
                UDWizardPnl.this.updateUserMessage();
                UDWizardPnl.this.m_udgui.updateButtonPanel();
            }
        }
    }

    private class CountryListener
    implements ItemListener {
        private CountryListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String input = (String)UDWizardPnl.this.m_countryInput.getSelectedItem();
                UDWizardPnl.this.m_controller.setCountryCode(input);
                UDWizardPnl.this.updateUserMessage();
                UDWizardPnl.this.m_udgui.updateButtonPanel();
            }
        }
    }
}

