/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud.multipledata;

import com.mapinfo.mapmarker.common.dp.PhaseProgressBounds;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBoundsProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.DependentFileCopier;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.IMultipleThreadProgressUpdator;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.MultipleDataCreatorUtil;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.MultipleUDStreetDataWorker;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.UDSac2FnCombiner;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.WorkerOutPut;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class MultipleDataCreationManager {
    public void createData(List<Properties> propertySet, IMultipleThreadProgressUpdator progressUpdater) throws DataCreationException {
        String soruceGeoInfoPath = null;
        String sourceStreetPath = null;
        ArrayList<File> tempSac2fnFilePathList = new ArrayList<File>();
        ArrayList<String> tempSac2fnFileList = new ArrayList<String>();
        int mainValue = 100 / propertySet.size();
        int firstCut = mainValue * 40 / 100;
        int secondCut = mainValue * 40 / 100;
        int finalCut = mainValue * 20 / 100;
        int firstAndSec = firstCut + secondCut;
        int firSecFinal = firstCut + secondCut + finalCut;
        try {
            for (int i = 0; i < propertySet.size(); ++i) {
                PhaseProgressBoundsProvider provider;
                Properties properties = propertySet.get(i);
                if (i == 0) {
                    provider = PhaseProgressBoundsProvider.getInstance();
                    provider.addBounds(0, new PhaseProgressBounds(firSecFinal * i, firstCut));
                    provider.addBounds(1, new PhaseProgressBounds(firstCut + 1, firstAndSec));
                    provider.addBounds(2, new PhaseProgressBounds(firstAndSec + 1, firSecFinal));
                } else {
                    provider = PhaseProgressBoundsProvider.getInstance();
                    provider.addBounds(0, new PhaseProgressBounds(firSecFinal * i + 1, firstCut + firSecFinal * i));
                    provider.addBounds(1, new PhaseProgressBounds(firstCut + firSecFinal * i + 1, firstCut + firSecFinal * i + firstCut));
                    if (i == propertySet.size() - 1) {
                        provider.addBounds(2, new PhaseProgressBounds(firstCut + firSecFinal * i + firstCut + 1, 100));
                    } else {
                        provider.addBounds(2, new PhaseProgressBounds(firstCut + firSecFinal * i + firstCut + 1, firstCut + firSecFinal * i + firstCut + finalCut));
                    }
                }
                MultipleUDStreetDataWorker worker = new MultipleUDStreetDataWorker(properties);
                WorkerOutPut output = worker.call();
                soruceGeoInfoPath = output.getGeoInfoSourcePath();
                sourceStreetPath = output.getStreetSourcePath();
                tempSac2fnFilePathList.add(output.getTempStreetPath());
                tempSac2fnFileList.add(output.getTempSac2fnPath());
            }
        }
        catch (IOException e) {
            System.err.print("Error creating data");
            System.exit(-1);
        }
        UDSac2FnCombiner sac2fnCombiner = new UDSac2FnCombiner();
        sac2fnCombiner.combineSac2fns(tempSac2fnFileList, sourceStreetPath);
        tempSac2fnFileList = null;
        progressUpdater.update(progressUpdater.getProgress() + 10);
        for (File output : tempSac2fnFilePathList) {
            try {
                FileUtils.deleteDirectory((File)output);
            }
            catch (IOException e) {
                System.err.println("Some file is locked and hence cannot delete the intermediate files");
            }
        }
        try {
            DependentFileCopier fileCopier = new DependentFileCopier();
            fileCopier.copyDependentFile(MultipleDataCreatorUtil.getFinalCopyFilesList(soruceGeoInfoPath), soruceGeoInfoPath, sourceStreetPath);
        }
        catch (IOException e) {
            throw new DataCreationException(e.getLocalizedMessage());
        }
        System.out.println("Data Created");
    }
}

