/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud.multipledata;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.UDDataCreator;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.DependentFileCopier;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.MultipleDataCreatorUtil;
import com.mapinfo.mapmarker.common.dp.gui.ud.multipledata.WorkerOutPut;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;

public class MultipleUDStreetDataWorker
implements Callable<WorkerOutPut> {
    private Properties _properteis;
    private UDDataCreator _udDataCreator;

    public MultipleUDStreetDataWorker(Properties props) {
        this._properteis = props;
        this._udDataCreator = new UDDataCreator();
    }

    @Override
    public WorkerOutPut call() throws IOException, DataCreationException {
        String geoinfoPath = this._properteis.getProperty("dataSetPath");
        String streetDataName = this._properteis.getProperty("street_outputFile");
        String streetDataPath = this._properteis.getProperty("street_outputFilePath");
        String geoinfoDataName = this._properteis.getProperty("geoInfo_outputFile");
        String postinfoDataName = this._properteis.getProperty("postInfo_outputFile");
        String[] geoinfoFiles = MultipleDataCreatorUtil.getDependentFilesList(geoinfoPath, geoinfoDataName, postinfoDataName);
        String tempFileLocation = streetDataPath + "/" + streetDataName;
        File streetTempfileLocation = new File(tempFileLocation);
        if (!streetTempfileLocation.exists()) {
            streetTempfileLocation.mkdir();
        } else {
            FileUtils.deleteDirectory((File)streetTempfileLocation);
            streetTempfileLocation.mkdir();
        }
        String tempGeoinfoPath = tempFileLocation + "/temp";
        File tempGeoinfoFilePath = new File(tempGeoinfoPath);
        tempGeoinfoFilePath.mkdir();
        DependentFileCopier fileCopier = new DependentFileCopier();
        fileCopier.copyDependentFile(geoinfoFiles, geoinfoPath, tempGeoinfoPath);
        this._properteis.setProperty("dataSetPath", tempGeoinfoPath);
        this._properteis.setProperty("street_outputFilePath", tempFileLocation);
        this._properteis.setProperty("geo2sac_outputFilePath", tempFileLocation);
        this._properteis.setProperty("post2sac_outputFilePath", tempFileLocation);
        this._properteis.setProperty("geoInfo_outputFilePath", tempFileLocation);
        this._properteis.setProperty("postInfo_outputFilePath", tempFileLocation);
        this._udDataCreator.runProcess(this._properteis);
        String[] addressFiles = MultipleDataCreatorUtil.getStreetFilesList(tempFileLocation, streetDataName);
        fileCopier.copyDependentFile(addressFiles, tempFileLocation, streetDataPath);
        return new WorkerOutPut(streetTempfileLocation, geoinfoPath, streetDataPath, streetTempfileLocation + "/sac2fn_ud.mmj");
    }
}

