/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud.multipledata;

import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacFileData;
import com.mapinfo.mapmarker.utils.IntObjMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

public class UDSac2FnCombiner {
    private static int FAKE_SAC = Integer.MAX_VALUE;
    public static RandomAccessFile combinedFile;
    public static RandomAccessFile inputFile;
    private static final String COMBINEDFILE_NAME = "sac2fn_ud.mmj";

    public static void createOutputFile(String combinedFilePath) throws IOException {
        String combinedFileName = combinedFilePath + "/" + COMBINEDFILE_NAME;
        File fileRef = new File(combinedFileName);
        if (fileRef.exists() && !fileRef.delete()) {
            System.err.println("FATAL ERROR: Unable to remove old sac2fn file.");
            System.exit(1);
        }
        combinedFile = new RandomAccessFile(combinedFileName, "rw");
    }

    public static void openInputFile(String inputFileName) throws IOException {
        inputFile = new RandomAccessFile(inputFileName, "r");
    }

    public static void usage() {
        System.out.println("MMJSac2FnCombiner <list of sac2fn files>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void combineSac2fns(List<String> sac2fnFiles, String combinedFilePath) {
        int numSac2FnFiles = sac2fnFiles.size();
        if (numSac2FnFiles == 0) {
            UDSac2FnCombiner.usage();
            System.exit(1);
        }
        try {
            UDSac2FnCombiner.createOutputFile(combinedFilePath);
        }
        catch (IOException IOEx) {
            System.err.println("FATAL ERROR: Unable to create sac2fn.mmj.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        IntObjMap sac2fnMap = new IntObjMap();
        int i = 0;
        while (true) {
            if (i < numSac2FnFiles) {
                try {
                    UDSac2FnCombiner.openInputFile(sac2fnFiles.get(i));
                }
                catch (FileNotFoundException fne) {
                    String sac2fnPath = "";
                    try {
                        sac2fnPath = sac2fnFiles.get(i);
                        sac2fnPath = sac2fnPath.replace(".mmj", "_ap.mmj");
                        UDSac2FnCombiner.openInputFile(sac2fnPath);
                    }
                    catch (IOException IOEx) {
                        System.err.println("FATAL ERROR: Unable to open input file -- " + sac2fnPath);
                        System.err.println(IOEx.getMessage());
                        IOEx.printStackTrace(System.err);
                        System.exit(1);
                    }
                }
                catch (IOException IOEx) {
                    System.err.println("FATAL ERROR: Unable to open input file -- " + sac2fnFiles.get(i));
                    System.err.println(IOEx.getMessage());
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                }
            } else {
                try {
                    combinedFile.close();
                    return;
                }
                catch (IOException IOEx) {
                    System.err.println("FATAL ERROR: Unable to close sac2fn.mmj");
                    System.err.println(IOEx.getMessage());
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                }
                return;
            }
            while (true) {
                try {
                    while (true) {
                        MMJSac2FnRecord record;
                        SacFileData previousData;
                        if ((previousData = (SacFileData)sac2fnMap.get((record = MMJSac2FnRecord.read((DataInput)inputFile)).getSac())) != null) {
                            String errorMessage = "SAC: " + record.getSac() + " being added for file: " + record.getData().getStreetFileName() + " was already present for " + previousData.getStreetFileName();
                            System.err.println("ERROR: " + errorMessage);
                        }
                        if (FAKE_SAC == record.getSac()) continue;
                        sac2fnMap.put(record.getSac(), (Object)record.getData());
                        record.write((DataOutput)combinedFile);
                    }
                }
                catch (EOFException EOFEx) {
                    try {
                        inputFile.close();
                    }
                    catch (IOException IOEx) {
                        System.err.println("ERROR: Unable to close input file: " + sac2fnFiles.get(i));
                        System.err.println(IOEx.getMessage());
                        IOEx.printStackTrace(System.err);
                        continue;
                    }
                }
                catch (IOException IOEx) {
                    System.err.println("FATAL ERROR: Error reading or writing sac2fn record from: " + sac2fnFiles.get(i));
                    System.err.println(IOEx.getMessage());
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                    continue;
                }
                break;
            }
            ++i;
        }
    }
}

