/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.jni;

import com.mapinfo.mapmarker.common.dp.IProgressBarUpdater;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBounds;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBoundsProvider;
import com.mapinfo.mapmarker.common.dp.ProgressBarUpdaterProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.UDDataCreator;
import com.mapinfo.mapmarker.jni.ProgressBarUpdater;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Set;

public class JNI_UserDictionary {
    private String m_country;
    private String m_dataSetPath;
    private String m_inputTabFile;
    private String m_outputDir;
    private String m_outputStreetBase;
    private String[] m_settings;
    private Properties m_udProps;
    private PrintStream m_statusStream;
    private PrintStream m_errorStream;
    private PrintStream m_internalErrorStream;

    public static JNI_UserDictionary getInstance(String country) {
        try {
            return (JNI_UserDictionary)Class.forName("com.mapinfo.mapmarker." + country + ".jni." + country + "_JNI_UserDictionary").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return new JNI_UserDictionary(country);
    }

    protected JNI_UserDictionary(String country) {
        this.m_country = country;
        this.m_udProps = new Properties();
        this.m_udProps.setProperty("COUNTRY", this.m_country);
    }

    public void init(String dataSetPath, String inputTabFile, String outputDir, String outputStreetBase, int startRow, int endRow, String[] settings) {
        this.m_dataSetPath = dataSetPath;
        this.m_udProps.setProperty("dataSetPath", this.m_dataSetPath);
        this.m_inputTabFile = inputTabFile;
        this.m_udProps.setProperty("street_inputTable", this.m_inputTabFile);
        this.m_outputDir = outputDir;
        this.m_udProps.setProperty("street_outputFilePath", this.m_outputDir);
        this.m_udProps.setProperty("geo2sac_outputFilePath", this.m_outputDir);
        this.m_udProps.setProperty("post2sac_outputFilePath", this.m_outputDir);
        this.m_outputStreetBase = outputStreetBase;
        this.m_udProps.setProperty("street_outputFile", this.m_outputStreetBase);
        this.m_udProps.setProperty("startRow", String.valueOf(startRow));
        this.m_udProps.setProperty("endRow", String.valueOf(endRow));
        this.m_udProps.setProperty("street_create", "YES");
        this.m_settings = settings;
        this.setColumnProps();
        this.setSettings();
    }

    public void createData() throws DataCreationException {
        this.verifySettings();
        this.setupProgressBounds();
        ProgressBarUpdaterProvider.assignProgressBarUpdater((IProgressBarUpdater)new ProgressBarUpdater());
        UDDataCreator creator = new UDDataCreator();
        try {
            this.setupLoggers();
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                this.logProperties();
            }
            creator.runProcess(this.m_udProps);
        }
        finally {
            ProgressBarUpdaterProvider.getUpdaterInstance().update(100);
            this.closeLoggers();
        }
    }

    protected Properties getUDProperties() {
        return this.m_udProps;
    }

    protected void logProperties() {
        this.m_statusStream.println("--- user dictionary properties ---");
        Set<Object> keys = this.m_udProps.keySet();
        for (String string : keys) {
            Object value = this.m_udProps.get(string);
            if (!(value instanceof String)) continue;
            this.m_statusStream.println(string + "=" + value);
        }
        this.m_statusStream.println("--- end of properties ---");
    }

    protected String getColumnString(int index) {
        if (this.m_settings.length <= index) {
            return "NONE";
        }
        String value = this.m_settings[index];
        if (value == null) {
            return "NONE";
        }
        return value;
    }

    protected String getSettingString(int index) {
        if (this.m_settings.length <= index) {
            return null;
        }
        return this.m_settings[index];
    }

    protected void setColumnProps() {
        this.m_udProps.setProperty("street_mainAddress", this.getColumnString(0));
        this.m_udProps.setProperty("street_leftPostCode1", this.getColumnString(1));
        this.m_udProps.setProperty("street_leftPostCode2", this.getColumnString(2));
        this.m_udProps.setProperty("street_rightPostCode1", this.getColumnString(3));
        this.m_udProps.setProperty("street_rightPostCode2", this.getColumnString(4));
        this.m_udProps.setProperty("street_leftAreaName1", this.getColumnString(5));
        this.m_udProps.setProperty("street_leftAreaName2", this.getColumnString(7));
        this.m_udProps.setProperty("street_leftAreaName3", this.getColumnString(9));
        this.m_udProps.setProperty("street_leftAreaName4", this.getColumnString(11));
        this.m_udProps.setProperty("street_rightAreaName1", this.getColumnString(6));
        this.m_udProps.setProperty("street_rightAreaName2", this.getColumnString(8));
        this.m_udProps.setProperty("street_rightAreaName3", this.getColumnString(10));
        this.m_udProps.setProperty("street_rightAreaName4", this.getColumnString(12));
        this.m_udProps.setProperty("street_fromLeft", this.getColumnString(13));
        this.m_udProps.setProperty("street_toLeft", this.getColumnString(14));
        this.m_udProps.setProperty("street_leftRangeStatus", this.getColumnString(15));
        this.m_udProps.setProperty("street_leftPlaceName", this.getColumnString(16));
        this.m_udProps.setProperty("street_fromRight", this.getColumnString(17));
        this.m_udProps.setProperty("street_toRight", this.getColumnString(18));
        this.m_udProps.setProperty("street_rightRangeStatus", this.getColumnString(19));
        this.m_udProps.setProperty("street_rightPlaceName", this.getColumnString(20));
    }

    protected void setSettings() {
    }

    protected void verifySettings() throws DataCreationException {
    }

    protected void setupProgressBounds() {
        PhaseProgressBoundsProvider provider = PhaseProgressBoundsProvider.getInstance();
        provider.addBounds(0, new PhaseProgressBounds(0, 40));
        provider.addBounds(1, new PhaseProgressBounds(41, 80));
        provider.addBounds(2, new PhaseProgressBounds(81, 100));
    }

    protected void setupLoggers() throws DataCreationException {
        this.m_udProps.setProperty("logFiles", "true");
        this.m_udProps.setProperty("useConsole", "true");
        try {
            this.m_statusStream = new PrintStream(new FileOutputStream(StringUtilities.appendToPath((String)this.m_outputDir, (String)this.m_outputStreetBase, (String)".log")));
            this.m_udProps.put("statusLog", this.m_statusStream);
            this.m_errorStream = new PrintStream(new FileOutputStream(StringUtilities.appendToPath((String)this.m_outputDir, (String)this.m_outputStreetBase, (String)".err")));
            this.m_udProps.put("errorLog", this.m_errorStream);
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                this.m_internalErrorStream = new PrintStream(new FileOutputStream(StringUtilities.appendToPath((String)this.m_outputDir, (String)this.m_outputStreetBase, (String)".irr")));
                this.m_udProps.put("internalErrorLog", this.m_internalErrorStream);
            }
        }
        catch (IOException IOEx) {
            throw new DataCreationException(-1);
        }
    }

    protected void closeLoggers() {
        if (this.m_statusStream != null) {
            this.m_statusStream.flush();
            this.m_statusStream.close();
        }
        if (this.m_errorStream != null) {
            this.m_errorStream.flush();
            this.m_errorStream.close();
        }
        if (this.m_internalErrorStream != null) {
            this.m_internalErrorStream.flush();
            this.m_internalErrorStream.close();
        }
    }
}

