/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.AbstractDataHandler;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.TempDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractStreetDataHandler
extends AbstractDataHandler {
    private MMJStreetRecordComparator m_streetComparator;
    private MMJSegmentComparer m_segmentComparer;
    private List m_streetRecords;
    private Iterator m_streetRecordsIterator;
    private MMJStreetRecord m_lastStreetRecord;

    public AbstractStreetDataHandler(IDataSource dataSourceAccess, IDataSourceRecordConvertor dataConvertor, IIntermediateDataHandler intermediateHandler, MMJStreetRecordComparator streetComparator, MMJSegmentComparer segmentComparer, ITempDataRecordHandler tempHandler) {
        super(dataSourceAccess, dataConvertor, intermediateHandler, tempHandler);
        this.m_streetComparator = streetComparator;
        this.m_segmentComparer = segmentComparer;
    }

    @Override
    public Object getNextDataRecord() throws DataCreationException {
        MultiSegmentStreet street = null;
        if (this.m_lastStreetRecord != null) {
            street = this.makeMultiSegmentStreet(this.m_lastStreetRecord);
            this.m_lastStreetRecord = null;
        } else {
            try {
                this.m_streetRecords = this.getNextDataRecords();
            }
            catch (DataSourceException DSEx) {
                throw this.makeDataCreationException(DSEx);
            }
            if (this.m_streetRecords == null) {
                return null;
            }
            this.sortStreetRecords(this.m_streetRecords);
            this.m_streetRecordsIterator = this.m_streetRecords.iterator();
        }
        while (this.m_streetRecordsIterator.hasNext()) {
            MMJStreetRecord record = (MMJStreetRecord)this.m_streetRecordsIterator.next();
            this.m_streetRecordsIterator.remove();
            if (street == null) {
                street = this.makeMultiSegmentStreet(record);
                continue;
            }
            if (street.areSameStreet(record)) {
                street.addSegment(record.getSegment());
                continue;
            }
            this.m_lastStreetRecord = record;
            return street;
        }
        return street;
    }

    protected MMJStreetRecordComparator getStreetRecordComparator() {
        return this.m_streetComparator;
    }

    protected MMJSegmentComparer getSegmentComparer() {
        return this.m_segmentComparer;
    }

    protected void sortStreetRecords(List streetRecords) {
        if (this.getStreetRecordComparator() != null) {
            Collections.sort(streetRecords, this.getStreetRecordComparator());
        }
    }

    protected MultiSegmentStreet makeMultiSegmentStreet(MMJStreetRecord street) {
        MultiSegmentStreet multiStreet = new MultiSegmentStreet(street, this.getSegmentComparer());
        return multiStreet;
    }

    @Override
    protected TempDataRecord makeTempDataRecord(Object street, IDataRecordID ID) {
        return new TempDataRecord(((MMJStreetRecord)street).getKey(), ID);
    }

    @Override
    protected void replaceDataFromTempDataRecord(Object o, TempDataRecord temp) {
        MMJStreetRecord street = (MMJStreetRecord)o;
        street.setKey(temp.getRecordKey());
    }
}

