/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.ICentroidDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.INamedFieldDataSourceRecord;
import com.mapinfo.midev.geometry.DirectPosition;

public class CentroidDataSourceRecordImpl
implements ICentroidDataSourceRecord {
    private final INamedFieldDataSourceRecord m_record;
    private final String m_precisionFieldKey;
    private final String m_useCentroidFieldKey;

    public CentroidDataSourceRecordImpl(INamedFieldDataSourceRecord record, String precisionFieldKey, String useCentroidFieldKey) {
        this.m_record = record;
        this.m_precisionFieldKey = precisionFieldKey;
        this.m_useCentroidFieldKey = useCentroidFieldKey;
    }

    @Override
    public boolean hasPrecision() throws DataSourceException {
        return this.m_record.hasField(this.m_precisionFieldKey);
    }

    @Override
    public int getPrecision() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_precisionFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldIntValue(fieldName);
        }
        return 0;
    }

    @Override
    public boolean hasCentroid() throws DataSourceException {
        return !this.m_record.hasField(this.m_useCentroidFieldKey) || "YES".equals(this.m_record.getFieldName(this.m_useCentroidFieldKey));
    }

    @Override
    public DirectPosition getCentroid() throws DataSourceException {
        DirectPosition centroid = this.m_record.getRecordPoint();
        if (centroid == null) {
            throw new DataSourceException(8);
        }
        return centroid;
    }
}

