/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.AbstractDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import java.util.Properties;

public class GeoInfoDataSourceRecordConvertorImpl
extends AbstractDataSourceRecordConvertor {
    public GeoInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    @Override
    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IGeoInfoDataSourceRecord input = (IGeoInfoDataSourceRecord)inputData;
        GeoInfoRecord baseRecord = null;
        try {
            baseRecord = this.makeGeoInfoRecord(input);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(301, (Throwable)DSEx);
        }
        if (baseRecord == null) {
            return null;
        }
        MapMarkerIndexKey key = this.makeGeoInfoKey(baseRecord);
        if (key == null) {
            return null;
        }
        return new MMJGeoInfoRecord(baseRecord, key);
    }

    protected MapMarkerIndexKey makeGeoInfoKey(GeoInfoRecord record) {
        MiStringIndexKey key = new MiStringIndexKey((record.getAreaName1() != null ? record.getAreaName1() : "") + (record.getAreaName2() != null ? record.getAreaName2() : "") + (record.getAreaName3() != null ? record.getAreaName3() : "") + (record.getAreaName4() != null ? record.getAreaName4() : ""));
        return key;
    }

    protected byte convertGeoInfoPrecisionToByteValue(int precision) {
        return (byte)precision;
    }

    protected GeoInfoRecord makeGeoInfoRecordType() {
        return new GeoInfoRecord();
    }

    protected GeoInfoRecord makeGeoInfoRecord(IGeoInfoDataSourceRecord input) throws DataSourceException {
        GeoInfoRecord record = this.makeGeoInfoRecordType();
        if (input.hasAreaName1() && this.stringExists(input.getAreaName1())) {
            record.setAreaName1(input.getAreaName1());
        }
        if (input.hasAreaName2() && this.stringExists(input.getAreaName2())) {
            record.setAreaName2(input.getAreaName2());
        }
        if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
            record.setAreaName3(input.getAreaName3());
        }
        if (input.hasAreaName4() && this.stringExists(input.getAreaName4())) {
            record.setAreaName4(input.getAreaName4());
        }
        if (input.hasAlternateAreaName1() && this.stringExists(input.getAlternateAreaName1())) {
            record.setAltAreaName1(input.getAlternateAreaName1());
        }
        if (input.hasAlternateAreaName2() && this.stringExists(input.getAlternateAreaName2())) {
            record.setAltAreaName2(input.getAlternateAreaName2());
        }
        if (input.hasAlternateAreaName3() && this.stringExists(input.getAlternateAreaName3())) {
            record.setAltAreaName3(input.getAlternateAreaName3());
        }
        if (input.hasAlternateAreaName4() && this.stringExists(input.getAlternateAreaName4())) {
            record.setAltAreaName4(input.getAlternateAreaName4());
        }
        if (input.hasCentroid()) {
            record.setPoint(input.getCentroid());
        }
        if (input.hasPrecision()) {
            record.setPrecision(this.convertGeoInfoPrecisionToByteValue(input.getPrecision()));
        }
        return record;
    }
}

