/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.InvalidRangeStatusDataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;

public class HNRSConverter {
    public static final int HNRS_NO_RANGE_1 = 0;
    public static final int HNRS_NO_RANGE_2 = 1;
    public static final int HNRS_EVEN = 2;
    public static final int HNRS_ODD = 3;
    public static final int HNRS_NUMERIC_MIXED = 4;
    public static final int HNRS_IRREGULAR = 5;
    public static final int HNRS_ALPHANUMERIC_MIXED = 6;
    private final boolean m_bLogStructErrors;

    public HNRSConverter(boolean bLogStructErrors) {
        this.m_bLogStructErrors = bLogStructErrors;
    }

    public int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        int statusValue;
        if (!input.hasStatus()) {
            throw new DataSourceException(9, "No status field given for range, check data processing properties.");
        }
        try {
            statusValue = Integer.parseInt(input.getStatus());
        }
        catch (NumberFormatException NFEx) {
            throw new DataSourceException(5, "Unable to convert: " + input.getStatus() + " into an int", (Throwable)NFEx);
        }
        switch (statusValue) {
            case 0: 
            case 1: {
                if (this.m_bLogStructErrors) {
                    try {
                        DataCreationLogger.getLogger().logInternalError("Input specified status as 'HNRS_NO_RANGE' but a valid range was found.  Range will be treated as ODD_EVEN_BOTH");
                        DataCreationLogger.getLogger().logInternalError("status=" + input.getStatus() + ", isLeft=" + input.isLeft() + ", from=" + input.getFrom() + ", to=" + input.getTo());
                        DataCreationLogger.getLogger().logInternalError("");
                    }
                    catch (DataSourceException dataSourceException) {
                        // empty catch block
                    }
                }
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 0;
            }
        }
        throw new InvalidRangeStatusDataSourceException(17, "The range will not be added as the range contains an unsupportedStruct field " + statusValue);
    }
}

