/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.AbstractDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IPost2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import java.util.Properties;

public class Post2SacDataSourceRecordConvertorImpl
extends AbstractDataSourceRecordConvertor {
    public Post2SacDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    @Override
    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IPost2SacDataSourceRecord input = (IPost2SacDataSourceRecord)inputData;
        MMJPost2SacRecord record = null;
        try {
            if (!input.hasSac()) {
                DataCreationLogger.getLogger().logInternalError("AbstractDataSourceRecordConvertor:: convertPost2Sac(): data source record must have sac field.");
                return null;
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(801, (Throwable)DSEx);
        }
        IPostalBase[] postalBases = null;
        try {
            postalBases = this.makePostalBases(input);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(801, (Throwable)DSEx);
        }
        if (postalBases == null) {
            DataCreationLogger.getLogger().logInternalError("AbstractDataSourceRecordConvertor:: convertPost2Sac(): no postalBases created from input.");
            return null;
        }
        if (postalBases.length == 1) {
            this.m_dataRecords = null;
            this.m_nextDataRecordIndex = -1;
            try {
                return this.makePost2SacRecord(input.getSac(), postalBases[0]);
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(801, (Throwable)DSEx);
            }
        }
        this.m_dataRecords = new Object[postalBases.length - 1];
        for (int i = 1; i < postalBases.length; ++i) {
            try {
                this.m_dataRecords[i - 1] = this.makePost2SacRecord(input.getSac(), postalBases[i]);
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(801, (Throwable)DSEx);
            }
            postalBases[i] = null;
        }
        try {
            record = this.makePost2SacRecord(input.getSac(), postalBases[0]);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(801, (Throwable)DSEx);
        }
        this.m_nextDataRecordIndex = 0;
        return record;
    }

    protected MMJPost2SacRecord makePost2SacRecord(int sac, IPostalBase base) {
        return new StandardPost2SacRecord(sac, base);
    }

    protected IPostalBase[] makePostalBases(IPost2SacDataSourceRecord input) throws DataSourceException {
        IPostalBase[] bases = new IPostalBase[1];
        if (!input.hasPostCode1() || !this.stringExists(input.getPostCode1())) {
            DataCreationLogger.getLogger().logInternalError("AbstractDataSourceRecordConvertor:: makePostalBases(): data source record must have postCode1 field.");
            return null;
        }
        bases[0] = new StandardPostalBase(input.getPostCode1());
        return bases;
    }
}

