/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.AbstractDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IAdditionalFieldsDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.InvalidRangeStatusDataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacData;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacData;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.common.dp.binary.StandardGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.UserDictSacData;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateRangeDataSourceRecord;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class StreetDataSourceRecordConvertorImpl
extends AbstractDataSourceRecordConvertor {
    protected int NO_SAC = -1;
    protected int FAKE_SAC = Integer.MAX_VALUE;
    protected Soundex m_soundex;
    protected CollationKeyGenerator m_generator;
    protected IParser m_parser;
    protected Constraints m_parserConstraints;
    protected MMJPost2SacData m_post2sac;
    protected MMJGeo2SacData m_geo2sac;
    protected int m_maximumParserRetries;
    protected boolean m_logWrongStructTypeErrors = true;
    protected boolean m_bPointDataSource;

    public StreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(dataProperties);
        String isPointAddressRanges;
        this.m_soundex = soundex;
        this.m_generator = generator;
        this.m_parser = parser;
        this.m_parserConstraints = parserConstraints;
        this.m_post2sac = null;
        this.m_geo2sac = null;
        String dataSetPath = dataProperties.getProperty("dataSetPath");
        if (dataSetPath != null) {
            try {
                this.m_post2sac = new MMJPost2SacData(this.makePost2SacDataRecordType(), new SacMetadata(), dataSetPath);
                this.m_geo2sac = new MMJGeo2SacData(this.makeGeo2SacDataRecordType(), new SacMetadata(), dataSetPath);
            }
            catch (IOException e) {
                throw new DataCreationException(-1, (Throwable)e);
            }
            catch (MMJEDataCorruptedException e) {
                throw new DataCreationException(-1, (Throwable)e);
            }
        }
        if ((isPointAddressRanges = dataProperties.getProperty("pointAddressRanges")) != null) {
            this.m_bPointDataSource = true;
        }
        this.m_maximumParserRetries = 1;
    }

    protected IPostalBase makePostalBase(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String postalBaseString = null;
        if (left && input.hasLeftPostCode1()) {
            postalBaseString = input.getLeftPostCode1();
        } else if (!left && input.hasRightPostCode1()) {
            postalBaseString = input.getRightPostCode1();
        }
        if (postalBaseString != null && postalBaseString.length() > 0) {
            return new StandardPostalBase(postalBaseString);
        }
        return null;
    }

    protected IGeoBase makeGeoBase(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String geoBaseString;
        MiSoundexGeoBase base = null;
        if (left && input.hasLeftAreaName3() && this.stringExists(input.getLeftAreaName3())) {
            base = new MiSoundexGeoBase((MiSoundexKey)this.makeSoundexKey(input.getLeftAreaName3()));
        } else if (!left && input.hasRightAreaName3() && this.stringExists(input.getRightAreaName3())) {
            base = new MiSoundexGeoBase((MiSoundexKey)this.makeSoundexKey(input.getRightAreaName3()));
        }
        if (base != null && (geoBaseString = base.toString()).length() > 0) {
            return new StandardGeoBase(geoBaseString);
        }
        return null;
    }

    protected int getSacFromPost2Sac(IStreetDataSourceRecord input, boolean left) throws DataSourceException {
        IPostalBase base = this.makePostalBase(input.getSegment(), left);
        if (base == null) {
            return this.NO_SAC;
        }
        return this.getPost2Sac(base);
    }

    protected int[] getSacsFromGeo2Sac(IStreetDataSourceRecord input, boolean left) throws DataSourceException {
        IGeoBase base = this.makeGeoBase(input.getSegment(), left);
        if (base == null) {
            return new int[]{this.NO_SAC};
        }
        return this.getGeo2Sac(base);
    }

    protected int getPost2Sac(IPostalBase base) {
        SacData o = this.m_post2sac.getSacForPostalBase(base);
        UserDictSacData sacData = null;
        if (o != null) {
            sacData = new UserDictSacData(o);
        }
        if (sacData == null) {
            return this.FAKE_SAC;
        }
        int[] sacs = sacData.getSacs();
        if (sacs == null || sacs.length != 1) {
            return this.FAKE_SAC;
        }
        return sacs[0];
    }

    protected int[] getGeo2Sac(IGeoBase base) {
        SacData o = this.m_geo2sac.getSacForGeoBase(base);
        UserDictSacData sacData = null;
        if (o != null) {
            sacData = new UserDictSacData(o);
        }
        if (sacData == null) {
            DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: No sac data found.");
            return new int[]{this.FAKE_SAC};
        }
        int[] sacs = sacData.getSacs();
        if (sacs == null || sacs.length == 0) {
            return new int[]{this.FAKE_SAC};
        }
        int[] intSacs = new int[sacs.length];
        for (int i = 0; i < sacs.length; ++i) {
            intSacs[i] = sacs[i];
        }
        return intSacs;
    }

    private int[] getFinalSacs(int sacFromPost2Sac, int[] sacsFromGeo2Sac) {
        if (sacFromPost2Sac != this.NO_SAC) {
            for (int i = 0; i < sacsFromGeo2Sac.length; ++i) {
                if (sacFromPost2Sac != sacsFromGeo2Sac[i]) continue;
                return new int[]{sacFromPost2Sac};
            }
            if (sacsFromGeo2Sac[0] != this.NO_SAC) {
                return new int[]{sacFromPost2Sac, sacsFromGeo2Sac[0]};
            }
            return new int[]{sacFromPost2Sac};
        }
        if (sacsFromGeo2Sac[0] != this.NO_SAC) {
            return new int[]{sacsFromGeo2Sac[0]};
        }
        return new int[]{this.NO_SAC};
    }

    protected int[] getLeftSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] sacsFromGeo2Sac;
        int sacFromPost2Sac;
        try {
            if (input.hasLeftSAC()) {
                return new int[]{input.getLeftSAC()};
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        try {
            sacFromPost2Sac = this.getSacFromPost2Sac(input, true);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        try {
            sacsFromGeo2Sac = this.getSacsFromGeo2Sac(input, true);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        return this.getFinalSacs(sacFromPost2Sac, sacsFromGeo2Sac);
    }

    protected int[] getRightSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] sacsFromGeo2Sac;
        int sacFromPost2Sac;
        try {
            if (input.hasRightSAC()) {
                return new int[]{input.getRightSAC()};
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        try {
            sacFromPost2Sac = this.getSacFromPost2Sac(input, false);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        try {
            sacsFromGeo2Sac = this.getSacsFromGeo2Sac(input, false);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        return this.getFinalSacs(sacFromPost2Sac, sacsFromGeo2Sac);
    }

    protected MMJPost2SacRecord makePost2SacDataRecordType() {
        return new StandardPost2SacRecord();
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new StandardGeo2SacRecord();
    }

    private int getNumberOfNonNoSacs(int[] sacs) {
        if (sacs == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < sacs.length; ++i) {
            if (sacs[i] == this.NO_SAC) continue;
            ++count;
        }
        return count;
    }

    private int[] getCommonSacs(int[] leftSacs, int[] rightSacs) {
        int[] finalCommonSacs;
        int[] tempCommonSacs = leftSacs.length < rightSacs.length ? new int[leftSacs.length] : new int[rightSacs.length];
        for (int i = 0; i < tempCommonSacs.length; ++i) {
            tempCommonSacs[i] = this.NO_SAC;
        }
        int commonIndex = 0;
        boolean foundCommon = false;
        for (int l = 0; l < leftSacs.length; ++l) {
            for (int r = 0; r < rightSacs.length; ++r) {
                if (leftSacs[l] != rightSacs[r] || leftSacs[l] == this.NO_SAC) continue;
                foundCommon = true;
                tempCommonSacs[commonIndex] = leftSacs[l];
                ++commonIndex;
                leftSacs[l] = rightSacs[r] = this.NO_SAC;
            }
        }
        if (foundCommon) {
            int commonCount = 0;
            int totalCommonSacs = this.getNumberOfNonNoSacs(tempCommonSacs);
            finalCommonSacs = new int[totalCommonSacs];
            for (int i = 0; i < tempCommonSacs.length; ++i) {
                if (tempCommonSacs[i] == this.NO_SAC) continue;
                finalCommonSacs[commonCount] = tempCommonSacs[i];
                ++commonCount;
            }
        } else {
            return null;
        }
        return finalCommonSacs;
    }

    @Override
    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        int i;
        boolean useAlternate;
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IStreetDataSourceRecord input = (IStreetDataSourceRecord)inputData;
        List addressList = null;
        try {
            if (!input.hasMainAddress() || !this.stringExists(input.getMainAddress())) {
                DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: All streets should have main addresses.");
                return null;
            }
            addressList = this.getAllPossibleMainAddresses(input);
            if (addressList == null || addressList.size() == 0) {
                DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: No main adddress found.");
                return null;
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        int[] leftSacs = this.getLeftSacs(input);
        int[] rightSacs = this.getRightSacs(input);
        int[] commonSacs = this.getCommonSacs(leftSacs, rightSacs);
        int uniqueLeftSacs = this.getNumberOfNonNoSacs(leftSacs);
        int uniqueRightSacs = this.getNumberOfNonNoSacs(rightSacs);
        int uniqueCommonSacs = this.getNumberOfNonNoSacs(commonSacs);
        int uniqueSacs = uniqueLeftSacs + uniqueRightSacs + uniqueCommonSacs;
        if (uniqueSacs == 0) {
            DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: No unique sacs on either side of the street.");
            return null;
        }
        boolean bl = useAlternate = addressList.size() > 1;
        if (uniqueSacs == 1 && !useAlternate) {
            this.m_dataRecords = null;
            this.m_nextDataRecordIndex = -1;
        } else {
            this.m_dataRecords = new Object[uniqueSacs * addressList.size() - 1];
        }
        MMJStreetRecord record = null;
        this.m_nextDataRecordIndex = 0;
        int dataRecordsIndex = 0;
        if (commonSacs != null) {
            for (i = 0; i < commonSacs.length; ++i) {
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, commonSacs[i], commonSacs[i]);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, commonSacs[i], commonSacs[i]);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (uniqueLeftSacs > 0) {
            for (i = 0; i < leftSacs.length; ++i) {
                if (leftSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (uniqueRightSacs > 0) {
            for (i = 0; i < rightSacs.length; ++i) {
                if (rightSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, this.NO_SAC, rightSacs[i]);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, this.NO_SAC, rightSacs[i]);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (record != null && useAlternate) {
            try {
                for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                    this.m_dataRecords[uniqueSacs + altNum - 1] = this.createAlternateStreetRecord(record, input, (Address)addressList.get(altNum + 1));
                }
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(101, (Throwable)DSEx);
            }
            for (i = 1; i < uniqueSacs; ++i) {
                try {
                    for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                        this.m_dataRecords[uniqueSacs + i + altNum - 1] = this.createAlternateStreetRecord((MMJStreetRecord)this.m_dataRecords[i + altNum - 1], input, (Address)addressList.get(altNum + 1));
                    }
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        return record;
    }

    protected void assignBrowseKeys(MMJStreetRecord record) throws DataCreationException {
        MapMarkerIndexKey[] browseKeys = this.makeStreetBrowseKeys(record.getAddress(), record.getSac());
        if (browseKeys != null) {
            for (int i = 0; i < browseKeys.length; ++i) {
                record.addBrowseKey(browseKeys[i]);
            }
        }
    }

    protected void populateAlternateDataItems(MMJStreetRecord street, IStreetDataSourceRecord input, int sac) throws DataCreationException, DataSourceException {
    }

    protected MMJStreetRecord makeStreetRecordType() {
        return new MMJStreetRecord();
    }

    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSac, int rightSac) throws DataSourceException, DataCreationException {
        int inputSAC = leftSac != this.NO_SAC ? leftSac : rightSac;
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address parsed = this.getParsedStreet(input, preParsed);
        if (parsed == null) {
            return null;
        }
        MMJStreetRecord record = this.makeStreetRecordType();
        record.setAddress(parsed);
        record.setSac(inputSAC);
        record.setKey(this.makeStreetSearchKey(parsed, inputSAC));
        if (record.getKey() == null) {
            DataCreationLogger.getLogger().logError("Could not generate a search key for address '" + input.getMainAddress() + "'");
            return null;
        }
        this.assignBrowseKeys(record);
        ISegmentDataSourceRecord inputSegment = input.getSegment();
        MMJSegmentRecord segment = this.convertSegmentRecord(inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
        if (segment == null) {
            return null;
        }
        record.setSegment(segment);
        this.addRangesToSegment(segment, inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
        this.populateAlternateDataItems(record, input, inputSAC);
        return record;
    }

    protected MMJStreetRecord createAlternateStreetRecord(MMJStreetRecord standardRecord, IStreetDataSourceRecord input, Address parsed) throws DataCreationException, DataSourceException {
        MMJStreetRecord record = this.makeStreetRecordType();
        record.setSac(standardRecord.getSac());
        record.setAddress(parsed);
        record.setKey(this.makeStreetSearchKey(parsed, record.getSac()));
        this.assignBrowseKeys(record);
        record.setSegment(standardRecord.getSegment());
        this.populateAlternateDataItems(record, input, record.getSac());
        return record;
    }

    protected String makeMainAddressString(String street, String houseNumber) {
        return houseNumber + " " + street;
    }

    protected Address makePreParsedAddress(IStreetDataSourceRecord input) throws DataSourceException {
        AddressImpl address = new AddressImpl();
        if (input.hasGenericField1() && this.stringExists(input.getGenericField1())) {
            address.setGenericField1(input.getGenericField1());
        }
        if (input.hasGenericField2() && this.stringExists(input.getGenericField2())) {
            address.setGenericField2(input.getGenericField2());
        }
        if (input.hasGenericField3() && this.stringExists(input.getGenericField3())) {
            address.setGenericField3(input.getGenericField3());
        }
        if (input.hasGenericField4() && this.stringExists(input.getGenericField4())) {
            address.setGenericField4(input.getGenericField4());
        }
        address.setMainAddress(input.getMainAddress());
        return address;
    }

    protected Address addMainHouseNumber(Address address, String houseNumber) throws DataSourceException {
        address.setMainAddress(this.makeMainAddressString(address.getMainAddress(), houseNumber));
        return address;
    }

    protected boolean validateParse(Address parsed, Address inputAddress, IStreetDataSourceRecord input, boolean useAlternate, String houseNumber) throws DataSourceException {
        if (parsed == null || parsed.getMainAddress() == null) {
            return true;
        }
        char[] mainAddressChars = parsed.getMainAddress().toCharArray();
        for (int i = 0; i < mainAddressChars.length; ++i) {
            if (!Character.isLetterOrDigit(mainAddressChars[i])) continue;
            return true;
        }
        String originalMainAddress = !useAlternate ? input.getMainAddress() : input.getAlternateMainAddress();
        String newMainAddress = StringUtilities.replaceWith((String)originalMainAddress, (String)parsed.getMainAddress(), null);
        if (newMainAddress != null) {
            DataCreationLogger.getLogger().logError("Replacing input street of: " + input.getMainAddress() + " with: " + newMainAddress);
            inputAddress.setMainAddress(this.makeMainAddressString(newMainAddress, houseNumber));
            return false;
        }
        return true;
    }

    protected Address parseStreet(Address input) {
        Address[] parsedAddresses;
        try {
            parsedAddresses = this.m_parser.parse(input, (IConstraints)this.m_parserConstraints);
        }
        catch (ParserException PEx) {
            DataCreationLogger.getLogger().logInternalError("AbstractStreetDataSourceConvertor:: getParsedAddress(): Unable to parse street address: \n" + input.getMainAddress());
            DataCreationLogger.getLogger().logInternalError(PEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace(PEx);
            return null;
        }
        if (parsedAddresses == null || parsedAddresses.length != 1) {
            return null;
        }
        return parsedAddresses[0];
    }

    protected Address getParsedStreet(IStreetDataSourceRecord input, Address inputStreetAddress) throws DataSourceException {
        Address parsedAddress = null;
        boolean validParse = false;
        for (int parserRetries = 0; !validParse && parserRetries <= this.m_maximumParserRetries; ++parserRetries) {
            parsedAddress = this.parseStreet(inputStreetAddress);
            validParse = this.validateParse(parsedAddress, inputStreetAddress, input, false, "100");
        }
        if (parsedAddress == null) {
            DataCreationLogger.getLogger().logInternalError("AbstractStreetDataSourceConvertor:: getParsedAddress(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
            return null;
        }
        if (parsedAddress.getMainAddress() == null) {
            DataCreationLogger.getLogger().logInternalError("AbstractStreetDataSourceConvertor:: getParsedAddress(): \n" + inputStreetAddress.toString() + " \n did not parse properly.");
            return null;
        }
        if (this.stringExists(parsedAddress.getAddressNumber()) && parsedAddress.getAddressNumber().equals("100")) {
            parsedAddress.setAddressNumber((String)null);
            return parsedAddress;
        }
        DataCreationLogger.getLogger().logInternalError("AbstractStreetDataSourceConvertor:: getParsedAddress(): \n" + inputStreetAddress.toString() + " \n did not parse properly.");
        return null;
    }

    protected void populateAlternateDataItems(MMJSegmentRecord segment, ISegmentDataSourceRecord input, int sac) throws DataSourceException {
    }

    protected MMJSegmentRecord makeSegmentRecordType() {
        return new MMJSegmentRecord();
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        if (convertLeft || convertRight) {
            ArrayList points;
            MMJSegmentRecord segment = this.makeSegmentRecordType();
            if (convertLeft) {
                if (input.hasLeftAreaName1() && this.stringExists(input.getLeftAreaName1())) {
                    segment.setLeftAreaName1(input.getLeftAreaName1());
                }
                if (input.hasLeftAreaName2() && this.stringExists(input.getLeftAreaName2())) {
                    segment.setLeftAreaName2(input.getLeftAreaName2());
                }
                if (input.hasLeftAreaName3() && this.stringExists(input.getLeftAreaName3())) {
                    segment.setLeftAreaName3(input.getLeftAreaName3());
                }
                if (input.hasLeftAreaName4() && this.stringExists(input.getLeftAreaName4())) {
                    segment.setLeftAreaName4(input.getLeftAreaName4());
                }
                if (input.hasLeftPostCode1() && this.stringExists(input.getLeftPostCode1())) {
                    segment.setLeftPostalCode1(input.getLeftPostCode1());
                }
                if (input.hasLeftPostCode2() && this.stringExists(input.getLeftPostCode2())) {
                    segment.setLeftPostalCode2(input.getLeftPostCode2());
                }
            }
            if (convertRight) {
                if (input.hasRightAreaName1() && this.stringExists(input.getRightAreaName1())) {
                    segment.setRightAreaName1(input.getRightAreaName1());
                }
                if (input.hasRightAreaName2() && this.stringExists(input.getRightAreaName2())) {
                    segment.setRightAreaName2(input.getRightAreaName2());
                }
                if (input.hasRightAreaName3() && this.stringExists(input.getRightAreaName3())) {
                    segment.setRightAreaName3(input.getRightAreaName3());
                }
                if (input.hasRightAreaName4() && this.stringExists(input.getRightAreaName4())) {
                    segment.setRightAreaName4(input.getRightAreaName4());
                }
                if (input.hasRightPostCode1() && this.stringExists(input.getRightPostCode1())) {
                    segment.setRightPostalCode1(input.getRightPostCode1());
                }
                if (input.hasRightPostCode2() && this.stringExists(input.getRightPostCode2())) {
                    segment.setRightPostalCode2(input.getRightPostCode2());
                }
            }
            if (input.hasId() && this.stringExists(input.getId())) {
                segment.setId(input.getId());
            }
            if ((points = input.getPoints()) != null) {
                for (int i = 0; i < points.size(); ++i) {
                    segment.addPoint((DirectPosition)points.get(i));
                }
            }
            this.populateAlternateDataItems(segment, input, sac);
            if (!this.stringExists(segment.getLeftPostalCode1()) && this.stringExists(segment.getRightPostalCode1())) {
                segment.setLeftPostalCode1(segment.getRightPostalCode1());
            } else if (!this.stringExists(segment.getRightPostalCode1()) && this.stringExists(segment.getLeftPostalCode1())) {
                segment.setRightPostalCode1(segment.getLeftPostalCode1());
            }
            return segment;
        }
        return null;
    }

    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        return 0;
    }

    protected boolean isValidRange(String from, String to) {
        if (!this.stringExists(from) || !this.stringExists(to)) {
            return false;
        }
        return !to.equals("0") && !from.equals("0");
    }

    protected void populateAlternateDataItems(MMJRangeRecord range, IRangeDataSourceRecord input, int sac) throws DataSourceException {
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new MMJRangeRecord();
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord input, int sac) throws DataSourceException {
        DirectPosition rangePoint;
        IIntermediateDataRecord[] dataRecordArray;
        if (!this.m_bPointDataSource && input.hasFrom() != input.hasTo()) {
            throw new DataSourceException(16);
        }
        if (!(this.m_bPointDataSource || input.hasFrom() && this.stringExists(input.getFrom()) && input.hasTo() && this.stringExists(input.getTo()))) {
            return null;
        }
        String from = input.getFrom();
        String to = input.getTo();
        if (!this.m_bPointDataSource && !this.isValidRange(from, to)) {
            return null;
        }
        MMJRangeRecord range = this.makeRangeRecordType();
        range.setFromHouse(from);
        range.setToHouse(to);
        range.setOddEven(this.getOddEven(input));
        if (input.hasPlaceName() && this.stringExists(input.getPlaceName())) {
            range.setPlaceName(input.getPlaceName());
        }
        if (input.isLeft()) {
            range.setLeft();
        } else {
            range.setRight();
        }
        if (input instanceof IIntermediateRangeDataSourceRecord && (dataRecordArray = ((IIntermediateRangeDataSourceRecord)((Object)input)).getIntermediateRecordArray()) != null) {
            range.setIntermediateDataRecordArray(dataRecordArray);
        }
        if (range.getOddEven() == 5 && range.getIntermediateDataRecordArray() == null) {
            if (this.m_logWrongStructTypeErrors) {
                DataCreationLogger.getLogger().logInternalError("Input specified type as ODD_EVEN_IRREGULAR but no irregular house numbers were loaded.  Range will be treated as ODD_EVEN_BOTH. (sac=" + sac + ", isLeft=" + input.isLeft() + ", from=" + input.getFrom() + ", to=" + input.getTo() + ")");
            }
            range.setOddEven(0);
        }
        this.populateAlternateDataItems(range, input, sac);
        if (range.getFromHouse() != null && !range.getFromHouse().isEmpty() && range.getFromHouse().equals((Object)range.getToHouse()) && (rangePoint = input.getPoint()) != null) {
            range.setPoint(rangePoint);
        }
        if (input instanceof IAdditionalFieldsDataSourceRecord && ((IAdditionalFieldsDataSourceRecord)((Object)input)).hasAdditionalFields()) {
            range.setAdditionalFields(((IAdditionalFieldsDataSourceRecord)((Object)input)).getAdditionalFields());
        }
        return range;
    }

    protected void addRangesToSegment(MMJSegmentRecord segment, ISegmentDataSourceRecord input, int sac, boolean addLeft, boolean addRight) throws DataSourceException {
        MMJRangeRecord range;
        if (!addLeft && !addRight) {
            return;
        }
        ArrayList ranges = input.getRanges();
        if (ranges == null) {
            return;
        }
        for (int i = 0; i < ranges.size(); ++i) {
            IRangeDataSourceRecord inputRange = (IRangeDataSourceRecord)ranges.get(i);
            if ((!addLeft || !inputRange.isLeft()) && (!addRight || inputRange.isLeft())) continue;
            MMJRangeRecord range2 = null;
            try {
                range2 = this.convertRangeRecord(inputRange, sac);
            }
            catch (InvalidRangeStatusDataSourceException dsex) {
                DataCreationLogger.getLogger().logInternalError(dsex.getMessage());
            }
            if (range2 == null) continue;
            if (range2.isValid() || this.fixInvalidRange(range2)) {
                ArrayList units = inputRange.getUnits();
                if (units != null) {
                    for (int j = 0; j < units.size(); ++j) {
                        IUnitDataSourceRecord inputUnit = (IUnitDataSourceRecord)units.get(j);
                        MMJRangeUnitRecord unit = this.convertRangeUnitRecord(inputUnit, sac);
                        if (unit == null) continue;
                        range2.addRangeUnit(unit);
                    }
                }
                segment.addRange(range2);
                continue;
            }
            DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl::addRangesToSegment() - Range is not valid.  from:" + range2.getFromHouse().getCombinedAddressNumber() + " to: " + range2.getToHouse().getCombinedAddressNumber());
        }
        List segmentRanges = segment.getRanges();
        if (segmentRanges != null && segmentRanges.size() == 1 && (range = (MMJRangeRecord)segmentRanges.get(0)).getPoint() != null) {
            segment.setIsPointHouseSegment();
        }
    }

    protected boolean fixInvalidRange(MMJRangeRecord range) {
        boolean fixed = false;
        if (range.getFromHouse().getAddressNumberExists() && range.getToHouse().getAddressNumberExists()) {
            String msg = "StreetDataSourceRecordConvertorImpl::fixInvalidRange() - Fixing invalid range: ";
            msg = msg + "{" + range.getFromHouse().getCombinedAddressNumber() + " to " + range.getToHouse().getCombinedAddressNumber() + "}";
            msg = msg + " -> ";
            range.setFromHouse(String.valueOf(range.getFromHouse().getAddressNumber()));
            range.setToHouse(String.valueOf(range.getToHouse().getAddressNumber()));
            fixed = true;
            msg = msg + "{" + range.getFromHouse().getCombinedAddressNumber() + " to " + range.getToHouse().getCombinedAddressNumber() + "}";
            DataCreationLogger.getLogger().logInternalError(msg);
        }
        return fixed;
    }

    protected boolean isValidUnit(String lowUnit, String highUnit, String unitType) {
        return lowUnit != null || highUnit != null || unitType != null;
    }

    protected void populateAlternateDataItems(MMJRangeUnitRecord unit, IUnitDataSourceRecord input, int sac) throws DataSourceException {
    }

    protected MMJRangeUnitRecord makeRangeUnitRecordType() {
        return new MMJRangeUnitRecord();
    }

    protected MMJRangeUnitRecord convertRangeUnitRecord(IUnitDataSourceRecord input, int sac) throws DataSourceException {
        String lowUnit = null;
        String highUnit = null;
        String unitType = null;
        if (input.hasLowUnit() && this.stringExists(input.getLowUnit())) {
            lowUnit = input.getLowUnit();
        }
        if (input.hasHighUnit() && this.stringExists(input.getHighUnit())) {
            highUnit = input.getHighUnit();
        }
        if (input.hasUnitType() && this.stringExists(input.getUnitType())) {
            unitType = input.getUnitType();
        }
        if (!this.isValidUnit(lowUnit, highUnit, unitType)) {
            return null;
        }
        MMJRangeUnitRecord unit = this.makeRangeUnitRecordType();
        unit.setLowUnit(lowUnit);
        unit.setHighUnit(highUnit);
        unit.setUnitType(unitType);
        if (input.hasPlaceName() && this.stringExists(input.getPlaceName())) {
            unit.setPlaceName(input.getPlaceName());
        }
        this.populateAlternateDataItems(unit, input, sac);
        if (input instanceof IAdditionalFieldsDataSourceRecord && ((IAdditionalFieldsDataSourceRecord)((Object)input)).hasAdditionalFields()) {
            unit.setAdditionalFields(((IAdditionalFieldsDataSourceRecord)((Object)input)).getAdditionalFields());
        }
        return unit;
    }

    protected MapMarkerIndexKey makeStreetSearchKey(Address address, int sac) {
        MiSoundexKey sndxKey = (MiSoundexKey)this.makeSoundexKey(address.getMainAddress());
        if (sndxKey == null) {
            return null;
        }
        return new MiSoundexStreetDataIndexKey(sac, (ISoundexKey)sndxKey);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        String keyString = address.getMainAddress().toUpperCase();
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = keyString.charAt(0);
        MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey)};
        return keys;
    }

    protected MapMarkerIndexKey makeAlternateTypeSearchKey(String alternateSearchString, int sac) {
        MiSoundexKey sndxKey = (MiSoundexKey)this.makeSoundexKey(alternateSearchString);
        return new MiSoundexStreetDataIndexKey(sac, (ISoundexKey)sndxKey);
    }

    protected MapMarkerIndexKey makeAlternateTypeBrowseKey(String alternateBrowseString, int sac) {
        String keyString = alternateBrowseString.toUpperCase();
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = keyString.charAt(0);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
    }

    protected ISoundexKey makeSoundexKey(String soundexSource) {
        return this.m_soundex.getSoundex(soundexSource);
    }

    protected List getAllPossibleMainAddresses(IStreetDataSourceRecord input) throws DataSourceException {
        ArrayList<Address> list = new ArrayList<Address>();
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address addr = this.getParsedStreet(input, preParsed);
        if (addr != null) {
            String altMainAddress;
            list.add(addr);
            if (input.hasAlternateMainAddress() && (altMainAddress = input.getAlternateMainAddress()) != null && altMainAddress.trim().length() > 0) {
                preParsed.setMainAddress(this.makeMainAddressString(altMainAddress, "100"));
                addr = this.getParsedStreet(input, preParsed);
                if (addr != null) {
                    list.add(addr);
                }
            }
        }
        return list;
    }
}

